/*
 * Decompiled with CFR 0.152.
 */
package genj.crypto;

import java.io.IOException;

public abstract class Enigma {
    private static final String IMPL = "genj.crypto.EnigmaImpl";
    private static final String PREFIX = "[private]";
    private static boolean isAvailable = Enigma.getInstance("") != null;

    public static Enigma getInstance(String string) {
        try {
            return ((Enigma)Class.forName(IMPL).newInstance()).init(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean isAvailable() {
        return isAvailable;
    }

    public static boolean isEncrypted(String string) {
        return string.startsWith(PREFIX);
    }

    public String encrypt(String string) throws IOException {
        return PREFIX + this.encryptImpl(string);
    }

    public String decrypt(String string) throws IOException {
        if (!Enigma.isEncrypted(string)) {
            throw new IOException("Not an encrypted value");
        }
        return this.decryptImpl(string.substring(PREFIX.length()));
    }

    protected abstract Enigma init(String var1);

    protected abstract String encryptImpl(String var1) throws IOException;

    protected abstract String decryptImpl(String var1) throws IOException;
}

