/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.jfree.util.ObjectUtils;

public class ObjectTable
implements Serializable {
    private int rows;
    private int columns;
    private transient Object[][] data;
    private int rowIncrement;
    private int columnIncrement;

    public ObjectTable() {
        this(1);
    }

    public ObjectTable(int n) {
        this(n, n);
    }

    public ObjectTable(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("Increment must be positive.");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Increment must be positive.");
        }
        this.rows = 0;
        this.columns = 0;
        this.rowIncrement = n;
        this.columnIncrement = n2;
        this.data = new Object[n][];
    }

    public int getColumnIncrement() {
        return this.columnIncrement;
    }

    public int getRowIncrement() {
        return this.rowIncrement;
    }

    protected void ensureRowCapacity(int n) {
        if (n >= this.data.length) {
            Object[][] objectArray = new Object[n + this.rowIncrement][];
            System.arraycopy(this.data, 0, objectArray, 0, this.data.length);
            int n2 = this.data.length;
            while (n2 <= n) {
                objectArray[n2] = new Object[0];
                ++n2;
            }
            this.data = objectArray;
            this.rows = n + 1;
        }
    }

    public void ensureCapacity(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Row is invalid.");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Column is invalid.");
        }
        this.ensureRowCapacity(n);
        Object[] objectArray = this.data[n];
        if (n2 >= objectArray.length) {
            Object[] objectArray2 = new Object[n2 + this.columnIncrement];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            this.data[n] = objectArray2;
        }
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    protected Object getObject(int n, int n2) {
        Object[] objectArray;
        Object object = null;
        if (n < this.data.length && n2 < (objectArray = this.data[n]).length) {
            object = objectArray[n2];
        }
        return object;
    }

    protected void setObject(int n, int n2, Object object) {
        this.ensureCapacity(n, n2);
        this.data[n][n2] = object;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectTable)) {
            return false;
        }
        ObjectTable objectTable = (ObjectTable)object;
        if (this.getRowCount() != objectTable.getRowCount()) {
            return false;
        }
        if (this.getColumnCount() != objectTable.getColumnCount()) {
            return false;
        }
        int n = 0;
        while (n < this.getRowCount()) {
            int n2 = 0;
            while (n2 < this.getColumnCount()) {
                if (!ObjectUtils.equal(this.getObject(n, n2), objectTable.getObject(n, n2))) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = this.rows;
        n = 29 * n + this.columns;
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.data.length;
        objectOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = this.data[n2];
            int n3 = objectArray.length;
            objectOutputStream.writeInt(n3);
            int n4 = 0;
            while (n4 < n3) {
                this.writeSerializedData(objectOutputStream, objectArray[n4]);
                ++n4;
            }
            ++n2;
        }
    }

    protected void writeSerializedData(ObjectOutputStream objectOutputStream, Object object) throws IOException {
        objectOutputStream.writeObject(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.data = new Object[n][];
        int n2 = 0;
        while (n2 < n) {
            int n3 = objectInputStream.readInt();
            Object[] objectArray = new Object[n3];
            this.data[n2] = objectArray;
            int n4 = 0;
            while (n4 < n3) {
                objectArray[n4] = this.readSerializedData(objectInputStream);
                ++n4;
            }
            ++n2;
        }
    }

    protected Object readSerializedData(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        return objectInputStream.readObject();
    }

    public void clear() {
        this.rows = 0;
        this.columns = 0;
        int n = 0;
        while (n < this.data.length) {
            if (this.data[n] != null) {
                Arrays.fill(this.data[n], null);
            }
            ++n;
        }
    }
}

