/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashNMap
implements Serializable,
Cloneable {
    private static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    private HashMap table = new HashMap();

    public void put(Object object, Object object2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object2);
        this.table.put(object, arrayList);
    }

    public void add(Object object, Object object2) {
        ArrayList arrayList = (ArrayList)this.table.get(object);
        if (arrayList == null) {
            this.put(object, object2);
        } else {
            arrayList.add(object2);
        }
    }

    public Object getFirst(Object object) {
        return this.get(object, 0);
    }

    public Object get(Object object, int n) {
        ArrayList arrayList = (ArrayList)this.table.get(object);
        if (arrayList == null) {
            return null;
        }
        return arrayList.get(n);
    }

    public Iterator getAll(Object object) {
        ArrayList arrayList = (ArrayList)this.table.get(object);
        if (arrayList == null) {
            return EMPTY_ITERATOR;
        }
        return arrayList.iterator();
    }

    public Iterator keys() {
        return this.table.keySet().iterator();
    }

    public Set keySet() {
        return this.table.keySet();
    }

    public boolean remove(Object object, Object object2) {
        ArrayList arrayList = (ArrayList)this.table.get(object);
        if (arrayList == null) {
            return false;
        }
        if (!arrayList.remove(object2)) {
            return false;
        }
        if (arrayList.size() == 0) {
            this.table.remove(object);
        }
        return true;
    }

    public void removeAll(Object object) {
        this.table.remove(object);
    }

    public void clear() {
        this.table.clear();
    }

    public boolean containsKey(Object object) {
        return this.table.containsKey(object);
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.table.values().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            ArrayList arrayList = (ArrayList)iterator.next();
            bl = arrayList.contains(object);
        }
        return bl;
    }

    public boolean containsValue(Object object, Object object2) {
        ArrayList arrayList = (ArrayList)this.table.get(object);
        if (arrayList == null) {
            return false;
        }
        return arrayList.contains(object2);
    }

    public boolean contains(Object object) {
        if (this.containsKey(object)) {
            return true;
        }
        return this.containsValue(object);
    }

    public Object clone() throws CloneNotSupportedException {
        HashNMap hashNMap = (HashNMap)super.clone();
        hashNMap.table = new HashMap();
        Iterator iterator = this.keys();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ArrayList arrayList = (ArrayList)hashNMap.table.get(e);
            if (arrayList == null) continue;
            hashNMap.table.put(e, arrayList.clone());
        }
        return hashNMap;
    }

    public Object[] toArray(Object object, Object[] objectArray) {
        if (object == null) {
            throw new NullPointerException("Key must not be null.");
        }
        ArrayList arrayList = (ArrayList)this.table.get(object);
        if (arrayList != null) {
            return arrayList.toArray(objectArray);
        }
        return new Object[0];
    }

    public Object[] toArray(Object object) {
        if (object == null) {
            throw new NullPointerException("Key must not be null.");
        }
        ArrayList arrayList = (ArrayList)this.table.get(object);
        if (arrayList != null) {
            return arrayList.toArray();
        }
        return new Object[0];
    }

    public int getValueCount(Object object) {
        if (object == null) {
            throw new NullPointerException("Key must not be null.");
        }
        ArrayList arrayList = (ArrayList)this.table.get(object);
        if (arrayList != null) {
            return arrayList.size();
        }
        return 0;
    }

    private static final class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("This iterator is empty.");
        }

        public void remove() {
            throw new UnsupportedOperationException("This iterator is empty, no remove supported.");
        }
    }
}

