/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Spacer
implements Serializable {
    public static final int RELATIVE = 0;
    public static final int ABSOLUTE = 1;
    private int type;
    private double left;
    private double right;
    private double top;
    private double bottom;

    public Spacer(int n, double d, double d2, double d3, double d4) {
        this.type = n;
        this.left = d;
        this.top = d2;
        this.right = d3;
        this.bottom = d4;
    }

    public double getLeftSpace(double d) {
        double d2 = 0.0;
        if (this.type == 1) {
            d2 = this.left;
        } else if (this.type == 0) {
            d2 = this.left * d;
        }
        return d2;
    }

    public double getRightSpace(double d) {
        double d2 = 0.0;
        if (this.type == 1) {
            d2 = this.right;
        } else if (this.type == 0) {
            d2 = this.right * d;
        }
        return d2;
    }

    public double getTopSpace(double d) {
        double d2 = 0.0;
        if (this.type == 1) {
            d2 = this.top;
        } else if (this.type == 0) {
            d2 = this.top * d;
        }
        return d2;
    }

    public double getBottomSpace(double d) {
        double d2 = 0.0;
        if (this.type == 1) {
            d2 = this.bottom;
        } else if (this.type == 0) {
            d2 = this.bottom * d;
        }
        return d2;
    }

    public double getAdjustedWidth(double d) {
        double d2 = d;
        if (this.type == 1) {
            d2 = d2 + this.left + this.right;
        } else if (this.type == 0) {
            d2 = d2 + this.left * d + this.right * d;
        }
        return d2;
    }

    public double getAdjustedHeight(double d) {
        double d2 = d;
        if (this.type == 1) {
            d2 = d2 + this.top + this.bottom;
        } else if (this.type == 0) {
            d2 = d2 + this.top * d + this.bottom * d;
        }
        return d2;
    }

    public void trim(Rectangle2D rectangle2D) {
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getHeight();
        double d4 = rectangle2D.getWidth();
        double d5 = this.getLeftSpace(d4);
        double d6 = this.getRightSpace(d4);
        double d7 = this.getTopSpace(d3);
        double d8 = this.getBottomSpace(d3);
        rectangle2D.setRect(d + d5, d2 + d7, d4 - d5 - d6, d3 - d7 - d8);
    }

    public double trimWidth(double d) {
        return d - this.getLeftSpace(d) - this.getRightSpace(d);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Spacer) {
            boolean bl;
            Spacer spacer = (Spacer)object;
            boolean bl2 = this.type == spacer.type;
            boolean bl3 = this.left == spacer.left;
            boolean bl4 = this.right == spacer.right;
            boolean bl5 = this.top == spacer.top;
            boolean bl6 = bl = this.bottom == spacer.bottom;
            return bl2 && bl3 && bl4 && bl5 && bl;
        }
        return false;
    }
}

