/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.IntervalXYDelegate;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import org.jfree.util.ObjectUtils;

public class XYSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
DomainInfo,
Serializable {
    private List data = new ArrayList();
    private IntervalXYDelegate intervalDelegate = new IntervalXYDelegate(this, false);

    public XYSeriesCollection() {
        this(null);
    }

    public XYSeriesCollection(XYSeries xYSeries) {
        if (xYSeries != null) {
            this.data.add(xYSeries);
            xYSeries.addChangeListener(this);
        }
    }

    public void addSeries(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(xYSeries);
        this.intervalDelegate.seriesAdded(this.data.size() - 1);
        xYSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds.");
        }
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        xYSeries.removeChangeListener(this);
        this.data.remove(n);
        this.intervalDelegate.seriesRemoved();
        this.fireDatasetChanged();
    }

    public void removeSeries(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        if (this.data.contains(xYSeries)) {
            xYSeries.removeChangeListener(this);
            this.data.remove(xYSeries);
            this.intervalDelegate.seriesRemoved();
            this.fireDatasetChanged();
        }
    }

    public void removeAllSeries() {
        int n = 0;
        while (n < this.data.size()) {
            XYSeries xYSeries = (XYSeries)this.data.get(n);
            xYSeries.removeChangeListener(this);
            ++n;
        }
        this.data.clear();
        this.intervalDelegate.seriesRemoved();
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public List getSeries() {
        return Collections.unmodifiableList(this.data);
    }

    public XYSeries getSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (XYSeries)this.data.get(n);
    }

    public String getSeriesName(int n) {
        return this.getSeries(n).getName();
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getX(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        XYDataItem xYDataItem = xYSeries.getDataItem(n2);
        return xYDataItem.getX();
    }

    public Number getStartX(int n, int n2) {
        return this.intervalDelegate.getStartX(n, n2);
    }

    public Number getEndX(int n, int n2) {
        return this.intervalDelegate.getEndX(n, n2);
    }

    public Number getY(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        XYDataItem xYDataItem = xYSeries.getDataItem(n2);
        return xYDataItem.getY();
    }

    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYSeriesCollection)) {
            return false;
        }
        XYSeriesCollection xYSeriesCollection = (XYSeriesCollection)object;
        return ObjectUtils.equal(this.data, xYSeriesCollection.data);
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }

    public Range getDomainRange() {
        return this.intervalDelegate.getDomainRange();
    }

    public Number getMaximumDomainValue() {
        return this.intervalDelegate.getMaximumDomainValue();
    }

    public Number getMinimumDomainValue() {
        return this.intervalDelegate.getMinimumDomainValue();
    }

    public double getIntervalWidth() {
        return this.intervalDelegate.getIntervalWidth();
    }

    public void setIntervalWidth(double d) {
        this.intervalDelegate.setIntervalWidth(d);
        this.fireDatasetChanged();
    }

    public double getIntervalPositionFactor() {
        return this.intervalDelegate.getIntervalPositionFactor();
    }

    public void setIntervalPositionFactor(double d) {
        this.intervalDelegate.setIntervalPositionFactor(d);
        this.fireDatasetChanged();
    }

    public boolean isAutoWidth() {
        return this.intervalDelegate.isAutoWidth();
    }

    public void setAutoWidth(boolean bl) {
        this.intervalDelegate.setAutoWidth(bl);
        this.fireDatasetChanged();
    }
}

