/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.data.general.Series;
import org.jfree.data.general.SeriesException;
import org.jfree.data.xy.XYDataItem;
import org.jfree.util.ObjectUtils;

public class XYSeries
extends Series
implements Cloneable,
Serializable {
    protected List data;
    private int maximumItemCount = Integer.MAX_VALUE;
    private boolean autoSort;
    private boolean allowDuplicateXValues;

    public XYSeries(String string) {
        this(string, true, true);
    }

    public XYSeries(String string, boolean bl, boolean bl2) {
        super(string);
        this.data = new ArrayList();
        this.autoSort = bl;
        this.allowDuplicateXValues = bl2;
    }

    public boolean getAutoSort() {
        return this.autoSort;
    }

    public boolean getAllowDuplicateXValues() {
        return this.allowDuplicateXValues;
    }

    public int getItemCount() {
        return this.data.size();
    }

    public List getItems() {
        return Collections.unmodifiableList(this.data);
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n) {
        this.maximumItemCount = n;
    }

    public void add(XYDataItem xYDataItem) {
        this.add(xYDataItem, true);
    }

    public void add(XYDataItem xYDataItem, boolean bl) {
        if (xYDataItem == null) {
            throw new IllegalArgumentException("Null 'item' argument.");
        }
        int n = Collections.binarySearch(this.data, xYDataItem);
        if (n < 0) {
            if (this.autoSort) {
                this.data.add(-n - 1, xYDataItem);
            } else {
                this.data.add(xYDataItem);
            }
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
        } else if (this.allowDuplicateXValues) {
            if (this.autoSort) {
                this.data.add(n, xYDataItem);
            } else {
                this.data.add(xYDataItem);
            }
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
        } else {
            throw new SeriesException("XYSeries.add(...): x-value already exists.");
        }
        if (bl) {
            this.fireSeriesChanged();
        }
    }

    public void add(double d, double d2) {
        this.add(new Double(d), (Number)new Double(d2), true);
    }

    public void add(double d, double d2, boolean bl) {
        this.add(new Double(d), (Number)new Double(d2), bl);
    }

    public void add(double d, Number number) {
        this.add(new Double(d), number);
    }

    public void add(double d, Number number, boolean bl) {
        this.add(new Double(d), number, bl);
    }

    public void add(Number number, Number number2) {
        this.add(number, number2, true);
    }

    public void add(Number number, Number number2, boolean bl) {
        if (number == null) {
            throw new IllegalArgumentException("Null 'x' argument.");
        }
        XYDataItem xYDataItem = new XYDataItem(number, number2);
        this.add(xYDataItem, bl);
    }

    public void delete(int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            this.data.remove(n);
            ++n3;
        }
        this.fireSeriesChanged();
    }

    public XYDataItem remove(int n) {
        return (XYDataItem)this.data.remove(n);
    }

    public XYDataItem remove(Number number) {
        return this.remove(this.indexOf(number));
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.fireSeriesChanged();
        }
    }

    public XYDataItem getDataItem(int n) {
        return (XYDataItem)this.data.get(n);
    }

    public Number getX(int n) {
        return this.getDataItem(n).getX();
    }

    public Number getY(int n) {
        return this.getDataItem(n).getY();
    }

    public void update(int n, Number number) {
        XYDataItem xYDataItem = this.getDataItem(n);
        xYDataItem.setY(number);
        this.fireSeriesChanged();
    }

    public int indexOf(Number number) {
        return Collections.binarySearch(this.data, new XYDataItem(number, null));
    }

    public Object clone() throws CloneNotSupportedException {
        XYSeries xYSeries = this.createCopy(0, this.getItemCount() - 1);
        return xYSeries;
    }

    public XYSeries createCopy(int n, int n2) throws CloneNotSupportedException {
        XYSeries xYSeries = (XYSeries)super.clone();
        xYSeries.data = new ArrayList();
        if (this.data.size() > 0) {
            int n3 = n;
            while (n3 <= n2) {
                XYDataItem xYDataItem = (XYDataItem)this.data.get(n3);
                XYDataItem xYDataItem2 = (XYDataItem)xYDataItem.clone();
                try {
                    xYSeries.add(xYDataItem2);
                }
                catch (SeriesException seriesException) {
                    System.err.println("XYSeries.createCopy(): unable to add cloned data pair.");
                }
                ++n3;
            }
        }
        return xYSeries;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof XYSeries)) {
            return false;
        }
        XYSeries xYSeries = (XYSeries)object;
        if (this.maximumItemCount != xYSeries.maximumItemCount) {
            return false;
        }
        if (this.autoSort != xYSeries.autoSort) {
            return false;
        }
        if (this.allowDuplicateXValues != xYSeries.allowDuplicateXValues) {
            return false;
        }
        return ObjectUtils.equal(this.data, xYSeries.data);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 29 * n + (this.data != null ? this.data.hashCode() : 0);
        n = 29 * n + this.maximumItemCount;
        n = 29 * n + (this.autoSort ? 1 : 0);
        n = 29 * n + (this.allowDuplicateXValues ? 1 : 0);
        return n;
    }
}

