/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.xy.XYDataset;

public class XYDatasetTableModel
extends AbstractTableModel
implements TableModel,
DatasetChangeListener {
    XYDataset model = null;

    public XYDatasetTableModel() {
    }

    public XYDatasetTableModel(XYDataset xYDataset) {
        this();
        this.setModel(xYDataset);
    }

    public void setModel(XYDataset xYDataset) {
        this.model = xYDataset;
        this.model.addChangeListener(this);
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getItemCount(0);
    }

    public int getColumnCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getSeriesCount() + 1;
    }

    public String getColumnName(int n) {
        if (this.model == null) {
            return super.getColumnName(n);
        }
        if (n < 1) {
            return "X Value";
        }
        return this.model.getSeriesName(n - 1);
    }

    public Object getValueAt(int n, int n2) {
        if (this.model == null) {
            return null;
        }
        if (n2 < 1) {
            return this.model.getX(0, n);
        }
        return this.model.getY(n, n2 - 1);
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        this.isCellEditable(n, n2);
    }
}

