/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.util.Date;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.OHLCDataset;

public class DefaultHighLowDataset
extends AbstractXYDataset
implements OHLCDataset {
    private String seriesName;
    private Date[] date;
    private Number[] high;
    private Number[] low;
    private Number[] open;
    private Number[] close;
    private Number[] volume;

    public DefaultHighLowDataset(String string, Date[] dateArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        this.seriesName = string;
        this.date = dateArray;
        this.high = DefaultHighLowDataset.createNumberArray(dArray);
        this.low = DefaultHighLowDataset.createNumberArray(dArray2);
        this.open = DefaultHighLowDataset.createNumberArray(dArray3);
        this.close = DefaultHighLowDataset.createNumberArray(dArray4);
        this.volume = DefaultHighLowDataset.createNumberArray(dArray5);
    }

    public String getSeriesName(int n) {
        return this.seriesName;
    }

    public Number getX(int n, int n2) {
        return new Long(this.date[n2].getTime());
    }

    public Date getXDate(int n, int n2) {
        return this.date[n2];
    }

    public Number getY(int n, int n2) {
        return this.getClose(n, n2);
    }

    public Number getHigh(int n, int n2) {
        return this.high[n2];
    }

    public double getHighValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getHigh(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getLow(int n, int n2) {
        return this.low[n2];
    }

    public double getLowValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getLow(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getOpen(int n, int n2) {
        return this.open[n2];
    }

    public double getOpenValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getOpen(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getClose(int n, int n2) {
        return this.close[n2];
    }

    public double getCloseValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getClose(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getVolume(int n, int n2) {
        return this.volume[n2];
    }

    public double getVolumeValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getVolume(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public int getSeriesCount() {
        return 1;
    }

    public int getItemCount(int n) {
        return this.date.length;
    }

    public static Number[] createNumberArray(double[] dArray) {
        Number[] numberArray = new Number[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            numberArray[n] = new Double(dArray[n]);
            ++n;
        }
        return numberArray;
    }
}

