/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import org.jfree.data.DefaultKeyedValues2D;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.IntervalXYDelegate;
import org.jfree.data.xy.TableXYDataset;

public class CategoryTableXYDataset
extends AbstractIntervalXYDataset
implements TableXYDataset,
IntervalXYDataset,
DomainInfo {
    private DefaultKeyedValues2D values = new DefaultKeyedValues2D(true);
    private IntervalXYDelegate intervalDelegate = new IntervalXYDelegate(this);

    public void add(double d, double d2, String string) {
        this.add(new Double(d), new Double(d2), string, true);
    }

    public void add(Number number, Number number2, String string, boolean bl) {
        this.values.addValue(number2, (Comparable)((Object)number), (Comparable)((Object)string));
        int n = this.values.getColumnIndex((Comparable)((Object)string));
        int n2 = this.values.getRowIndex((Comparable)((Object)number));
        this.intervalDelegate.itemAdded(n, n2);
        if (bl) {
            this.fireDatasetChanged();
        }
    }

    public void remove(double d, String string) {
        this.remove(new Double(d), string, true);
    }

    public void remove(Number number, String string, boolean bl) {
        this.values.removeValue((Comparable)((Object)number), (Comparable)((Object)string));
        this.intervalDelegate.itemRemoved(number.doubleValue());
        if (bl) {
            this.fireDatasetChanged();
        }
    }

    public int getSeriesCount() {
        return this.values.getColumnCount();
    }

    public String getSeriesName(int n) {
        return this.values.getColumnKey(n).toString();
    }

    public int getItemCount() {
        return this.values.getRowCount();
    }

    public int getItemCount(int n) {
        return this.getItemCount();
    }

    public Number getX(int n, int n2) {
        return (Number)((Object)this.values.getRowKey(n2));
    }

    public Number getStartX(int n, int n2) {
        return this.intervalDelegate.getStartX(n, n2);
    }

    public Number getEndX(int n, int n2) {
        return this.intervalDelegate.getEndX(n, n2);
    }

    public Number getY(int n, int n2) {
        return this.values.getValue(n2, n);
    }

    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    public Range getDomainRange() {
        return this.intervalDelegate.getDomainRange();
    }

    public Number getMaximumDomainValue() {
        return this.intervalDelegate.getMaximumDomainValue();
    }

    public Number getMinimumDomainValue() {
        return this.intervalDelegate.getMinimumDomainValue();
    }

    public double getIntervalPositionFactor() {
        return this.intervalDelegate.getIntervalPositionFactor();
    }

    public void setIntervalPositionFactor(double d) {
        this.intervalDelegate.setIntervalPositionFactor(d);
        this.fireDatasetChanged();
    }

    public double getIntervalWidth() {
        return this.intervalDelegate.getIntervalWidth();
    }

    public void setIntervalWidth(double d) {
        this.intervalDelegate.setIntervalWidth(d);
        this.fireDatasetChanged();
    }

    public boolean isAutoWidth() {
        return this.intervalDelegate.isAutoWidth();
    }

    public void setAutoWidth(boolean bl) {
        this.intervalDelegate.setAutoWidth(bl);
        this.fireDatasetChanged();
    }
}

