/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.util.ObjectUtils;

public class Series
implements Cloneable,
Serializable {
    private String name;
    private String description;
    private EventListenerList listeners;
    private PropertyChangeSupport propertyChangeSupport;
    private boolean notify;
    static /* synthetic */ Class class$0;

    protected Series(String string) {
        this(string, null);
    }

    protected Series(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'name' argument.");
        }
        this.name = string;
        this.description = string2;
        this.listeners = new EventListenerList();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.notify = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'name' argument.");
        }
        String string2 = this.name;
        this.name = string;
        this.propertyChangeSupport.firePropertyChange("Name", string2, string);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        this.propertyChangeSupport.firePropertyChange("Description", string2, string);
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean bl) {
        if (this.notify != bl) {
            this.notify = bl;
            this.fireSeriesChanged();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            Series series = (Series)super.clone();
            series.listeners = new EventListenerList();
            series.propertyChangeSupport = new PropertyChangeSupport(series);
            return series;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CloneNotSupportedException("Series.clone(): unexpected exception.");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Series)) {
            return false;
        }
        Series series = (Series)object;
        if (!this.getName().equals(series.getName())) {
            return false;
        }
        return ObjectUtils.equal(this.getDescription(), series.getDescription());
    }

    public int hashCode() {
        int n = this.name.hashCode();
        n = 29 * n + (this.description != null ? this.description.hashCode() : 0);
        return n;
    }

    public void addChangeListener(SeriesChangeListener seriesChangeListener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.general.SeriesChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listeners.add(clazz, seriesChangeListener);
    }

    public void removeChangeListener(SeriesChangeListener seriesChangeListener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.general.SeriesChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listeners.remove(clazz, seriesChangeListener);
    }

    public void fireSeriesChanged() {
        if (this.notify) {
            this.notifyListeners(new SeriesChangeEvent(this));
        }
    }

    protected void notifyListeners(SeriesChangeEvent seriesChangeEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            Object object = objectArray[n];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.jfree.data.general.SeriesChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((SeriesChangeListener)objectArray[n + 1]).seriesChanged(seriesChangeEvent);
            }
            n -= 2;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }
}

