/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.DomainInfo;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.KeyedValues;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.ArrayUtils;

public final class DatasetUtilities {
    private DatasetUtilities() {
    }

    public static Number[] createNumberArray(double[] dArray) {
        Number[] numberArray = new Number[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            numberArray[n] = new Double(dArray[n]);
            ++n;
        }
        return numberArray;
    }

    public static Number[][] createNumberArray2D(double[][] dArray) {
        int n = dArray.length;
        Number[][] numberArray = new Number[n][];
        int n2 = 0;
        while (n2 < n) {
            numberArray[n2] = DatasetUtilities.createNumberArray(dArray[n2]);
            ++n2;
        }
        return numberArray;
    }

    public static double calculatePieDatasetTotal(PieDataset pieDataset) {
        if (pieDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        List list = pieDataset.getKeys();
        double d = 0.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Comparable comparable = (Comparable)iterator.next();
            if (comparable == null) continue;
            Number number = pieDataset.getValue(comparable);
            double d2 = 0.0;
            if (number != null) {
                d2 = number.doubleValue();
            }
            if (!(d2 > 0.0)) continue;
            d += d2;
        }
        return d;
    }

    public static PieDataset createPieDatasetForRow(CategoryDataset categoryDataset, Comparable comparable) {
        int n = categoryDataset.getRowIndex(comparable);
        return DatasetUtilities.createPieDatasetForRow(categoryDataset, n);
    }

    public static PieDataset createPieDatasetForRow(CategoryDataset categoryDataset, int n) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        int n2 = categoryDataset.getColumnCount();
        int n3 = 0;
        while (n3 < n2) {
            Comparable comparable = categoryDataset.getColumnKey(n3);
            defaultPieDataset.setValue(comparable, categoryDataset.getValue(n, n3));
            ++n3;
        }
        return defaultPieDataset;
    }

    public static PieDataset createPieDatasetForColumn(CategoryDataset categoryDataset, Comparable comparable) {
        int n = categoryDataset.getColumnIndex(comparable);
        return DatasetUtilities.createPieDatasetForColumn(categoryDataset, n);
    }

    public static PieDataset createPieDatasetForColumn(CategoryDataset categoryDataset, int n) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        int n2 = categoryDataset.getRowCount();
        int n3 = 0;
        while (n3 < n2) {
            Comparable comparable = categoryDataset.getRowKey(n3);
            defaultPieDataset.setValue(comparable, categoryDataset.getValue(n3, n));
            ++n3;
        }
        return defaultPieDataset;
    }

    public static PieDataset limitPieDataset(PieDataset pieDataset, double d) {
        return DatasetUtilities.limitPieDataset(pieDataset, d, 2, (Comparable)((Object)"Other"));
    }

    public static PieDataset limitPieDataset(PieDataset pieDataset, double d, int n) {
        return DatasetUtilities.limitPieDataset(pieDataset, d, n, (Comparable)((Object)"Other"));
    }

    public static PieDataset limitPieDataset(PieDataset pieDataset, double d, int n, Comparable comparable) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        double d2 = DatasetUtilities.calculatePieDatasetTotal(pieDataset);
        List list = pieDataset.getKeys();
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            double d3;
            Comparable comparable2 = (Comparable)iterator.next();
            Number number = pieDataset.getValue(comparable2);
            if (number == null || !((d3 = number.doubleValue()) / d2 < d)) continue;
            arrayList.add(comparable2);
        }
        iterator = list.iterator();
        double d4 = 0.0;
        while (iterator.hasNext()) {
            Comparable comparable3 = (Comparable)iterator.next();
            Number number = pieDataset.getValue(comparable3);
            if (number == null) continue;
            if (arrayList.contains(comparable3) && arrayList.size() >= n) {
                d4 += number.doubleValue();
                continue;
            }
            defaultPieDataset.setValue(comparable3, number);
        }
        if (arrayList.size() >= n) {
            defaultPieDataset.setValue(comparable, d4);
        }
        return defaultPieDataset;
    }

    public static CategoryDataset createCategoryDataset(String string, String string2, double[][] dArray) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        int n = 0;
        while (n < dArray.length) {
            String string3 = String.valueOf(string) + (n + 1);
            int n2 = 0;
            while (n2 < dArray[n].length) {
                String string4 = String.valueOf(string2) + (n2 + 1);
                defaultCategoryDataset.addValue(new Double(dArray[n][n2]), (Comparable)((Object)string3), (Comparable)((Object)string4));
                ++n2;
            }
            ++n;
        }
        return defaultCategoryDataset;
    }

    public static CategoryDataset createCategoryDataset(String string, String string2, Number[][] numberArray) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        int n = 0;
        while (n < numberArray.length) {
            String string3 = String.valueOf(string) + (n + 1);
            int n2 = 0;
            while (n2 < numberArray[n].length) {
                String string4 = String.valueOf(string2) + (n2 + 1);
                defaultCategoryDataset.addValue(numberArray[n][n2], (Comparable)((Object)string3), (Comparable)((Object)string4));
                ++n2;
            }
            ++n;
        }
        return defaultCategoryDataset;
    }

    public static CategoryDataset createCategoryDataset(String[] stringArray, String[] stringArray2, double[][] dArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Null 'rowKeys' argument.");
        }
        if (stringArray2 == null) {
            throw new IllegalArgumentException("Null 'columnKeys' argument.");
        }
        if (ArrayUtils.hasDuplicateItems(stringArray)) {
            throw new IllegalArgumentException("Duplicate items in 'rowKeys'.");
        }
        if (ArrayUtils.hasDuplicateItems(stringArray2)) {
            throw new IllegalArgumentException("Duplicate items in 'columnKeys'.");
        }
        if (stringArray.length != dArray.length) {
            throw new IllegalArgumentException("The number of row keys does not match the number of rows in the data array.");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            n = Math.max(n, dArray[n2].length);
            ++n2;
        }
        if (stringArray2.length != n) {
            throw new IllegalArgumentException("The number of column keys does not match the number of columns in the data array.");
        }
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        int n3 = 0;
        while (n3 < dArray.length) {
            String string = stringArray[n3];
            int n4 = 0;
            while (n4 < dArray[n3].length) {
                String string2 = stringArray2[n4];
                defaultCategoryDataset.addValue(new Double(dArray[n3][n4]), (Comparable)((Object)string), (Comparable)((Object)string2));
                ++n4;
            }
            ++n3;
        }
        return defaultCategoryDataset;
    }

    public static CategoryDataset createCategoryDataset(String string, KeyedValues keyedValues) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'rowKey' argument.");
        }
        if (keyedValues == null) {
            throw new IllegalArgumentException("Null 'rowData' argument.");
        }
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        int n = 0;
        while (n < keyedValues.getItemCount()) {
            defaultCategoryDataset.addValue(keyedValues.getValue(n), (Comparable)((Object)string), keyedValues.getKey(n));
            ++n;
        }
        return defaultCategoryDataset;
    }

    public static boolean isEmptyOrNull(PieDataset pieDataset) {
        if (pieDataset == null) {
            return true;
        }
        int n = pieDataset.getItemCount();
        if (n == 0) {
            return true;
        }
        int n2 = 0;
        while (n2 < n) {
            double d;
            Number number = pieDataset.getValue(n2);
            if (number != null && (d = number.doubleValue()) > 0.0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isEmptyOrNull(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            return true;
        }
        int n = categoryDataset.getRowCount();
        int n2 = categoryDataset.getColumnCount();
        if (n == 0 || n2 == 0) {
            return true;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                if (categoryDataset.getValue(n3, n4) != null) {
                    return false;
                }
                ++n4;
            }
            ++n3;
        }
        return true;
    }

    public static boolean isEmptyOrNull(XYDataset xYDataset) {
        boolean bl = true;
        if (xYDataset != null) {
            int n = 0;
            while (n < xYDataset.getSeriesCount()) {
                if (xYDataset.getItemCount(n) > 0) {
                    bl = false;
                }
                ++n;
            }
        }
        return bl;
    }

    public static Range findDomainExtent(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range range = null;
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            range = domainInfo.getDomainRange();
        } else {
            range = DatasetUtilities.iterateDomainExtent(xYDataset);
        }
        return range;
    }

    public static Range iterateDomainExtent(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = xYDataset.getItemCount(n2);
            int n4 = 0;
            while (n4 < n3) {
                double d3;
                double d4;
                if (xYDataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
                    d4 = intervalXYDataset.getStartXValue(n2, n4);
                    d3 = intervalXYDataset.getEndXValue(n2, n4);
                } else {
                    d3 = d4 = xYDataset.getXValue(n2, n4);
                }
                d = Math.min(d, d4);
                d2 = Math.max(d2, d3);
                ++n4;
            }
            ++n2;
        }
        if (d > d2) {
            return null;
        }
        return new Range(d, d2);
    }

    public static Range findRangeExtent(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range range = null;
        if (categoryDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)categoryDataset);
            range = rangeInfo.getValueRange();
        } else {
            range = DatasetUtilities.iterateCategoryRangeExtent(categoryDataset);
        }
        return range;
    }

    public static Range findRangeExtent(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range range = null;
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            range = rangeInfo.getValueRange();
        } else {
            range = DatasetUtilities.iterateXYRangeExtent(xYDataset);
        }
        return range;
    }

    public static Range iterateCategoryRangeExtent(CategoryDataset categoryDataset) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = categoryDataset.getRowCount();
        int n2 = categoryDataset.getColumnCount();
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                Number number;
                Number number2;
                if (categoryDataset instanceof IntervalCategoryDataset) {
                    IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
                    number2 = intervalCategoryDataset.getStartValue(n3, n4);
                    number = intervalCategoryDataset.getEndValue(n3, n4);
                } else {
                    number = number2 = categoryDataset.getValue(n3, n4);
                }
                if (number2 != null) {
                    d = Math.min(d, number2.doubleValue());
                }
                if (number != null) {
                    d2 = Math.max(d2, number.doubleValue());
                }
                ++n4;
            }
            ++n3;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d, d2);
    }

    public static Range iterateXYRangeExtent(XYDataset xYDataset) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = xYDataset.getItemCount(n2);
            int n4 = 0;
            while (n4 < n3) {
                double d3;
                double d4;
                XYDataset xYDataset2;
                if (xYDataset instanceof IntervalXYDataset) {
                    xYDataset2 = (IntervalXYDataset)xYDataset;
                    d4 = xYDataset2.getStartYValue(n2, n4);
                    d3 = xYDataset2.getEndYValue(n2, n4);
                } else if (xYDataset instanceof OHLCDataset) {
                    xYDataset2 = (OHLCDataset)xYDataset;
                    d4 = xYDataset2.getLowValue(n2, n4);
                    d3 = xYDataset2.getHighValue(n2, n4);
                } else {
                    d3 = d4 = xYDataset.getYValue(n2, n4);
                }
                if (!Double.isNaN(d4)) {
                    d = Math.min(d, d4);
                }
                if (!Double.isNaN(d3)) {
                    d2 = Math.max(d2, d3);
                }
                ++n4;
            }
            ++n2;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d, d2);
    }

    public static Number findMinimumDomainValue(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Double d = null;
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            return domainInfo.getMinimumDomainValue();
        }
        double d2 = Double.POSITIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = xYDataset.getItemCount(n2);
            int n4 = 0;
            while (n4 < n3) {
                double d3;
                if (xYDataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
                    d3 = intervalXYDataset.getStartXValue(n2, n4);
                } else {
                    d3 = xYDataset.getXValue(n2, n4);
                }
                if (!Double.isNaN(d3)) {
                    d2 = Math.min(d2, d3);
                }
                ++n4;
            }
            ++n2;
        }
        d = d2 == Double.POSITIVE_INFINITY ? null : new Double(d2);
        return d;
    }

    public static Number findMaximumDomainValue(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Double d = null;
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            return domainInfo.getMaximumDomainValue();
        }
        double d2 = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = xYDataset.getItemCount(n2);
            int n4 = 0;
            while (n4 < n3) {
                double d3;
                if (xYDataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
                    d3 = intervalXYDataset.getEndXValue(n2, n4);
                } else {
                    d3 = xYDataset.getXValue(n2, n4);
                }
                if (!Double.isNaN(d3)) {
                    d2 = Math.max(d2, d3);
                }
                ++n4;
            }
            ++n2;
        }
        d = d2 == Double.NEGATIVE_INFINITY ? null : new Double(d2);
        return d;
    }

    public static Number findMinimumRangeValue(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (categoryDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)categoryDataset);
            return rangeInfo.getMinimumRangeValue();
        }
        double d = Double.POSITIVE_INFINITY;
        int n = categoryDataset.getRowCount();
        int n2 = categoryDataset.getColumnCount();
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                Number number;
                if (categoryDataset instanceof IntervalCategoryDataset) {
                    IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
                    number = intervalCategoryDataset.getStartValue(n3, n4);
                } else {
                    number = categoryDataset.getValue(n3, n4);
                }
                if (number != null) {
                    d = Math.min(d, number.doubleValue());
                }
                ++n4;
            }
            ++n3;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Double(d);
    }

    public static Number findMinimumRangeValue(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            return rangeInfo.getMinimumRangeValue();
        }
        double d = Double.POSITIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = xYDataset.getItemCount(n2);
            int n4 = 0;
            while (n4 < n3) {
                double d2;
                XYDataset xYDataset2;
                if (xYDataset instanceof IntervalXYDataset) {
                    xYDataset2 = (IntervalXYDataset)xYDataset;
                    d2 = xYDataset2.getStartYValue(n2, n4);
                } else if (xYDataset instanceof OHLCDataset) {
                    xYDataset2 = (OHLCDataset)xYDataset;
                    d2 = xYDataset2.getLowValue(n2, n4);
                } else {
                    d2 = xYDataset.getYValue(n2, n4);
                }
                if (!Double.isNaN(d2)) {
                    d = Math.min(d, d2);
                }
                ++n4;
            }
            ++n2;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Double(d);
    }

    public static Number findMaximumRangeValue(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (categoryDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)categoryDataset);
            return rangeInfo.getMaximumRangeValue();
        }
        double d = Double.NEGATIVE_INFINITY;
        int n = categoryDataset.getRowCount();
        int n2 = categoryDataset.getColumnCount();
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                Number number;
                if (categoryDataset instanceof IntervalCategoryDataset) {
                    IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
                    number = intervalCategoryDataset.getEndValue(n3, n4);
                } else {
                    number = categoryDataset.getValue(n3, n4);
                }
                if (number != null) {
                    d = Math.max(d, number.doubleValue());
                }
                ++n4;
            }
            ++n3;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return new Double(d);
    }

    public static Number findMaximumRangeValue(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            return rangeInfo.getMaximumRangeValue();
        }
        double d = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = xYDataset.getItemCount(n2);
            int n4 = 0;
            while (n4 < n3) {
                double d2;
                XYDataset xYDataset2;
                if (xYDataset instanceof IntervalXYDataset) {
                    xYDataset2 = (IntervalXYDataset)xYDataset;
                    d2 = xYDataset2.getEndYValue(n2, n4);
                } else if (xYDataset instanceof OHLCDataset) {
                    xYDataset2 = (OHLCDataset)xYDataset;
                    d2 = xYDataset2.getHighValue(n2, n4);
                } else {
                    d2 = xYDataset.getYValue(n2, n4);
                }
                if (!Double.isNaN(d2)) {
                    d = Math.max(d, d2);
                }
                ++n4;
            }
            ++n2;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return new Double(d);
    }

    public static Range findStackedRangeExtent(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range range = null;
        double d = 0.0;
        double d2 = 0.0;
        int n = categoryDataset.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            double d3 = 0.0;
            double d4 = 0.0;
            int n3 = categoryDataset.getRowCount();
            int n4 = 0;
            while (n4 < n3) {
                Number number = categoryDataset.getValue(n4, n2);
                if (number != null) {
                    double d5 = number.doubleValue();
                    if (d5 > 0.0) {
                        d3 += d5;
                    }
                    if (d5 < 0.0) {
                        d4 += d5;
                    }
                }
                ++n4;
            }
            d = Math.min(d, d4);
            d2 = Math.max(d2, d3);
            ++n2;
        }
        range = new Range(d, d2);
        return range;
    }

    public static Range findStackedRangeExtent(CategoryDataset categoryDataset, KeyToGroupMap keyToGroupMap) {
        Range range = null;
        if (categoryDataset != null) {
            int[] nArray = new int[categoryDataset.getRowCount()];
            int n = 0;
            while (n < categoryDataset.getRowCount()) {
                nArray[n] = keyToGroupMap.getGroupIndex(keyToGroupMap.getGroup(categoryDataset.getRowKey(n)));
                ++n;
            }
            n = keyToGroupMap.getGroupCount();
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            int n2 = categoryDataset.getColumnCount();
            int n3 = 0;
            while (n3 < n2) {
                double[] dArray3 = new double[n];
                double[] dArray4 = new double[n];
                int n4 = categoryDataset.getRowCount();
                int n5 = 0;
                while (n5 < n4) {
                    Number number = categoryDataset.getValue(n5, n3);
                    if (number != null) {
                        double d = number.doubleValue();
                        if (d > 0.0) {
                            dArray3[nArray[n5]] = dArray3[nArray[n5]] + d;
                        }
                        if (d < 0.0) {
                            dArray4[nArray[n5]] = dArray4[nArray[n5]] + d;
                        }
                    }
                    ++n5;
                }
                n5 = 0;
                while (n5 < n) {
                    dArray[n5] = Math.min(dArray[n5], dArray4[n5]);
                    dArray2[n5] = Math.max(dArray2[n5], dArray3[n5]);
                    ++n5;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < n) {
                range = Range.combine(range, new Range(dArray[n3], dArray2[n3]));
                ++n3;
            }
        }
        return range;
    }

    public static Number findMinimumStackedRangeValue(CategoryDataset categoryDataset) {
        Double d = null;
        if (categoryDataset != null) {
            double d2 = 0.0;
            int n = categoryDataset.getRowCount();
            int n2 = 0;
            while (n2 < n) {
                double d3 = 0.0;
                int n3 = categoryDataset.getColumnCount();
                int n4 = 0;
                while (n4 < n3) {
                    double d4;
                    Number number = categoryDataset.getValue(n4, n2);
                    if (number != null && (d4 = number.doubleValue()) < 0.0) {
                        d3 += d4;
                    }
                    ++n4;
                }
                d2 = Math.min(d2, d3);
                ++n2;
            }
            d = new Double(d2);
        }
        return d;
    }

    public static Number findMaximumStackedRangeValue(CategoryDataset categoryDataset) {
        Double d = null;
        if (categoryDataset != null) {
            double d2 = 0.0;
            int n = categoryDataset.getColumnCount();
            int n2 = 0;
            while (n2 < n) {
                double d3 = 0.0;
                int n3 = categoryDataset.getRowCount();
                int n4 = 0;
                while (n4 < n3) {
                    double d4;
                    Number number = categoryDataset.getValue(n4, n2);
                    if (number != null && (d4 = number.doubleValue()) > 0.0) {
                        d3 += d4;
                    }
                    ++n4;
                }
                d2 = Math.max(d2, d3);
                ++n2;
            }
            d = new Double(d2);
        }
        return d;
    }

    public static Range findStackedRangeExtent(TableXYDataset tableXYDataset) {
        return DatasetUtilities.findStackedRangeExtent(tableXYDataset, 0.0);
    }

    public static Range findStackedRangeExtent(TableXYDataset tableXYDataset, double d) {
        if (tableXYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n < tableXYDataset.getItemCount()) {
            double d4 = d;
            double d5 = d;
            int n2 = 0;
            while (n2 < tableXYDataset.getSeriesCount()) {
                double d6 = tableXYDataset.getYValue(n2, n);
                if (!Double.isNaN(d6)) {
                    if (d6 > 0.0) {
                        d4 += d6;
                    } else {
                        d5 += d6;
                    }
                }
                ++n2;
            }
            if (d4 > d3) {
                d3 = d4;
            }
            if (d5 < d2) {
                d2 = d5;
            }
            ++n;
        }
        return new Range(d2, d3);
    }

    public static Range findCumulativeRangeExtent(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        boolean bl = true;
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < categoryDataset.getRowCount()) {
            double d3 = 0.0;
            int n2 = 0;
            while (n2 < categoryDataset.getColumnCount() - 1) {
                Number number = categoryDataset.getValue(n, n2);
                if (number != null) {
                    bl = false;
                    double d4 = number.doubleValue();
                    d = Math.min(d, d3 += d4);
                    d2 = Math.max(d2, d3);
                }
                ++n2;
            }
            ++n;
        }
        if (!bl) {
            return new Range(d, d2);
        }
        return null;
    }

    public static Range getDomainExtent(Dataset dataset) {
        return DatasetUtilities.findDomainExtent(dataset);
    }

    public static Range getRangeExtent(Dataset dataset) {
        return DatasetUtilities.findRangeExtent(dataset);
    }

    public static Number getMaximumDomainValue(Dataset dataset) {
        return DatasetUtilities.findMaximumDomainValue(dataset);
    }

    public static Number getMinimumRangeValue(Dataset dataset) {
        return DatasetUtilities.findMinimumRangeValue(dataset);
    }

    public static Number getMaximumRangeValue(Dataset dataset) {
        return DatasetUtilities.findMaximumRangeValue(dataset);
    }

    public static Range findDomainExtent(Dataset dataset) {
        if (dataset == null) {
            return null;
        }
        if (dataset instanceof CategoryDataset && !(dataset instanceof XYDataset)) {
            throw new IllegalArgumentException("The dataset does not have a numerical domain.");
        }
        if (dataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)dataset);
            return domainInfo.getDomainRange();
        }
        if (dataset instanceof XYDataset) {
            return DatasetUtilities.iterateDomainExtent((XYDataset)dataset);
        }
        return null;
    }

    public static Range findRangeExtent(Dataset dataset) {
        if (dataset == null) {
            return null;
        }
        if (dataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)dataset);
            return rangeInfo.getValueRange();
        }
        if (dataset instanceof CategoryDataset) {
            return DatasetUtilities.iterateCategoryRangeExtent((CategoryDataset)dataset);
        }
        if (dataset instanceof XYDataset) {
            return DatasetUtilities.iterateXYRangeExtent((XYDataset)dataset);
        }
        return null;
    }

    public static Number findMinimumDomainValue(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (dataset instanceof CategoryDataset && !(dataset instanceof XYDataset)) {
            throw new IllegalArgumentException("CategoryDataset does not have a numerical domain.");
        }
        if (dataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)dataset);
            return domainInfo.getMinimumDomainValue();
        }
        if (dataset instanceof XYDataset) {
            double d = Double.POSITIVE_INFINITY;
            XYDataset xYDataset = (XYDataset)dataset;
            int n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                int n3 = xYDataset.getItemCount(n2);
                int n4 = 0;
                while (n4 < n3) {
                    double d2;
                    if (dataset instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)dataset;
                        d2 = intervalXYDataset.getStartXValue(n2, n4);
                    } else {
                        d2 = xYDataset.getXValue(n2, n4);
                    }
                    if (!Double.isNaN(d2)) {
                        d = Math.min(d, d2);
                    }
                    ++n4;
                }
                ++n2;
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        return null;
    }

    public static Number findMaximumDomainValue(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (dataset instanceof CategoryDataset && !(dataset instanceof XYDataset)) {
            throw new IllegalArgumentException("Datasets.getMaximumDomainValue(...): CategoryDataset does not have numerical domain.");
        }
        if (dataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)dataset);
            return domainInfo.getMaximumDomainValue();
        }
        if (dataset instanceof XYDataset) {
            XYDataset xYDataset = (XYDataset)dataset;
            double d = Double.NEGATIVE_INFINITY;
            int n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                int n3 = xYDataset.getItemCount(n2);
                int n4 = 0;
                while (n4 < n3) {
                    double d2;
                    if (dataset instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)dataset;
                        d2 = intervalXYDataset.getEndXValue(n2, n4);
                    } else {
                        d2 = xYDataset.getXValue(n2, n4);
                    }
                    if (!Double.isNaN(d2)) {
                        d = Math.max(d, d2);
                    }
                    ++n4;
                }
                ++n2;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        return null;
    }

    public static Range getStackedRangeExtent(CategoryDataset categoryDataset) {
        return DatasetUtilities.findStackedRangeExtent(categoryDataset);
    }

    public static Range getStackedRangeExtent(TableXYDataset tableXYDataset) {
        return DatasetUtilities.findStackedRangeExtent(tableXYDataset);
    }

    public static Range getCumulativeRangeExtent(CategoryDataset categoryDataset) {
        return DatasetUtilities.findCumulativeRangeExtent(categoryDataset);
    }

    public static Number findMinimumRangeValue(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (dataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)dataset);
            return rangeInfo.getMinimumRangeValue();
        }
        if (dataset instanceof CategoryDataset) {
            CategoryDataset categoryDataset = (CategoryDataset)dataset;
            double d = Double.POSITIVE_INFINITY;
            int n = categoryDataset.getRowCount();
            int n2 = categoryDataset.getColumnCount();
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    Number number;
                    if (dataset instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)dataset;
                        number = intervalCategoryDataset.getStartValue(n3, n4);
                    } else {
                        number = categoryDataset.getValue(n3, n4);
                    }
                    if (number != null) {
                        d = Math.min(d, number.doubleValue());
                    }
                    ++n4;
                }
                ++n3;
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        if (dataset instanceof XYDataset) {
            XYDataset xYDataset = (XYDataset)dataset;
            double d = Double.POSITIVE_INFINITY;
            int n = xYDataset.getSeriesCount();
            int n5 = 0;
            while (n5 < n) {
                int n6 = xYDataset.getItemCount(n5);
                int n7 = 0;
                while (n7 < n6) {
                    double d2;
                    XYDataset xYDataset2;
                    if (dataset instanceof IntervalXYDataset) {
                        xYDataset2 = (IntervalXYDataset)dataset;
                        d2 = xYDataset2.getStartYValue(n5, n7);
                    } else if (dataset instanceof OHLCDataset) {
                        xYDataset2 = (OHLCDataset)dataset;
                        d2 = xYDataset2.getLowValue(n5, n7);
                    } else {
                        d2 = xYDataset.getYValue(n5, n7);
                    }
                    if (!Double.isNaN(d2)) {
                        d = Math.min(d, d2);
                    }
                    ++n7;
                }
                ++n5;
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        return null;
    }

    public static Number findMaximumRangeValue(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (dataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)dataset);
            return rangeInfo.getMaximumRangeValue();
        }
        if (dataset instanceof CategoryDataset) {
            CategoryDataset categoryDataset = (CategoryDataset)dataset;
            double d = Double.NEGATIVE_INFINITY;
            int n = categoryDataset.getRowCount();
            int n2 = categoryDataset.getColumnCount();
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    Number number;
                    if (dataset instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)dataset;
                        number = intervalCategoryDataset.getEndValue(n3, n4);
                    } else {
                        number = categoryDataset.getValue(n3, n4);
                    }
                    if (number != null) {
                        d = Math.max(d, number.doubleValue());
                    }
                    ++n4;
                }
                ++n3;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        if (dataset instanceof XYDataset) {
            XYDataset xYDataset = (XYDataset)dataset;
            double d = Double.NEGATIVE_INFINITY;
            int n = xYDataset.getSeriesCount();
            int n5 = 0;
            while (n5 < n) {
                int n6 = xYDataset.getItemCount(n5);
                int n7 = 0;
                while (n7 < n6) {
                    double d2;
                    XYDataset xYDataset2;
                    if (dataset instanceof IntervalXYDataset) {
                        xYDataset2 = (IntervalXYDataset)dataset;
                        d2 = xYDataset2.getEndYValue(n5, n7);
                    } else if (dataset instanceof OHLCDataset) {
                        xYDataset2 = (OHLCDataset)dataset;
                        d2 = xYDataset2.getHighValue(n5, n7);
                    } else {
                        d2 = xYDataset.getYValue(n5, n7);
                    }
                    if (!Double.isNaN(d2)) {
                        d = Math.max(d, d2);
                    }
                    ++n7;
                }
                ++n5;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        return null;
    }

    public static Range getStackedRangeExtent(CategoryDataset categoryDataset, KeyToGroupMap keyToGroupMap) {
        return DatasetUtilities.findStackedRangeExtent(categoryDataset, keyToGroupMap);
    }

    public static Number getMinimumStackedRangeValue(CategoryDataset categoryDataset) {
        return DatasetUtilities.findMinimumStackedRangeValue(categoryDataset);
    }

    public static Number getMaximumStackedRangeValue(CategoryDataset categoryDataset) {
        return DatasetUtilities.findMaximumStackedRangeValue(categoryDataset);
    }
}

