/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class XYStepRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    public XYStepRenderer() {
    }

    public XYStepRenderer(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Serializable serializable;
        Object object;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getX(n, n2);
        Number number2 = xYDataset.getY(n, n2);
        if (number2 == null) {
            return;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
        double d2 = valueAxis2.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge2);
        if (n2 > 0) {
            object = xYDataset.getX(n, n2 - 1);
            serializable = xYDataset.getY(n, n2 - 1);
            if (serializable != null) {
                double d3 = valueAxis.valueToJava2D(((Number)object).doubleValue(), rectangle2D, rectangleEdge);
                double d4 = valueAxis2.valueToJava2D(serializable.doubleValue(), rectangle2D, rectangleEdge2);
                Line2D line2D = xYItemRendererState.workingLine;
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    if (d4 == d2) {
                        line2D.setLine(d4, d3, d2, d);
                        graphics2D.draw(line2D);
                    } else {
                        line2D.setLine(d4, d3, d2, d3);
                        graphics2D.draw(line2D);
                        line2D.setLine(d2, d3, d2, d);
                        graphics2D.draw(line2D);
                    }
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    if (d4 == d2) {
                        line2D.setLine(d3, d4, d, d2);
                        graphics2D.draw(line2D);
                    } else {
                        line2D.setLine(d3, d4, d, d4);
                        graphics2D.draw(line2D);
                        line2D.setLine(d, d4, d, d2);
                        graphics2D.draw(line2D);
                    }
                }
            }
        }
        this.updateCrosshairValues(crosshairState, number.doubleValue(), number2.doubleValue(), d, d2, plotOrientation);
        if (xYItemRendererState.getInfo() != null && (object = xYItemRendererState.getInfo().getOwner().getEntityCollection()) != null) {
            Serializable serializable2 = serializable = plotOrientation == PlotOrientation.VERTICAL ? new Rectangle2D.Double(d - 2.0, d2 - 2.0, 4.0, 4.0) : new Rectangle2D.Double(d2 - 2.0, d - 2.0, 4.0, 4.0);
            if (serializable != null) {
                String string = null;
                XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
                if (xYToolTipGenerator != null) {
                    string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
                }
                String string2 = null;
                if (this.getURLGenerator() != null) {
                    string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
                }
                XYItemEntity xYItemEntity = new XYItemEntity((Shape)((Object)serializable), xYDataset, n, n2, string, string2);
                object.addEntity(xYItemEntity);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

