/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtils;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public class XYLineAndShapeRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private Boolean linesVisible = null;
    private BooleanList seriesLinesVisible = new BooleanList();
    private boolean defaultLinesVisible = true;
    private Boolean shapesVisible = null;
    private BooleanList seriesShapesVisible = new BooleanList();
    private boolean defaultShapesVisible = true;
    private Boolean shapesFilled = null;
    private BooleanList seriesShapesFilled = new BooleanList();
    private boolean defaultShapesFilled = true;
    private boolean drawOutlines = false;
    private boolean useOutlinePaint = false;

    public int getPassCount() {
        return 2;
    }

    public boolean getItemLineVisible(int n, int n2) {
        Boolean bl = this.linesVisible;
        if (bl == null) {
            bl = this.getSeriesLinesVisible(n);
        }
        if (bl != null) {
            return bl;
        }
        return this.defaultLinesVisible;
    }

    public Boolean getLinesVisible() {
        return this.linesVisible;
    }

    public void setLinesVisible(Boolean bl) {
        this.linesVisible = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setLinesVisible(boolean bl) {
        this.setLinesVisible(BooleanUtils.valueOf(bl));
    }

    public Boolean getSeriesLinesVisible(int n) {
        return this.seriesLinesVisible.getBoolean(n);
    }

    public void setSeriesLinesVisible(int n, Boolean bl) {
        this.seriesLinesVisible.setBoolean(n, bl);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setSeriesLinesVisible(int n, boolean bl) {
        this.setSeriesLinesVisible(n, BooleanUtils.valueOf(bl));
    }

    public boolean getDefaultLinesVisible() {
        return this.defaultLinesVisible;
    }

    public void setDefaultLinesVisible(boolean bl) {
        this.defaultLinesVisible = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getItemShapeVisible(int n, int n2) {
        Boolean bl = this.shapesVisible;
        if (bl == null) {
            bl = this.getSeriesShapesVisible(n);
        }
        if (bl != null) {
            return bl;
        }
        return this.defaultShapesVisible;
    }

    public Boolean getShapesVisible() {
        return this.shapesVisible;
    }

    public void setShapesVisible(Boolean bl) {
        this.shapesVisible = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setShapesVisible(boolean bl) {
        this.setShapesVisible(BooleanUtils.valueOf(bl));
    }

    public Boolean getSeriesShapesVisible(int n) {
        return this.seriesShapesVisible.getBoolean(n);
    }

    public void setSeriesShapesVisible(int n, boolean bl) {
        this.setSeriesShapesVisible(n, BooleanUtils.valueOf(bl));
    }

    public void setSeriesShapesVisible(int n, Boolean bl) {
        this.seriesShapesVisible.setBoolean(n, bl);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDefaultShapesVisible() {
        return this.defaultShapesVisible;
    }

    public void setDefaultShapesVisible(boolean bl) {
        this.defaultShapesVisible = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getItemShapeFilled(int n, int n2) {
        Boolean bl = this.shapesFilled;
        if (bl == null) {
            bl = this.getSeriesShapesFilled(n);
        }
        if (bl != null) {
            return bl;
        }
        return this.defaultShapesVisible;
    }

    public void setShapesFilled(boolean bl) {
        this.setShapesFilled(BooleanUtils.valueOf(bl));
    }

    public void setShapesFilled(Boolean bl) {
        this.shapesFilled = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Boolean getSeriesShapesFilled(int n) {
        return this.seriesShapesFilled.getBoolean(n);
    }

    public void setSeriesShapesFilled(int n, boolean bl) {
        this.setSeriesShapesFilled(n, BooleanUtils.valueOf(bl));
    }

    public void setSeriesShapesFilled(int n, Boolean bl) {
        this.seriesShapesFilled.setBoolean(n, bl);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDefaultShapesFilled() {
        return this.defaultShapesFilled;
    }

    public void setDefaultShapesFilled(boolean bl) {
        this.defaultShapesFilled = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDrawOutlines() {
        return this.drawOutlines;
    }

    public void setDrawOutlines(boolean bl) {
        this.drawOutlines = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getUseOutlinePaint() {
        return this.useOutlinePaint;
    }

    public void setUseOutlinePaint(boolean bl) {
        this.useOutlinePaint = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYItemRendererState xYItemRendererState = new XYItemRendererState(plotRenderingInfo);
        return xYItemRendererState;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        Number number = xYDataset.getX(n, n2);
        Number number2 = xYDataset.getY(n, n2);
        if (number2 == null || number == null) {
            return;
        }
        Shape shape = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        double d = number.doubleValue();
        double d2 = number2.doubleValue();
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        if (n3 == 0) {
            if (this.getItemLineVisible(n, n2) && n2 > 0) {
                Number number3 = xYDataset.getX(n, n2 - 1);
                Number number4 = xYDataset.getY(n, n2 - 1);
                if (number4 != null && number3 != null) {
                    double d5 = number3.doubleValue();
                    double d6 = number4.doubleValue();
                    double d7 = valueAxis.valueToJava2D(d5, rectangle2D, rectangleEdge);
                    double d8 = valueAxis2.valueToJava2D(d6, rectangle2D, rectangleEdge2);
                    if (Double.isNaN(d7) || Double.isNaN(d8) || Double.isNaN(d3) || Double.isNaN(d4)) {
                        return;
                    }
                    PlotOrientation plotOrientation = xYPlot.getOrientation();
                    if (plotOrientation == PlotOrientation.HORIZONTAL) {
                        xYItemRendererState.workingLine.setLine(d8, d7, d4, d3);
                    } else if (plotOrientation == PlotOrientation.VERTICAL) {
                        xYItemRendererState.workingLine.setLine(d7, d8, d3, d4);
                    }
                    if (xYItemRendererState.workingLine.intersects(rectangle2D)) {
                        graphics2D.setStroke(this.getItemStroke(n, n2));
                        graphics2D.setPaint(this.getItemPaint(n, n2));
                        graphics2D.draw(xYItemRendererState.workingLine);
                    }
                }
            }
        } else if (n3 == 1) {
            if (this.getItemShapeVisible(n, n2)) {
                Shape shape2 = this.getItemShape(n, n2);
                PlotOrientation plotOrientation = xYPlot.getOrientation();
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    shape2 = this.createTransformedShape(shape2, d4, d3);
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    shape2 = this.createTransformedShape(shape2, d3, d4);
                }
                shape = shape2;
                if (shape2.intersects(rectangle2D)) {
                    if (this.getItemShapeFilled(n, n2)) {
                        graphics2D.setPaint(this.getItemPaint(n, n2));
                        graphics2D.fill(shape2);
                        if (this.getDrawOutlines()) {
                            if (this.getUseOutlinePaint()) {
                                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                            } else {
                                graphics2D.setPaint(this.getItemPaint(n, n2));
                            }
                            graphics2D.draw(shape2);
                        }
                    } else {
                        if (this.getUseOutlinePaint()) {
                            graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                        } else {
                            graphics2D.setPaint(this.getItemPaint(n, n2));
                        }
                        graphics2D.draw(shape2);
                    }
                }
            }
            if (entityCollection != null) {
                this.addEntity(entityCollection, shape, xYDataset, n, n2, d3, d4);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)object;
            if (super.equals(object)) {
                boolean bl;
                boolean bl2 = ObjectUtils.equal(this.linesVisible, xYLineAndShapeRenderer.linesVisible);
                boolean bl3 = ObjectUtils.equal(this.seriesLinesVisible, xYLineAndShapeRenderer.seriesLinesVisible);
                boolean bl4 = this.defaultLinesVisible == xYLineAndShapeRenderer.defaultLinesVisible;
                boolean bl5 = ObjectUtils.equal(this.shapesVisible, xYLineAndShapeRenderer.shapesVisible);
                boolean bl6 = ObjectUtils.equal(this.seriesShapesVisible, xYLineAndShapeRenderer.seriesShapesVisible);
                boolean bl7 = this.defaultShapesVisible == xYLineAndShapeRenderer.defaultShapesVisible;
                boolean bl8 = ObjectUtils.equal(this.shapesFilled, xYLineAndShapeRenderer.shapesFilled);
                boolean bl9 = ObjectUtils.equal(this.seriesShapesFilled, xYLineAndShapeRenderer.seriesShapesFilled);
                boolean bl10 = this.defaultShapesFilled == xYLineAndShapeRenderer.defaultShapesFilled;
                boolean bl11 = this.drawOutlines == xYLineAndShapeRenderer.drawOutlines;
                boolean bl12 = bl = this.useOutlinePaint == xYLineAndShapeRenderer.useOutlinePaint;
                return bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl;
            }
        }
        return false;
    }
}

