/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class XYDifferenceRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private transient Paint positivePaint;
    private transient Paint negativePaint;
    private boolean plotShapes = true;

    public XYDifferenceRenderer() {
        this(Color.green, Color.red, false);
    }

    public XYDifferenceRenderer(Paint paint, Paint paint2, boolean bl) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'positivePaint' argument.");
        }
        if (paint2 == null) {
            throw new IllegalArgumentException("Null 'negativePaint' argument.");
        }
        this.positivePaint = paint;
        this.negativePaint = paint2;
        this.plotShapes = bl;
    }

    public Paint getPositivePaint() {
        return this.positivePaint;
    }

    public void setPositivePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.positivePaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Paint getNegativePaint() {
        return this.negativePaint;
    }

    public void setNegativePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.negativePaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public void setPlotShapes(boolean bl) {
        this.plotShapes = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        return super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, plotRenderingInfo);
    }

    public int getPassCount() {
        return 2;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        if (n3 == 0) {
            this.drawItemPass0(graphics2D, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairState);
        } else if (n3 == 1) {
            this.drawItemPass1(graphics2D, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairState);
        }
    }

    protected void drawItemPass0(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState) {
        if (n == 0) {
            Number number = xYDataset.getY(0, n2);
            Number number2 = xYDataset.getX(1, n2);
            Number number3 = xYDataset.getY(1, n2);
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
            double d = number.doubleValue();
            double d2 = valueAxis2.valueToJava2D(d, rectangle2D, rectangleEdge2);
            double d3 = number2.doubleValue();
            double d4 = number3.doubleValue();
            double d5 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
            double d6 = valueAxis2.valueToJava2D(d4, rectangle2D, rectangleEdge2);
            if (n2 > 0) {
                Shape shape;
                double d7;
                double d8;
                double d9;
                Number number4 = xYDataset.getX(0, n2 - 1);
                Number number5 = xYDataset.getY(0, n2 - 1);
                Number number6 = xYDataset.getY(1, n2 - 1);
                double d10 = number4.doubleValue();
                double d11 = number5.doubleValue();
                double d12 = valueAxis.valueToJava2D(d10, rectangle2D, rectangleEdge);
                Shape shape2 = this.getPositiveArea((float)d12, (float)(d9 = valueAxis2.valueToJava2D(d11, rectangle2D, rectangleEdge2)), (float)(d8 = valueAxis2.valueToJava2D(d7 = number6.doubleValue(), rectangle2D, rectangleEdge2)), (float)d5, (float)d2, (float)d6, plotOrientation);
                if (shape2 != null) {
                    graphics2D.setPaint(this.getPositivePaint());
                    graphics2D.fill(shape2);
                }
                if ((shape = this.getNegativeArea((float)d12, (float)d9, (float)d8, (float)d5, (float)d2, (float)d6, plotOrientation)) != null) {
                    graphics2D.setPaint(this.getNegativePaint());
                    graphics2D.fill(shape);
                }
            }
        }
    }

    protected void drawItemPass1(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState) {
        Object object = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        if (n == 0) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Number number = xYDataset.getX(0, n2);
            Number number2 = xYDataset.getY(0, n2);
            Number number3 = xYDataset.getX(1, n2);
            Number number4 = xYDataset.getY(1, n2);
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
            double d = number.doubleValue();
            double d2 = number2.doubleValue();
            double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
            double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
            double d5 = number3.doubleValue();
            double d6 = number4.doubleValue();
            double d7 = valueAxis.valueToJava2D(d5, rectangle2D, rectangleEdge);
            double d8 = valueAxis2.valueToJava2D(d6, rectangle2D, rectangleEdge2);
            if (n2 > 0) {
                object5 = xYDataset.getX(0, n2 - 1);
                object4 = xYDataset.getY(0, n2 - 1);
                object3 = xYDataset.getX(1, n2 - 1);
                object2 = xYDataset.getY(1, n2 - 1);
                double d9 = ((Number)object5).doubleValue();
                double d10 = ((Number)object4).doubleValue();
                double d11 = valueAxis.valueToJava2D(d9, rectangle2D, rectangleEdge);
                double d12 = valueAxis2.valueToJava2D(d10, rectangle2D, rectangleEdge2);
                double d13 = ((Number)object3).doubleValue();
                double d14 = ((Number)object2).doubleValue();
                double d15 = valueAxis.valueToJava2D(d13, rectangle2D, rectangleEdge);
                double d16 = valueAxis2.valueToJava2D(d14, rectangle2D, rectangleEdge2);
                Line2D.Double double_ = null;
                Line2D line2D = null;
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    double_ = new Line2D.Double(d4, d3, d12, d11);
                    line2D = new Line2D.Double(d8, d7, d16, d15);
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    double_ = new Line2D.Double(d3, d4, d11, d12);
                    line2D = new Line2D.Double(d7, d8, d15, d16);
                }
                if (double_ != null && double_.intersects(rectangle2D)) {
                    graphics2D.setPaint(this.getItemPaint(n, n2));
                    graphics2D.draw(double_);
                }
                if (line2D != null && line2D.intersects(rectangle2D)) {
                    graphics2D.setPaint(this.getItemPaint(1, n2));
                    graphics2D.draw(line2D);
                }
            }
            if (this.getPlotShapes()) {
                object5 = this.getItemShape(n, n2);
                object5 = plotOrientation == PlotOrientation.HORIZONTAL ? this.createTransformedShape((Shape)object5, d4, d3) : this.createTransformedShape((Shape)object5, d3, d4);
                if (object5.intersects(rectangle2D)) {
                    graphics2D.setPaint(this.getItemPaint(n, n2));
                    graphics2D.fill((Shape)object5);
                }
                object = object5;
                if (entityCollection != null) {
                    if (object == null) {
                        object = new Rectangle2D.Double(d3 - 2.0, d4 - 2.0, 4.0, 4.0);
                    }
                    object4 = null;
                    object3 = this.getToolTipGenerator(n, n2);
                    if (object3 != null) {
                        object4 = object3.generateToolTip(xYDataset, n, n2);
                    }
                    object2 = null;
                    if (this.getURLGenerator() != null) {
                        object2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
                    }
                    XYItemEntity xYItemEntity = new XYItemEntity((Shape)object, xYDataset, n, n2, (String)object4, (String)object2);
                    entityCollection.addEntity(xYItemEntity);
                }
                object4 = this.getItemShape(n + 1, n2);
                if ((object4 = this.createTransformedShape((Shape)object4, d7, d8)).intersects(rectangle2D)) {
                    graphics2D.setPaint(this.getItemPaint(n + 1, n2));
                    graphics2D.fill((Shape)object4);
                }
                object = object4;
                if (entityCollection != null) {
                    if (object == null) {
                        object = new Rectangle2D.Double(d7 - 2.0, d8 - 2.0, 4.0, 4.0);
                    }
                    object3 = null;
                    object2 = this.getToolTipGenerator(n, n2);
                    if (object2 != null) {
                        object3 = object2.generateToolTip(xYDataset, n + 1, n2);
                    }
                    String string = null;
                    if (this.getURLGenerator() != null) {
                        string = this.getURLGenerator().generateURL(xYDataset, n + 1, n2);
                    }
                    XYItemEntity xYItemEntity = new XYItemEntity((Shape)object, xYDataset, n + 1, n2, (String)object3, string);
                    entityCollection.addEntity(xYItemEntity);
                }
            }
            this.updateCrosshairValues(crosshairState, d5, d6, d7, d8, plotOrientation);
        }
    }

    protected Shape getPositiveArea(float f, float f2, float f3, float f4, float f5, float f6, PlotOrientation plotOrientation) {
        boolean bl;
        GeneralPath generalPath = null;
        boolean bl2 = f2 >= f3;
        boolean bl3 = bl = f5 >= f6;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            bl2 = f3 >= f2;
            boolean bl4 = bl = f6 >= f5;
        }
        if (bl2) {
            if (!bl) {
                float[] fArray = this.getIntersection(f, f2, f4, f5, f, f3, f4, f6);
                GeneralPath generalPath2 = new GeneralPath();
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    generalPath2.moveTo(f5, f4);
                    generalPath2.lineTo(fArray[1], fArray[0]);
                    generalPath2.lineTo(f6, f4);
                    generalPath2.closePath();
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath2.moveTo(f4, f5);
                    generalPath2.lineTo(fArray[0], fArray[1]);
                    generalPath2.lineTo(f4, f6);
                    generalPath2.closePath();
                }
                generalPath = generalPath2;
            }
        } else if (bl) {
            float[] fArray = this.getIntersection(f, f2, f4, f5, f, f3, f4, f6);
            GeneralPath generalPath3 = new GeneralPath();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                generalPath3.moveTo(f2, f);
                generalPath3.lineTo(fArray[1], fArray[0]);
                generalPath3.lineTo(f3, f);
                generalPath3.closePath();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                generalPath3.moveTo(f, f2);
                generalPath3.lineTo(fArray[0], fArray[1]);
                generalPath3.lineTo(f, f3);
                generalPath3.closePath();
            }
            generalPath = generalPath3;
        } else {
            GeneralPath generalPath4 = new GeneralPath();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                generalPath4.moveTo(f2, f);
                generalPath4.lineTo(f5, f4);
                generalPath4.lineTo(f6, f4);
                generalPath4.lineTo(f3, f);
                generalPath4.closePath();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                generalPath4.moveTo(f, f2);
                generalPath4.lineTo(f4, f5);
                generalPath4.lineTo(f4, f6);
                generalPath4.lineTo(f, f3);
                generalPath4.closePath();
            }
            generalPath = generalPath4;
        }
        return generalPath;
    }

    protected Shape getNegativeArea(float f, float f2, float f3, float f4, float f5, float f6, PlotOrientation plotOrientation) {
        boolean bl;
        GeneralPath generalPath = null;
        boolean bl2 = f2 >= f3;
        boolean bl3 = bl = f5 >= f6;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            bl2 = f3 >= f2;
            boolean bl4 = bl = f6 >= f5;
        }
        if (bl2) {
            if (bl) {
                GeneralPath generalPath2 = new GeneralPath();
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    generalPath2.moveTo(f2, f);
                    generalPath2.lineTo(f5, f4);
                    generalPath2.lineTo(f6, f4);
                    generalPath2.lineTo(f3, f);
                    generalPath2.closePath();
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath2.moveTo(f, f2);
                    generalPath2.lineTo(f4, f5);
                    generalPath2.lineTo(f4, f6);
                    generalPath2.lineTo(f, f3);
                    generalPath2.closePath();
                }
                generalPath = generalPath2;
            } else {
                float[] fArray = this.getIntersection(f, f2, f4, f5, f, f3, f4, f6);
                GeneralPath generalPath3 = new GeneralPath();
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    generalPath3.moveTo(f2, f);
                    generalPath3.lineTo(fArray[1], fArray[0]);
                    generalPath3.lineTo(f3, f);
                    generalPath3.closePath();
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath3.moveTo(f, f2);
                    generalPath3.lineTo(fArray[0], fArray[1]);
                    generalPath3.lineTo(f, f3);
                    generalPath3.closePath();
                }
                generalPath = generalPath3;
            }
        } else if (bl) {
            float[] fArray = this.getIntersection(f, f2, f4, f5, f, f3, f4, f6);
            GeneralPath generalPath4 = new GeneralPath();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                generalPath4.moveTo(f5, f4);
                generalPath4.lineTo(fArray[1], fArray[0]);
                generalPath4.lineTo(f6, f4);
                generalPath4.closePath();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                generalPath4.moveTo(f4, f5);
                generalPath4.lineTo(fArray[0], fArray[1]);
                generalPath4.lineTo(f4, f6);
                generalPath4.closePath();
            }
            generalPath = generalPath4;
        }
        return generalPath;
    }

    private float[] getIntersection(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = (f7 - f5) * (f2 - f6) - (f8 - f6) * (f - f5);
        float f10 = (f8 - f6) * (f3 - f) - (f7 - f5) * (f4 - f2);
        float f11 = f9 / f10;
        float[] fArray = new float[]{f + f11 * (f3 - f), f2 + f11 * (f4 - f2)};
        return fArray;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

