/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class XYBubbleRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    public static final int SCALE_ON_BOTH_AXES = 0;
    public static final int SCALE_ON_DOMAIN_AXIS = 1;
    public static final int SCALE_ON_RANGE_AXIS = 2;
    private int scaleType;

    public XYBubbleRenderer() {
        this(0);
    }

    public XYBubbleRenderer(int n) {
        this.scaleType = n;
    }

    public int getScaleType() {
        return this.scaleType;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Number number = xYDataset.getX(n, n2);
        Number number2 = xYDataset.getY(n, n2);
        double d = Double.NaN;
        if (xYDataset instanceof XYZDataset) {
            XYZDataset xYZDataset = (XYZDataset)xYDataset;
            d = xYZDataset.getZValue(n, n2);
        }
        if (!Double.isNaN(d)) {
            double d2;
            double d3 = number.doubleValue();
            double d4 = number2.doubleValue();
            RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
            double d5 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
            double d6 = valueAxis2.valueToJava2D(d4, rectangle2D, rectangleEdge2);
            double d7 = 0.0;
            double d8 = 0.0;
            switch (this.getScaleType()) {
                case 1: {
                    double d9 = valueAxis.valueToJava2D(0.0, rectangle2D, rectangleEdge);
                    d8 = d7 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge2) - d9;
                    break;
                }
                case 2: {
                    double d10 = valueAxis2.valueToJava2D(0.0, rectangle2D, rectangleEdge2);
                    d7 = d8 = d10 - valueAxis2.valueToJava2D(d, rectangle2D, rectangleEdge2);
                    break;
                }
                default: {
                    d2 = valueAxis.valueToJava2D(0.0, rectangle2D, rectangleEdge);
                    double d11 = valueAxis2.valueToJava2D(0.0, rectangle2D, rectangleEdge2);
                    d7 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge) - d2;
                    d8 = d11 - valueAxis2.valueToJava2D(d, rectangle2D, rectangleEdge2);
                }
            }
            d2 = -valueAxis2.valueToJava2D(d, rectangle2D, rectangleEdge2) + valueAxis2.valueToJava2D(0.0, rectangle2D, rectangleEdge2);
            d2 = Math.abs(d2);
            d7 = Math.abs(d7);
            d8 = Math.abs(d8);
            Ellipse2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Ellipse2D.Double(d5 - d2 / 2.0, d6 - d2 / 2.0, d7, d8);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Ellipse2D.Double(d6 - d2 / 2.0, d5 - d2 / 2.0, d8, d7);
            }
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.fill(double_);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setPaint(Color.lightGray);
            graphics2D.draw(double_);
            EntityCollection entityCollection = null;
            if (plotRenderingInfo != null) {
                entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
            }
            if (entityCollection != null) {
                String string = null;
                XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
                if (xYToolTipGenerator != null) {
                    string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
                }
                String string2 = null;
                if (this.getURLGenerator() != null) {
                    string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
                }
                XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, string, string2);
                entityCollection.addEntity(xYItemEntity);
            }
            this.updateCrosshairValues(crosshairState, d3, d4, d5, d6, plotOrientation);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

