/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class XYAreaRenderer2
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private boolean plotShapes = false;
    private boolean plotLines = false;
    private boolean plotArea = true;
    private boolean showOutline = false;

    public XYAreaRenderer2() {
        this(null, null);
    }

    public XYAreaRenderer2(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean bl) {
        this.showOutline = bl;
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public boolean getPlotArea() {
        return this.plotArea;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        EntityCollection entityCollection;
        Number number = xYDataset.getX(n, n2);
        Number number2 = xYDataset.getY(n, n2);
        if (number2 == null) {
            number2 = AbstractRenderer.ZERO;
        }
        double d = number.doubleValue();
        double d2 = number2.doubleValue();
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        Number number3 = xYDataset.getX(n, Math.max(n2 - 1, 0));
        Number number4 = xYDataset.getY(n, Math.max(n2 - 1, 0));
        if (number4 == null) {
            number4 = AbstractRenderer.ZERO;
        }
        double d5 = valueAxis.valueToJava2D(number3.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        double d6 = valueAxis2.valueToJava2D(number4.doubleValue(), rectangle2D, xYPlot.getRangeAxisEdge());
        int n4 = xYDataset.getItemCount(n);
        Number number5 = xYDataset.getX(n, Math.min(n2 + 1, n4 - 1));
        Number number6 = xYDataset.getY(n, Math.min(n2 + 1, n4 - 1));
        if (number6 == null) {
            number6 = AbstractRenderer.ZERO;
        }
        double d7 = valueAxis.valueToJava2D(number5.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        double d8 = valueAxis2.valueToJava2D(number6.doubleValue(), rectangle2D, xYPlot.getRangeAxisEdge());
        double d9 = valueAxis2.valueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
        Polygon polygon = null;
        if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            polygon = new Polygon();
            polygon.addPoint((int)d9, (int)((d5 + d3) / 2.0));
            polygon.addPoint((int)((d6 + d4) / 2.0), (int)((d5 + d3) / 2.0));
            polygon.addPoint((int)d4, (int)d3);
            polygon.addPoint((int)((d4 + d8) / 2.0), (int)((d3 + d7) / 2.0));
            polygon.addPoint((int)d9, (int)((d3 + d7) / 2.0));
        } else {
            polygon = new Polygon();
            polygon.addPoint((int)((d5 + d3) / 2.0), (int)d9);
            polygon.addPoint((int)((d5 + d3) / 2.0), (int)((d6 + d4) / 2.0));
            polygon.addPoint((int)d3, (int)d4);
            polygon.addPoint((int)((d3 + d7) / 2.0), (int)((d4 + d8) / 2.0));
            polygon.addPoint((int)((d3 + d7) / 2.0), (int)d9);
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Shape shape = null;
        if (this.getPlotShapes()) {
            shape = this.getItemShape(n, n2);
            if (plotOrientation == PlotOrientation.VERTICAL) {
                shape = this.createTransformedShape(shape, d3, d4);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                shape = this.createTransformedShape(shape, d4, d3);
            }
            graphics2D.draw(shape);
        }
        if (this.getPlotLines() && n2 > 0) {
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                xYItemRendererState.workingLine.setLine(d5, d6, d3, d4);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                xYItemRendererState.workingLine.setLine(d6, d5, d4, d3);
            }
            graphics2D.draw(xYItemRendererState.workingLine);
        }
        if (this.getPlotArea()) {
            graphics2D.fill(polygon);
            if (this.isOutline()) {
                graphics2D.setStroke(xYPlot.getOutlineStroke());
                graphics2D.setPaint(xYPlot.getOutlinePaint());
                graphics2D.draw(polygon);
            }
        }
        this.updateCrosshairValues(crosshairState, d, d2, d3, d4, plotOrientation);
        if (xYItemRendererState.getInfo() != null && (entityCollection = xYItemRendererState.getInfo().getOwner().getEntityCollection()) != null && polygon != null) {
            String string = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(polygon, xYDataset, n, n2, string, string2);
            entityCollection.addEntity(xYItemEntity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

