/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class StackedXYBarRenderer
extends XYBarRenderer {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public StackedXYBarRenderer() {
    }

    public StackedXYBarRenderer(double d) {
        super(d);
    }

    public Range getRangeExtent(XYDataset xYDataset) {
        return DatasetUtilities.findStackedRangeExtent((TableXYDataset)xYDataset, this.getBase());
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        return new StackedXYBarRendererState(plotRenderingInfo);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        EntityCollection entityCollection;
        if (!(xYDataset instanceof IntervalXYDataset) || !(xYDataset instanceof TableXYDataset)) {
            Class<?> clazz;
            String string = "dataset (type " + xYDataset.getClass().getName() + ") has wrong type:";
            boolean bl = false;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.jfree.data.xy.IntervalXYDataset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz2.isAssignableFrom(xYDataset.getClass())) {
                string = String.valueOf(string) + " it is no IntervalXYDataset";
                bl = true;
            }
            if ((clazz = class$1) == null) {
                try {
                    clazz = class$1 = Class.forName("org.jfree.data.xy.TableXYDataset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(xYDataset.getClass())) {
                if (bl) {
                    string = String.valueOf(string) + " and";
                }
                string = String.valueOf(string) + " it is no TableXYDataset";
            }
            throw new IllegalArgumentException(string);
        }
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        Paint paint = this.getItemPaint(n, n2);
        Paint paint2 = this.getItemOutlinePaint(n, n2);
        double d = this.getPreviousHeight(xYDataset, n, n2);
        double d2 = intervalXYDataset.getYValue(n, n2);
        if (Double.isNaN(d2)) {
            return;
        }
        double d3 = valueAxis2.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
        double d4 = valueAxis2.valueToJava2D(d2 + d, rectangle2D, xYPlot.getRangeAxisEdge());
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        double d5 = intervalXYDataset.getStartXValue(n, n2);
        if (Double.isNaN(d5)) {
            return;
        }
        double d6 = valueAxis.valueToJava2D(d5, rectangle2D, rectangleEdge);
        double d7 = intervalXYDataset.getEndXValue(n, n2);
        if (Double.isNaN(d7)) {
            return;
        }
        double d8 = valueAxis.valueToJava2D(d7, rectangle2D, rectangleEdge);
        double d9 = Math.max(1.0, Math.abs(d8 - d6));
        double d10 = Math.abs(d4 - d3);
        if (this.getMargin() > 0.0) {
            double d11 = d9 * this.getMargin();
            d9 -= d11;
            d6 += d11 / 2.0;
        }
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(Math.min(d3, d4), d8, d10, d9);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(d6, Math.min(d3, d4), d9, d10);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && Math.abs(d8 - d6) > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.setPaint(paint2);
            graphics2D.draw(double_);
        }
        if (plotRenderingInfo != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
            String string = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, string, string2);
            entityCollection.addEntity(xYItemEntity);
        }
    }

    protected double getPreviousHeight(XYDataset xYDataset, int n, int n2) {
        double d = this.getBase();
        int n3 = 0;
        while (n3 < n) {
            double d2 = xYDataset.getYValue(n3, n2);
            if (!Double.isNaN(d2)) {
                d += d2;
            }
            ++n3;
        }
        return d;
    }

    static class StackedXYBarRendererState
    extends XYItemRendererState {
        public StackedXYBarRendererState(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }
    }
}

