/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class StackedXYAreaRenderer2
extends XYAreaRenderer2
implements Cloneable,
PublicCloneable,
Serializable {
    public StackedXYAreaRenderer2() {
        this(null, null);
    }

    public StackedXYAreaRenderer2(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(xYToolTipGenerator, xYURLGenerator);
    }

    public Range getRangeExtent(XYDataset xYDataset) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        TableXYDataset tableXYDataset = (TableXYDataset)xYDataset;
        int n = tableXYDataset.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            double[] dArray = this.getStackValues(xYDataset, tableXYDataset.getSeriesCount(), n2);
            d = Math.min(d, dArray[0]);
            d2 = Math.max(d2, dArray[1]);
            ++n2;
        }
        return new Range(d, d2);
    }

    public int getPassCount() {
        return 1;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        float f;
        Number number = xYDataset.getX(n, n2);
        Number number2 = xYDataset.getY(n, n2);
        if (number2 == null) {
            number2 = AbstractRenderer.ZERO;
        }
        double d = number.doubleValue();
        double d2 = number2.doubleValue();
        double[] dArray = this.getStackValues(xYDataset, n, n2);
        Number number3 = xYDataset.getX(n, Math.max(n2 - 1, 0));
        Number number4 = xYDataset.getY(n, Math.max(n2 - 1, 0));
        if (number4 == null) {
            number4 = AbstractRenderer.ZERO;
        }
        double d3 = number3.doubleValue();
        double d4 = number4.doubleValue();
        double[] dArray2 = this.getStackValues(xYDataset, n, Math.max(n2 - 1, 0));
        int n4 = xYDataset.getItemCount(n);
        Number number5 = xYDataset.getX(n, Math.min(n2 + 1, n4 - 1));
        Number number6 = xYDataset.getY(n, Math.min(n2 + 1, n4 - 1));
        if (number6 == null) {
            number6 = AbstractRenderer.ZERO;
        }
        double d5 = number5.doubleValue();
        double d6 = number6.doubleValue();
        double[] dArray3 = this.getStackValues(xYDataset, n, Math.min(n2 + 1, n4 - 1));
        double d7 = (d3 + d) / 2.0;
        double d8 = (d + d5) / 2.0;
        double[] dArray4 = this.averageStackValues(dArray2, dArray);
        double[] dArray5 = this.averageStackValues(dArray, dArray3);
        double[] dArray6 = this.adjustedStackValues(dArray2, dArray);
        double[] dArray7 = this.adjustedStackValues(dArray, dArray3);
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        float f2 = (float)valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        float f3 = (float)valueAxis.valueToJava2D(d7, rectangle2D, rectangleEdge);
        float f4 = (float)valueAxis.valueToJava2D(d8, rectangle2D, rectangleEdge);
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = new GeneralPath();
        if (d2 >= 0.0) {
            f = (float)valueAxis2.valueToJava2D(d2 + dArray[1], rectangle2D, rectangleEdge2);
            float f5 = (float)valueAxis2.valueToJava2D(dArray[1], rectangle2D, rectangleEdge2);
            float f6 = (float)valueAxis2.valueToJava2D(dArray6[1], rectangle2D, rectangleEdge2);
            if (d4 >= 0.0) {
                double d9 = (d4 + d2) / 2.0 + dArray4[1];
                float f7 = (float)valueAxis2.valueToJava2D(d9, rectangle2D, rectangleEdge2);
                generalPath.moveTo(f2, f);
                generalPath.lineTo(f2, f5);
                generalPath.lineTo(f3, f6);
                generalPath.lineTo(f3, f7);
                generalPath.closePath();
            } else {
                generalPath.moveTo(f2, f5);
                generalPath.lineTo(f2, f);
                generalPath.lineTo(f3, f6);
                generalPath.closePath();
            }
            float f8 = (float)valueAxis2.valueToJava2D(dArray7[1], rectangle2D, rectangleEdge2);
            if (d6 >= 0.0) {
                double d10 = (d2 + d6) / 2.0 + dArray5[1];
                float f9 = (float)valueAxis2.valueToJava2D(d10, rectangle2D, rectangleEdge2);
                generalPath2.moveTo(f2, f5);
                generalPath2.lineTo(f2, f);
                generalPath2.lineTo(f4, f9);
                generalPath2.lineTo(f4, f8);
                generalPath2.closePath();
            } else {
                generalPath2.moveTo(f2, f5);
                generalPath2.lineTo(f2, f);
                generalPath2.lineTo(f4, f8);
                generalPath2.closePath();
            }
        } else {
            f = (float)valueAxis2.valueToJava2D(d2 + dArray[0], rectangle2D, rectangleEdge2);
            float f10 = (float)valueAxis2.valueToJava2D(dArray[0], rectangle2D, rectangleEdge2);
            float f11 = (float)valueAxis2.valueToJava2D(dArray6[0], rectangle2D, rectangleEdge2);
            if (d4 >= 0.0) {
                generalPath.moveTo(f2, f10);
                generalPath.lineTo(f2, f);
                generalPath.lineTo(f3, f11);
                generalPath.clone();
            } else {
                double d11 = (d4 + d2) / 2.0 + dArray4[0];
                float f12 = (float)valueAxis2.valueToJava2D(d11, rectangle2D, rectangleEdge2);
                generalPath.moveTo(f2, f);
                generalPath.lineTo(f2, f10);
                generalPath.lineTo(f3, f11);
                generalPath.lineTo(f3, f12);
                generalPath.closePath();
            }
            float f13 = (float)valueAxis2.valueToJava2D(dArray7[0], rectangle2D, rectangleEdge2);
            if (d6 >= 0.0) {
                generalPath2.moveTo(f2, f10);
                generalPath2.lineTo(f2, f);
                generalPath2.lineTo(f4, f13);
                generalPath2.closePath();
            } else {
                double d12 = (d2 + d6) / 2.0 + dArray5[0];
                float f14 = (float)valueAxis2.valueToJava2D(d12, rectangle2D, rectangleEdge2);
                generalPath2.moveTo(f2, f10);
                generalPath2.lineTo(f2, f);
                generalPath2.lineTo(f4, f14);
                generalPath2.lineTo(f4, f13);
                generalPath2.closePath();
            }
        }
        Paint paint = this.getItemPaint(n, n2);
        if (n3 == 0) {
            graphics2D.setPaint(paint);
            graphics2D.fill(generalPath);
            graphics2D.fill(generalPath2);
        }
    }

    private double[] getStackValues(XYDataset xYDataset, int n, int n2) {
        double[] dArray = new double[2];
        int n3 = 0;
        while (n3 < n) {
            Number number = xYDataset.getY(n3, n2);
            if (number != null) {
                double d = number.doubleValue();
                if (d >= 0.0) {
                    dArray[1] = dArray[1] + d;
                } else {
                    dArray[0] = dArray[0] + d;
                }
            }
            ++n3;
        }
        return dArray;
    }

    private double[] averageStackValues(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{(dArray[0] + dArray2[0]) / 2.0, (dArray[1] + dArray2[1]) / 2.0};
        return dArray3;
    }

    private double[] adjustedStackValues(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[0] == 0.0 || dArray2[0] == 0.0 ? 0.0 : (dArray[0] + dArray2[0]) / 2.0, dArray[1] == 0.0 || dArray2[1] == 0.0 ? 0.0 : (dArray[1] + dArray2[1]) / 2.0};
        return dArray3;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

