/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.XYLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public abstract class AbstractXYItemRenderer
extends AbstractRenderer
implements XYItemRenderer,
Cloneable,
Serializable {
    private XYPlot plot;
    private XYLabelGenerator itemLabelGenerator = null;
    private ObjectList itemLabelGeneratorList = new ObjectList();
    private XYLabelGenerator baseItemLabelGenerator;
    private XYToolTipGenerator toolTipGenerator = null;
    private ObjectList toolTipGeneratorList = new ObjectList();
    private XYToolTipGenerator baseToolTipGenerator;
    private XYURLGenerator urlGenerator = null;
    private int defaultEntityRadius = 3;
    private static final LogContext LOGGER;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.renderer.xy.AbstractXYItemRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Log.createContext(clazz);
    }

    protected AbstractXYItemRenderer() {
    }

    public int getPassCount() {
        return 1;
    }

    public XYPlot getPlot() {
        return this.plot;
    }

    public void setPlot(XYPlot xYPlot) {
        this.plot = xYPlot;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYItemRendererState xYItemRendererState = new XYItemRendererState(plotRenderingInfo);
        return xYItemRendererState;
    }

    public XYLabelGenerator getLabelGenerator(int n, int n2) {
        return this.getSeriesLabelGenerator(n);
    }

    public XYLabelGenerator getSeriesLabelGenerator(int n) {
        if (this.itemLabelGenerator != null) {
            return this.itemLabelGenerator;
        }
        XYLabelGenerator xYLabelGenerator = (XYLabelGenerator)this.itemLabelGeneratorList.get(n);
        if (xYLabelGenerator == null) {
            xYLabelGenerator = this.baseItemLabelGenerator;
        }
        return xYLabelGenerator;
    }

    public void setLabelGenerator(XYLabelGenerator xYLabelGenerator) {
        this.itemLabelGenerator = xYLabelGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setSeriesLabelGenerator(int n, XYLabelGenerator xYLabelGenerator) {
        this.itemLabelGeneratorList.set(n, xYLabelGenerator);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYLabelGenerator getBaseLabelGenerator() {
        return this.baseItemLabelGenerator;
    }

    public void setBaseLabelGenerator(XYLabelGenerator xYLabelGenerator) {
        this.baseItemLabelGenerator = xYLabelGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYToolTipGenerator getToolTipGenerator(int n, int n2) {
        return this.getSeriesToolTipGenerator(n);
    }

    public XYToolTipGenerator getSeriesToolTipGenerator(int n) {
        if (this.toolTipGenerator != null) {
            return this.toolTipGenerator;
        }
        XYToolTipGenerator xYToolTipGenerator = (XYToolTipGenerator)this.toolTipGeneratorList.get(n);
        if (xYToolTipGenerator == null) {
            xYToolTipGenerator = this.baseToolTipGenerator;
        }
        return xYToolTipGenerator;
    }

    public void setToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        this.toolTipGenerator = xYToolTipGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setSeriesToolTipGenerator(int n, XYToolTipGenerator xYToolTipGenerator) {
        this.toolTipGeneratorList.set(n, xYToolTipGenerator);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYToolTipGenerator getBaseToolTipGenerator() {
        return this.baseToolTipGenerator;
    }

    public void setBaseToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        this.baseToolTipGenerator = xYToolTipGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(XYURLGenerator xYURLGenerator) {
        this.urlGenerator = xYURLGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public int getDefaultEntityRadius() {
        return this.defaultEntityRadius;
    }

    public void setDefaultEntityRadius(int n) {
        this.defaultEntityRadius = n;
    }

    public Range getRangeExtent(XYDataset xYDataset) {
        return DatasetUtilities.findRangeExtent(xYDataset);
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n)) != null) {
            String string;
            String string2 = string = xYDataset.getSeriesName(n2);
            Shape shape = this.getSeriesShape(n2);
            Paint paint = this.getSeriesPaint(n2);
            Paint paint2 = this.getSeriesOutlinePaint(n2);
            Stroke stroke = this.getSeriesStroke(n2);
            legendItem = new LegendItem(string, string2, shape, true, paint, stroke, paint2, stroke);
        }
        return legendItem;
    }

    public void fillDomainGridBand(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d, double d2) {
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, rectangle2D.getMinY(), d4 - d3, rectangle2D.getMaxY() - rectangle2D.getMinY());
        Paint paint = xYPlot.getDomainTickBandPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
        }
    }

    public void fillRangeGridBand(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d, double d2) {
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getMinX(), d4, rectangle2D.getWidth(), d3 - d4);
        Paint paint = xYPlot.getRangeTickBandPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
        }
    }

    public void drawDomainGridLine(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        }
        Paint paint = xYPlot.getDomainGridlinePaint();
        Stroke stroke = xYPlot.getDomainGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawRangeGridLine(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Line2D.Double double_ = null;
        double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        Paint paint = xYPlot.getRangeGridlinePaint();
        Stroke stroke = xYPlot.getRangeGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawDomainMarker(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        if (marker instanceof ValueMarker) {
            ValueMarker valueMarker = (ValueMarker)marker;
            double d = valueMarker.getValue();
            Range range = valueAxis.getRange();
            if (!range.contains(d)) {
                return;
            }
            double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            }
            graphics2D.setPaint(marker.getPaint());
            graphics2D.setStroke(marker.getStroke());
            graphics2D.draw(double_);
            String string = marker.getLabel();
            RectangleAnchor rectangleAnchor = marker.getLabelAnchor();
            if (string != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                double[] dArray = this.calculateDomainMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_.getBounds2D(), marker.getLabelOffset(), rectangleAnchor, false);
                TextUtilities.drawAlignedString(string, graphics2D, (float)dArray[0], (float)dArray[1], marker.getLabelTextAnchor());
            }
        } else if (marker instanceof IntervalMarker) {
            Object object;
            Object object2;
            IntervalMarker intervalMarker = (IntervalMarker)marker;
            double d = intervalMarker.getStartValue();
            double d3 = intervalMarker.getEndValue();
            Range range = valueAxis.getRange();
            if (!range.intersects(d, d3)) {
                return;
            }
            d = range.constrain(d);
            d3 = range.constrain(d3);
            double d4 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
            double d5 = valueAxis.valueToJava2D(d3, rectangle2D, xYPlot.getDomainAxisEdge());
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Rectangle2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Rectangle2D.Double(rectangle2D.getMinX(), Math.min(d4, d5), rectangle2D.getWidth(), Math.abs(d5 - d4));
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Rectangle2D.Double(Math.min(d4, d5), rectangle2D.getMinY(), Math.abs(d5 - d4), rectangle2D.getHeight());
            }
            Paint paint = marker.getPaint();
            if (paint instanceof GradientPaint) {
                object2 = (GradientPaint)paint;
                object = intervalMarker.getGradientPaintTransformer();
                if (object != null) {
                    object2 = object.transform((GradientPaint)object2, double_);
                }
                graphics2D.setPaint((Paint)object2);
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(double_);
            object2 = marker.getLabel();
            object = marker.getLabelAnchor();
            if (object2 != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                double[] dArray = this.calculateDomainMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_, marker.getLabelOffset(), (RectangleAnchor)object, true);
                TextUtilities.drawAlignedString((String)object2, graphics2D, (float)dArray[0], (float)dArray[1], marker.getLabelTextAnchor());
            }
        }
    }

    private double[] calculateDomainMarkerTextAnchorPoint(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleInsets rectangleInsets, RectangleAnchor rectangleAnchor, boolean bl) {
        double[] dArray = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            Rectangle2D rectangle2D3 = null;
            rectangle2D3 = bl ? rectangleInsets.createInsetRectangle(rectangle2D2, false, true) : rectangleInsets.createOutsetRectangle(rectangle2D2, false, true);
            dArray = RectangleAnchor.coordinates(rectangle2D3, rectangleAnchor);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            Rectangle2D rectangle2D4 = null;
            rectangle2D4 = bl ? rectangleInsets.createInsetRectangle(rectangle2D2, false, true) : rectangleInsets.createOutsetRectangle(rectangle2D2, false, true);
            dArray = RectangleAnchor.coordinates(rectangle2D4, rectangleAnchor);
        }
        return dArray;
    }

    public void drawRangeMarker(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        if (marker instanceof ValueMarker) {
            ValueMarker valueMarker = (ValueMarker)marker;
            double d = valueMarker.getValue();
            Range range = valueAxis.getRange();
            if (!range.contains(d)) {
                return;
            }
            double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
            }
            graphics2D.setPaint(marker.getPaint());
            graphics2D.setStroke(marker.getStroke());
            graphics2D.draw(double_);
            String string = marker.getLabel();
            RectangleAnchor rectangleAnchor = marker.getLabelAnchor();
            if (string != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                double[] dArray = this.calculateRangeMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_.getBounds2D(), marker.getLabelOffset(), rectangleAnchor);
                TextUtilities.drawAlignedString(string, graphics2D, (float)dArray[0], (float)dArray[1], marker.getLabelTextAnchor());
            }
        } else if (marker instanceof IntervalMarker) {
            Object object;
            Object object2;
            IntervalMarker intervalMarker = (IntervalMarker)marker;
            double d = intervalMarker.getStartValue();
            double d3 = intervalMarker.getEndValue();
            Range range = valueAxis.getRange();
            if (!range.intersects(d, d3)) {
                return;
            }
            d = range.constrain(d);
            d3 = range.constrain(d3);
            double d4 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
            double d5 = valueAxis.valueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Rectangle2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Rectangle2D.Double(Math.min(d4, d5), rectangle2D.getMinY(), Math.abs(d5 - d4), rectangle2D.getHeight());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Rectangle2D.Double(rectangle2D.getMinX(), Math.min(d4, d5), rectangle2D.getWidth(), Math.abs(d4 - d5));
            }
            Paint paint = marker.getPaint();
            if (paint instanceof GradientPaint) {
                object2 = (GradientPaint)paint;
                object = intervalMarker.getGradientPaintTransformer();
                if (object != null) {
                    object2 = object.transform((GradientPaint)object2, double_);
                }
                graphics2D.setPaint((Paint)object2);
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(double_);
            object2 = marker.getLabel();
            object = marker.getLabelAnchor();
            if (object2 != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                double[] dArray = this.calculateDomainMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_, marker.getLabelOffset(), (RectangleAnchor)object, true);
                TextUtilities.drawAlignedString((String)object2, graphics2D, (float)dArray[0], (float)dArray[1], marker.getLabelTextAnchor());
            }
        }
    }

    private double[] calculateRangeMarkerTextAnchorPoint(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleInsets rectangleInsets, RectangleAnchor rectangleAnchor) {
        double[] dArray = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            Rectangle2D rectangle2D3 = rectangleInsets.createOutsetRectangle(rectangle2D2, true, false);
            dArray = RectangleAnchor.coordinates(rectangle2D3, rectangleAnchor);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            Rectangle2D rectangle2D4 = rectangleInsets.createOutsetRectangle(rectangle2D2, false, true);
            dArray = RectangleAnchor.coordinates(rectangle2D4, rectangleAnchor);
        }
        return dArray;
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)super.clone();
        if (this.itemLabelGenerator != null && this.itemLabelGenerator instanceof PublicCloneable) {
            PublicCloneable publicCloneable = (PublicCloneable)((Object)this.itemLabelGenerator);
            abstractXYItemRenderer.itemLabelGenerator = (XYLabelGenerator)publicCloneable.clone();
        }
        return abstractXYItemRenderer;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractXYItemRenderer)) {
            return false;
        }
        AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)object;
        if (!super.equals(object)) {
            return false;
        }
        if (!ObjectUtils.equal(this.itemLabelGenerator, abstractXYItemRenderer.itemLabelGenerator)) {
            return false;
        }
        return ObjectUtils.equal(this.urlGenerator, abstractXYItemRenderer.urlGenerator);
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null) {
            drawingSupplier = xYPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }

    protected void updateCrosshairValues(CrosshairState crosshairState, double d, double d2, double d3, double d4, PlotOrientation plotOrientation) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        if (crosshairState != null) {
            if (this.plot.isDomainCrosshairLockedOnData()) {
                if (this.plot.isRangeCrosshairLockedOnData()) {
                    crosshairState.updateCrosshairPoint(d, d2, d3, d4, plotOrientation);
                } else {
                    crosshairState.updateCrosshairX(d);
                }
            } else if (this.plot.isRangeCrosshairLockedOnData()) {
                crosshairState.updateCrosshairY(d2);
            }
        }
    }

    protected void drawItemLabel(Graphics2D graphics2D, PlotOrientation plotOrientation, XYDataset xYDataset, int n, int n2, double d, double d2, boolean bl) {
        XYLabelGenerator xYLabelGenerator = this.getLabelGenerator(n, n2);
        if (xYLabelGenerator != null) {
            Font font = this.getItemLabelFont(n, n2);
            Paint paint = this.getItemLabelPaint(n, n2);
            graphics2D.setFont(font);
            graphics2D.setPaint(paint);
            String string = xYLabelGenerator.generateLabel(xYDataset, n, n2);
            ItemLabelPosition itemLabelPosition = null;
            itemLabelPosition = !bl ? this.getPositiveItemLabelPosition(n, n2) : this.getNegativeItemLabelPosition(n, n2);
            Point2D point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), d, d2, plotOrientation);
            RefineryUtilities.drawRotatedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getRotationAnchor(), itemLabelPosition.getAngle());
        }
    }

    protected void addEntity(EntityCollection entityCollection, Shape shape, XYDataset xYDataset, int n, int n2, double d, double d2) {
        if (shape == null) {
            shape = new Ellipse2D.Double(d - (double)this.defaultEntityRadius, d2 - (double)this.defaultEntityRadius, this.defaultEntityRadius * 2, this.defaultEntityRadius * 2);
        }
        String string = null;
        XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
        if (xYToolTipGenerator != null) {
            string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
        }
        String string2 = null;
        if (this.getURLGenerator() != null) {
            string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
        }
        XYItemEntity xYItemEntity = new XYItemEntity(shape, xYDataset, n, n2, string, string2);
        entityCollection.addEntity(xYItemEntity);
    }
}

