/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.BooleanList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public class LineAndShapeRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    private boolean drawShapes;
    private boolean drawLines;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private Boolean defaultShapesFilled;
    private boolean useFillPaintForShapeOutline = false;

    public LineAndShapeRenderer() {
        this(3);
    }

    public LineAndShapeRenderer(int n) {
        if (n == 1) {
            this.drawShapes = true;
        }
        if (n == 2) {
            this.drawLines = true;
        }
        if (n == 3) {
            this.drawShapes = true;
            this.drawLines = true;
        }
        this.shapesFilled = null;
        this.seriesShapesFilled = new BooleanList();
        this.defaultShapesFilled = Boolean.TRUE;
    }

    public boolean getUseFillPaintForShapeOutline() {
        return this.useFillPaintForShapeOutline;
    }

    public void setUseFillPaintForShapeOutline(boolean bl) {
        this.useFillPaintForShapeOutline = bl;
    }

    public boolean isDrawShapes() {
        return this.drawShapes;
    }

    public void setDrawShapes(boolean bl) {
        if (bl != this.drawShapes) {
            this.drawShapes = bl;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public boolean isDrawLines() {
        return this.drawLines;
    }

    public void setDrawLines(boolean bl) {
        if (bl != this.drawLines) {
            this.drawLines = bl;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public boolean getItemShapeFilled(int n, int n2) {
        return this.getSeriesShapesFilled(n);
    }

    public boolean getSeriesShapesFilled(int n) {
        if (this.shapesFilled != null) {
            return this.shapesFilled;
        }
        Boolean bl = this.seriesShapesFilled.getBoolean(n);
        if (bl != null) {
            return bl;
        }
        return this.defaultShapesFilled;
    }

    public Boolean getShapesFilled() {
        return this.shapesFilled;
    }

    public void setShapesFilled(boolean bl) {
        if (bl) {
            this.setShapesFilled(Boolean.TRUE);
        } else {
            this.setShapesFilled(Boolean.FALSE);
        }
    }

    public void setShapesFilled(Boolean bl) {
        this.shapesFilled = bl;
    }

    public void setSeriesShapesFilled(int n, Boolean bl) {
        this.seriesShapesFilled.setBoolean(n, bl);
    }

    public void setSeriesShapesFilled(int n, boolean bl) {
        this.seriesShapesFilled.setBoolean(n, new Boolean(bl));
    }

    public Boolean getDefaultShapesFilled() {
        return this.defaultShapesFilled;
    }

    public void setDefaultShapesFilled(Boolean bl) {
        this.defaultShapesFilled = bl;
    }

    public void setDefaultShapesFilled(boolean bl) {
        this.setDefaultShapesFilled(new Boolean(bl));
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Object object;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d2 = number.doubleValue();
        double d3 = valueAxis.valueToJava2D(d2, rectangle2D, categoryPlot.getRangeAxisEdge());
        Shape shape = this.getItemShape(n, n2);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            shape = this.createTransformedShape(shape, d3, d);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            shape = this.createTransformedShape(shape, d, d3);
        }
        if (this.isDrawShapes()) {
            if (this.getItemShapeFilled(n, n2)) {
                graphics2D.setPaint(this.getItemPaint(n, n2));
                graphics2D.fill(shape);
            } else {
                if (this.useFillPaintForShapeOutline) {
                    graphics2D.setPaint(this.getItemPaint(n, n2));
                } else {
                    graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                }
                graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
                graphics2D.draw(shape);
            }
        }
        if (this.isDrawLines() && n2 != 0 && (object = categoryDataset.getValue(n, n2 - 1)) != null) {
            double d4 = ((Number)object).doubleValue();
            double d5 = categoryAxis.getCategoryMiddle(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d6 = valueAxis.valueToJava2D(d4, rectangle2D, categoryPlot.getRangeAxisEdge());
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(d6, d5, d3, d);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(d5, d6, d, d3);
            }
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.draw(double_);
        }
        if (this.isItemLabelVisible(n, n2)) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, d3, d, d2 < 0.0);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, d, d3, d2 < 0.0);
            }
        }
        if (categoryItemRendererState.getInfo() != null && (object = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null && shape != null) {
            String string = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (categoryToolTipGenerator != null) {
                string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(shape, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            object.addEntity(categoryItemEntity);
        }
    }

    public boolean equals(Object object) {
        boolean bl = super.equals(object);
        if (object instanceof LineAndShapeRenderer) {
            LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)object;
            boolean bl2 = lineAndShapeRenderer.drawLines == this.drawLines;
            boolean bl3 = lineAndShapeRenderer.drawShapes == this.drawShapes;
            boolean bl4 = ObjectUtils.equal(lineAndShapeRenderer.shapesFilled, this.shapesFilled);
            boolean bl5 = ObjectUtils.equal(lineAndShapeRenderer.seriesShapesFilled, this.seriesShapesFilled);
            boolean bl6 = ObjectUtils.equal(lineAndShapeRenderer.defaultShapesFilled, this.defaultShapesFilled);
            bl = bl && bl2 && bl3 && bl4 && bl5 && bl6;
        }
        return bl;
    }

    public Object clone() throws CloneNotSupportedException {
        LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)super.clone();
        lineAndShapeRenderer.seriesShapesFilled = (BooleanList)this.seriesShapesFilled.clone();
        return lineAndShapeRenderer;
    }
}

