/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.renderer.PolarItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtils;

public class PolarPlot
extends Plot
implements ValueAxisPlot,
RendererChangeListener,
Cloneable,
Serializable {
    private static final int MARGIN = 20;
    private static final double ANNOTATION_MARGIN = 7.0;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.gray;
    private List angleTicks;
    private ValueAxis radiusAxis;
    private XYDataset dataset;
    private PolarItemRenderer renderer;
    private boolean angleLabelsVisible = true;
    private Font angleLabelFont = new Font("SansSerif", 0, 12);
    private Paint angleLabelPaint = Color.black;
    private boolean angleGridlinesVisible;
    private transient Stroke angleGridlineStroke;
    private transient Paint angleGridlinePaint;
    private boolean radiusGridlinesVisible;
    private transient Stroke radiusGridlineStroke;
    private transient Paint radiusGridlinePaint;
    private List cornerTextItems = new ArrayList();

    public PolarPlot() {
        this(null, null, null);
    }

    public PolarPlot(XYDataset xYDataset, ValueAxis valueAxis, PolarItemRenderer polarItemRenderer) {
        this.dataset = xYDataset;
        if (this.dataset != null) {
            this.dataset.addChangeListener(this);
        }
        this.angleTicks = new ArrayList();
        this.angleTicks.add(new NumberTick(new Double(0.0), "0", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.angleTicks.add(new NumberTick(new Double(45.0), "45", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.angleTicks.add(new NumberTick(new Double(90.0), "90", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.angleTicks.add(new NumberTick(new Double(135.0), "135", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.angleTicks.add(new NumberTick(new Double(180.0), "180", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.angleTicks.add(new NumberTick(new Double(225.0), "225", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.angleTicks.add(new NumberTick(new Double(270.0), "270", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.angleTicks.add(new NumberTick(new Double(315.0), "315", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        this.radiusAxis = valueAxis;
        if (this.radiusAxis != null) {
            this.radiusAxis.setPlot(this);
            this.radiusAxis.addChangeListener(this);
        }
        this.renderer = polarItemRenderer;
        if (this.renderer != null) {
            this.renderer.setPlot(this);
            this.renderer.addChangeListener(this);
        }
        this.angleGridlinesVisible = true;
        this.angleGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.angleGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.radiusGridlinesVisible = true;
        this.radiusGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.radiusGridlinePaint = DEFAULT_GRIDLINE_PAINT;
    }

    public void addCornerTextItem(String string) {
        this.cornerTextItems.add(string);
    }

    public void removeCornerTextItem(String string) {
        this.cornerTextItems.remove(string);
    }

    public void clearCornerTextItem() {
        this.cornerTextItems.clear();
    }

    public String getPlotType() {
        return this.getClass().getName();
    }

    public ValueAxis getRadialAxis() {
        Plot plot;
        ValueAxis valueAxis = this.radiusAxis;
        if (valueAxis == null && (plot = this.getParent()) instanceof PolarPlot) {
            PolarPlot polarPlot = (PolarPlot)plot;
            valueAxis = polarPlot.getRadialAxis();
        }
        return valueAxis;
    }

    public void setRadialAxis(ValueAxis valueAxis) {
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        if (this.radiusAxis != null) {
            this.radiusAxis.removeChangeListener(this);
        }
        this.radiusAxis = valueAxis;
        if (this.radiusAxis != null) {
            this.radiusAxis.configure();
            this.radiusAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public XYDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(XYDataset xYDataset) {
        XYDataset xYDataset2 = this.dataset;
        if (xYDataset2 != null) {
            xYDataset2.removeChangeListener(this);
        }
        this.dataset = xYDataset;
        if (this.dataset != null) {
            this.setDatasetGroup(this.dataset.getGroup());
            this.dataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, this.dataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public PolarItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(PolarItemRenderer polarItemRenderer) {
        if (this.renderer != null) {
            this.renderer.removeChangeListener(this);
        }
        this.renderer = polarItemRenderer;
        if (this.renderer != null) {
            this.renderer.setPlot(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isAngleLabelsVisible() {
        return this.angleLabelsVisible;
    }

    public void setAngleLabelsVisible(boolean bl) {
        this.angleLabelsVisible = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Font getAngleLabelFont() {
        return this.angleLabelFont;
    }

    public void setAngleLabelFont(Font font) {
        this.angleLabelFont = font;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getAngleLabelPaint() {
        return this.angleLabelPaint;
    }

    public void setAngleLabelPaint(Paint paint) {
        this.angleLabelPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isAngleGridlinesVisible() {
        return this.angleGridlinesVisible;
    }

    public void setAngleGridlinesVisible(boolean bl) {
        if (this.angleGridlinesVisible != bl) {
            this.angleGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getAngleGridlineStroke() {
        return this.angleGridlineStroke;
    }

    public void setAngleGridlineStroke(Stroke stroke) {
        this.angleGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getAngleGridlinePaint() {
        return this.angleGridlinePaint;
    }

    public void setAngleGridlinePaint(Paint paint) {
        this.angleGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRadiusGridlinesVisible() {
        return this.radiusGridlinesVisible;
    }

    public void setRadiusGridlinesVisible(boolean bl) {
        if (this.radiusGridlinesVisible != bl) {
            this.radiusGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRadiusGridlineStroke() {
        return this.radiusGridlineStroke;
    }

    public void setRadiusGridlineStroke(Stroke stroke) {
        this.radiusGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRadiusGridlinePaint() {
        return this.radiusGridlinePaint;
    }

    public void setRadiusGridlinePaint(Paint paint) {
        this.radiusGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Insets insets;
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        Rectangle2D rectangle2D2 = rectangle2D;
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
        this.drawBackground(graphics2D, rectangle2D2);
        double d = Math.min(rectangle2D2.getWidth() / 2.0, rectangle2D2.getHeight() / 2.0) - 20.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D2.getCenterX(), rectangle2D2.getCenterY(), d, d);
        AxisState axisState = this.drawAxis(graphics2D, rectangle2D, double_);
        if (this.renderer != null) {
            Shape shape = graphics2D.getClip();
            Composite composite = graphics2D.getComposite();
            graphics2D.clip(rectangle2D2);
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
            this.drawGridlines(graphics2D, rectangle2D2, this.angleTicks, axisState.getTicks());
            this.render(graphics2D, rectangle2D2, plotRenderingInfo);
            graphics2D.setClip(shape);
            graphics2D.setComposite(composite);
        }
        this.drawOutline(graphics2D, rectangle2D2);
        this.drawCornerTextItems(graphics2D, rectangle2D2);
    }

    public void drawCornerTextItems(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.cornerTextItems.isEmpty()) {
            return;
        }
        graphics2D.setColor(Color.black);
        double d = 0.0;
        double d2 = 0.0;
        Iterator iterator = this.cornerTextItems.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
            d = Math.max(d, rectangle2D2.getWidth());
            d2 += rectangle2D2.getHeight();
        }
        double d3 = 14.0;
        double d4 = 7.0;
        double d5 = rectangle2D.getMaxX() - (d += d3);
        double d6 = rectangle2D.getMaxY() - (d2 += d4);
        graphics2D.drawRect((int)d5, (int)d6, (int)d, (int)d2);
        d5 += 7.0;
        Iterator iterator2 = this.cornerTextItems.iterator();
        while (iterator2.hasNext()) {
            String string = (String)iterator2.next();
            Rectangle2D rectangle2D3 = TextUtilities.getTextBounds(string, graphics2D, graphics2D.getFontMetrics());
            graphics2D.drawString(string, (int)d5, (int)(d6 += rectangle2D3.getHeight()));
        }
    }

    protected AxisState drawAxis(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        return this.radiusAxis.draw(graphics2D, rectangle2D2.getMinY(), rectangle2D, rectangle2D2, RectangleEdge.TOP, null);
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        if (!DatasetUtilities.isEmptyOrNull(this.dataset)) {
            int n = this.dataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                this.renderer.drawSeries(graphics2D, rectangle2D, plotRenderingInfo, this, this.dataset, n2);
                ++n2;
            }
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
    }

    protected void drawGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list, List list2) {
        Paint paint;
        Stroke stroke;
        if (this.renderer == null) {
            return;
        }
        if (this.isAngleGridlinesVisible()) {
            stroke = this.getAngleGridlineStroke();
            paint = this.getAngleGridlinePaint();
            if (stroke != null && paint != null) {
                this.renderer.drawAngularGridLines(graphics2D, this, list, rectangle2D);
            }
        }
        if (this.isRadiusGridlinesVisible()) {
            stroke = this.getRadiusGridlineStroke();
            paint = this.getRadiusGridlinePaint();
            if (stroke != null && paint != null) {
                this.renderer.drawRadialGridLines(graphics2D, this, this.radiusAxis, list2, rectangle2D);
            }
        }
    }

    public void zoom(double d) {
        if (d > 0.0) {
            double d2 = this.getMaxRadius();
            double d3 = d2 * d;
            this.radiusAxis.setUpperBound(d3);
            this.getRadialAxis().setAutoRange(false);
        } else {
            this.getRadialAxis().setAutoRange(true);
        }
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        range = Range.combine(range, DatasetUtilities.findRangeExtent(this.dataset));
        return range;
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        if (this.radiusAxis != null) {
            this.radiusAxis.configure();
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(datasetChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    public void rendererChanged(RendererChangeEvent rendererChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getSeriesCount() {
        int n = 0;
        if (this.dataset != null) {
            n = this.dataset.getSeriesCount();
        }
        return n;
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.dataset != null && this.renderer != null) {
            int n = this.dataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                LegendItem legendItem = this.renderer.getLegendItem(n2);
                legendItemCollection.add(legendItem);
                ++n2;
            }
        }
        return legendItemCollection;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (super.equals(object) && object instanceof PolarPlot) {
            PolarPlot polarPlot = (PolarPlot)object;
            boolean bl = ObjectUtils.equal(this.radiusAxis, polarPlot.radiusAxis);
            boolean bl2 = ObjectUtils.equal(this.renderer, polarPlot.renderer);
            boolean bl3 = this.angleGridlinesVisible == polarPlot.angleGridlinesVisible;
            boolean bl4 = ObjectUtils.equal(this.angleGridlineStroke, polarPlot.angleGridlineStroke);
            boolean bl5 = ObjectUtils.equal(this.angleGridlinePaint, polarPlot.angleGridlinePaint);
            boolean bl6 = this.radiusGridlinesVisible == polarPlot.radiusGridlinesVisible;
            boolean bl7 = ObjectUtils.equal(this.radiusGridlineStroke, polarPlot.radiusGridlineStroke);
            boolean bl8 = ObjectUtils.equal(this.radiusGridlinePaint, polarPlot.radiusGridlinePaint);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        PolarPlot polarPlot = (PolarPlot)super.clone();
        polarPlot.radiusAxis = (ValueAxis)ObjectUtils.clone(this.radiusAxis);
        if (polarPlot.radiusAxis != null) {
            polarPlot.radiusAxis.setPlot(polarPlot);
            polarPlot.radiusAxis.addChangeListener(polarPlot);
        }
        if (polarPlot.dataset != null) {
            polarPlot.dataset.addChangeListener(polarPlot);
        }
        polarPlot.renderer = (PolarItemRenderer)ObjectUtils.clone(this.renderer);
        return polarPlot;
    }

    public void zoomHorizontalAxes(double d) {
        this.zoom(d);
    }

    public void zoomHorizontalAxes(double d, double d2) {
        this.zoom((d2 + d) / 2.0);
    }

    public void zoomVerticalAxes(double d) {
        this.zoom(d);
    }

    public void zoomVerticalAxes(double d, double d2) {
        this.zoom((d2 + d) / 2.0);
    }

    public double getMaxRadius() {
        return this.radiusAxis.getUpperBound();
    }

    public Point translateValueThetaRadiusToJava2D(double d, double d2, Rectangle2D rectangle2D) {
        double d3 = Math.toRadians(d - 90.0);
        double d4 = d2 * Math.cos(d3);
        double d5 = d2 * Math.sin(d3);
        double d6 = rectangle2D.getMinX() + 20.0;
        double d7 = rectangle2D.getMaxX() - 20.0;
        double d8 = rectangle2D.getMinY() + 20.0;
        double d9 = rectangle2D.getMaxY() - 20.0;
        double d10 = d7 - d6;
        double d11 = d9 - d8;
        double d12 = Math.min(d10, d11);
        double d13 = d6 + d10 / 2.0;
        double d14 = d8 + d11 / 2.0;
        double d15 = -this.getMaxRadius();
        double d16 = this.getMaxRadius();
        float f = (float)(d13 + d4 / (d16 - d15) * d12);
        float f2 = (float)(d14 + d5 / (d16 - d15) * d12);
        int n = Math.round(f);
        int n2 = Math.round(f2);
        Point point = new Point(n, n2);
        return point;
    }
}

