/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PieLabelDistributor;
import org.jfree.chart.plot.PieLabelRecord;
import org.jfree.chart.plot.PiePlotState;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBox;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PaintList;
import org.jfree.util.Rotation;
import org.jfree.util.ShapeUtils;
import org.jfree.util.StrokeList;

public class PiePlot
extends Plot
implements Cloneable,
Serializable {
    public static final double DEFAULT_INTERIOR_GAP = 0.25;
    public static final double MAX_INTERIOR_GAP = 0.4;
    public static final double DEFAULT_START_ANGLE = 90.0;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_LABEL_PAINT = Color.black;
    public static final Paint DEFAULT_LABEL_BACKGROUND_PAINT = new Color(255, 255, 192);
    public static final Paint DEFAULT_LABEL_OUTLINE_PAINT = Color.black;
    public static final Stroke DEFAULT_LABEL_OUTLINE_STROKE = new BasicStroke(0.5f);
    public static final Paint DEFAULT_LABEL_SHADOW_PAINT = Color.lightGray;
    public static final double DEFAULT_MINIMUM_ARC_ANGLE_TO_DRAW = 1.0E-5;
    private PieDataset dataset;
    private int pieIndex;
    private double interiorGap;
    private boolean circular;
    private double startAngle;
    private Rotation direction;
    private transient Paint sectionPaint;
    private PaintList sectionPaintList;
    private transient Paint baseSectionPaint;
    private transient Paint sectionOutlinePaint;
    private PaintList sectionOutlinePaintList;
    private transient Paint baseSectionOutlinePaint;
    private transient Stroke sectionOutlineStroke;
    private StrokeList sectionOutlineStrokeList;
    private transient Stroke baseSectionOutlineStroke;
    private transient Paint shadowPaint = Color.gray;
    private double shadowXOffset = 4.0;
    private double shadowYOffset = 4.0;
    private ObjectList explodePercentages;
    private PieSectionLabelGenerator labelGenerator;
    private Font labelFont;
    private transient Paint labelPaint;
    private transient Paint labelBackgroundPaint;
    private transient Paint labelOutlinePaint;
    private transient Stroke labelOutlineStroke;
    private transient Paint labelShadowPaint;
    private double maximumLabelWidth = 0.2;
    private double labelGap = 0.05;
    private double labelLinkMargin = 0.05;
    private transient Paint labelLinkPaint = Color.black;
    private transient Stroke labelLinkStroke = new BasicStroke(0.5f);
    private PieToolTipGenerator toolTipGenerator;
    private PieURLGenerator urlGenerator;
    private boolean ignoreNullValues = false;
    private double minimumArcAngleToDraw;
    private static final LogContext LOGGER;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.plot.PiePlot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Log.createContext(clazz);
    }

    public PiePlot() {
        this(null);
    }

    public PiePlot(PieDataset pieDataset) {
        this.dataset = pieDataset;
        if (pieDataset != null) {
            pieDataset.addChangeListener(this);
        }
        this.pieIndex = 0;
        this.interiorGap = 0.25;
        this.circular = true;
        this.startAngle = 90.0;
        this.direction = Rotation.CLOCKWISE;
        this.minimumArcAngleToDraw = 1.0E-5;
        this.sectionPaint = null;
        this.sectionPaintList = new PaintList();
        this.baseSectionPaint = null;
        this.sectionOutlinePaint = null;
        this.sectionOutlinePaintList = new PaintList();
        this.baseSectionOutlinePaint = Plot.DEFAULT_OUTLINE_PAINT;
        this.sectionOutlineStroke = null;
        this.sectionOutlineStrokeList = new StrokeList();
        this.baseSectionOutlineStroke = Plot.DEFAULT_OUTLINE_STROKE;
        this.explodePercentages = new ObjectList();
        this.labelGenerator = new StandardPieItemLabelGenerator();
        this.labelFont = DEFAULT_LABEL_FONT;
        this.labelPaint = DEFAULT_LABEL_PAINT;
        this.labelBackgroundPaint = DEFAULT_LABEL_BACKGROUND_PAINT;
        this.labelOutlinePaint = DEFAULT_LABEL_OUTLINE_PAINT;
        this.labelOutlineStroke = DEFAULT_LABEL_OUTLINE_STROKE;
        this.labelShadowPaint = DEFAULT_LABEL_SHADOW_PAINT;
        this.toolTipGenerator = null;
        this.urlGenerator = null;
    }

    public PieDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(PieDataset pieDataset) {
        PieDataset pieDataset2 = this.dataset;
        if (pieDataset2 != null) {
            pieDataset2.removeChangeListener(this);
        }
        this.dataset = pieDataset;
        if (pieDataset != null) {
            this.setDatasetGroup(pieDataset.getGroup());
            pieDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, pieDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public int getPieIndex() {
        return this.pieIndex;
    }

    public void setPieIndex(int n) {
        this.pieIndex = n;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Rotation getDirection() {
        return this.direction;
    }

    public void setDirection(Rotation rotation) {
        if (rotation == null) {
            throw new IllegalArgumentException("Null 'direction' argument.");
        }
        this.direction = rotation;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(double d) {
        if (d < 0.0 || d > 0.4) {
            throw new IllegalArgumentException("PiePlot.setInteriorGapPercent(double): percentage outside valid range.");
        }
        if (this.interiorGap != d) {
            this.interiorGap = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean bl) {
        this.setCircular(bl, true);
    }

    public void setCircular(boolean bl, boolean bl2) {
        this.circular = bl;
        if (bl2) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getSectionPaint() {
        return this.sectionPaint;
    }

    public void setSectionPaint(Paint paint) {
        this.sectionPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSectionPaint(int n) {
        if (this.sectionPaint != null) {
            return this.sectionPaint;
        }
        Paint paint = this.sectionPaintList.getPaint(n);
        if (paint == null) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                Paint paint2 = drawingSupplier.getNextPaint();
                this.sectionPaintList.setPaint(n, paint2);
                paint = paint2;
            } else {
                paint = this.baseSectionPaint;
            }
        }
        return paint;
    }

    public void setSectionPaint(int n, Paint paint) {
        this.sectionPaintList.setPaint(n, paint);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getBaseSectionPaint() {
        return this.baseSectionPaint;
    }

    public void setBaseSectionPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSectionPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSectionOutlinePaint() {
        return this.sectionOutlinePaint;
    }

    public void setSectionOutlinePaint(Paint paint) {
        this.sectionOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSectionOutlinePaint(int n) {
        if (this.sectionOutlinePaint != null) {
            return this.sectionOutlinePaint;
        }
        Paint paint = this.sectionOutlinePaintList.getPaint(n);
        if (paint == null) {
            paint = this.baseSectionOutlinePaint;
        }
        return paint;
    }

    public void setSectionOutlinePaint(int n, Paint paint) {
        this.sectionOutlinePaintList.setPaint(n, paint);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getBaseSectionOutlinePaint() {
        return this.baseSectionOutlinePaint;
    }

    public void setBaseSectionOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSectionOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSectionOutlineStroke() {
        return this.sectionOutlineStroke;
    }

    public void setSectionOutlineStroke(Stroke stroke) {
        this.sectionOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSectionOutlineStroke(int n) {
        if (this.sectionOutlineStroke != null) {
            return this.sectionOutlineStroke;
        }
        Stroke stroke = this.sectionOutlineStrokeList.getStroke(n);
        if (stroke == null) {
            stroke = this.baseSectionOutlineStroke;
        }
        return stroke;
    }

    public void setSectionOutlineStroke(int n, Stroke stroke) {
        this.sectionOutlineStrokeList.setStroke(n, stroke);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getBaseSectionOutlineStroke() {
        return this.baseSectionOutlineStroke;
    }

    public void setBaseSectionOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.baseSectionOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Paint paint) {
        this.shadowPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double d) {
        this.shadowXOffset = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double d) {
        this.shadowYOffset = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getExplodePercent(int n) {
        Number number;
        double d = 0.0;
        if (this.explodePercentages != null && (number = (Number)this.explodePercentages.get(n)) != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public void setExplodePercent(int n, double d) {
        if (this.explodePercentages == null) {
            this.explodePercentages = new ObjectList();
        }
        this.explodePercentages.set(n, new Double(d));
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getMaximumExplodePercent() {
        double d = 0.0;
        int n = 0;
        while (n < this.explodePercentages.size()) {
            Number number = (Number)this.explodePercentages.get(n);
            if (number != null) {
                d = Math.max(d, number.doubleValue());
            }
            ++n;
        }
        return d;
    }

    public PieSectionLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabelGenerator(PieSectionLabelGenerator pieSectionLabelGenerator) {
        this.labelGenerator = pieSectionLabelGenerator;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getLabelGap() {
        return this.labelGap;
    }

    public void setLabelGap(double d) {
        this.labelGap = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getMaximumLabelWidth() {
        return this.maximumLabelWidth;
    }

    public void setMaximumLabelWidth(double d) {
        this.maximumLabelWidth = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getLabelLinkMargin() {
        return this.labelLinkMargin;
    }

    public void setLabelLinkMargin(double d) {
        this.labelLinkMargin = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelLinkPaint() {
        return this.labelLinkPaint;
    }

    public void setLabelLinkPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelLinkPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getLabelLinkStroke() {
        return this.labelLinkStroke;
    }

    public void setLabelLinkStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.labelLinkStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.labelFont = font;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelBackgroundPaint() {
        return this.labelBackgroundPaint;
    }

    public void setLabelBackgroundPaint(Paint paint) {
        this.labelBackgroundPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelOutlinePaint() {
        return this.labelOutlinePaint;
    }

    public void setLabelOutlinePaint(Paint paint) {
        this.labelOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getLabelOutlineStroke() {
        return this.labelOutlineStroke;
    }

    public void setLabelOutlineStroke(Stroke stroke) {
        this.labelOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelShadowPaint() {
        return this.labelShadowPaint;
    }

    public void setLabelShadowPaint(Paint paint) {
        this.labelShadowPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public PieToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(PieToolTipGenerator pieToolTipGenerator) {
        this.toolTipGenerator = pieToolTipGenerator;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public PieURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(PieURLGenerator pieURLGenerator) {
        this.urlGenerator = pieURLGenerator;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getMinimumArcAngleToDraw() {
        return this.minimumArcAngleToDraw;
    }

    public void setMinimumArcAngleToDraw(double d) {
        this.minimumArcAngleToDraw = d;
    }

    public boolean getIgnoreNullValues() {
        return this.ignoreNullValues;
    }

    public void setIgnoreNullValues(boolean bl) {
        this.ignoreNullValues = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public PiePlotState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, PiePlot piePlot, Integer n, PlotRenderingInfo plotRenderingInfo) {
        PiePlotState piePlotState = new PiePlotState(plotRenderingInfo);
        piePlotState.setPassesRequired(2);
        piePlotState.setTotal(DatasetUtilities.calculatePieDatasetTotal(piePlot.getDataset()));
        piePlotState.setLatestAngle(piePlot.getStartAngle());
        return piePlotState;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Insets insets;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entering draw() method, plot area = " + rectangle2D.toString());
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
            plotRenderingInfo.setDataArea(rectangle2D);
        }
        this.drawBackground(graphics2D, rectangle2D);
        this.drawOutline(graphics2D, rectangle2D);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        if (!DatasetUtilities.isEmptyOrNull(this.dataset)) {
            this.drawPie(graphics2D, rectangle2D, plotRenderingInfo);
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D);
    }

    protected void drawPie(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        PiePlotState piePlotState = this.initialise(graphics2D, rectangle2D, this, null, plotRenderingInfo);
        double d = 0.0;
        if (this.labelGenerator != null) {
            d = this.labelGap + this.maximumLabelWidth + this.labelLinkMargin;
        }
        double d2 = rectangle2D.getWidth() * (this.interiorGap + d);
        double d3 = rectangle2D.getHeight() * this.interiorGap;
        double d4 = rectangle2D.getX() + d2 / 2.0;
        double d5 = rectangle2D.getY() + d3 / 2.0;
        double d6 = rectangle2D.getWidth() - d2;
        double d7 = rectangle2D.getHeight() - d3;
        if (this.circular) {
            double d8 = Math.min(d6, d7) / 2.0;
            d4 = (d4 + d4 + d6) / 2.0 - d8;
            d5 = (d5 + d5 + d7) / 2.0 - d8;
            d6 = 2.0 * d8;
            d7 = 2.0 * d8;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, d6, d7);
        piePlotState.setLinkArea(double_);
        double d9 = ((RectangularShape)double_).getWidth() * this.labelLinkMargin;
        double d10 = ((RectangularShape)double_).getHeight() * this.labelLinkMargin;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d4 + d9 / 2.0, d5 + d10 / 2.0, d6 - d9, d7 - d10);
        piePlotState.setExplodedPieArea(double_2);
        double d11 = this.getMaximumExplodePercent();
        double d12 = d11 / (1.0 + d11);
        double d13 = ((RectangularShape)double_2).getWidth() * d12;
        double d14 = ((RectangularShape)double_2).getHeight() * d12;
        Rectangle2D.Double double_3 = new Rectangle2D.Double(((RectangularShape)double_2).getX() + d13 / 2.0, ((RectangularShape)double_2).getY() + d14 / 2.0, ((RectangularShape)double_2).getWidth() - d13, ((RectangularShape)double_2).getHeight() - d14);
        piePlotState.setPieArea(double_3);
        piePlotState.setPieCenterX(double_3.getCenterX());
        piePlotState.setPieCenterY(double_3.getCenterY());
        piePlotState.setPieWRadius(((RectangularShape)double_3).getWidth() / 2.0);
        piePlotState.setPieHRadius(((RectangularShape)double_3).getHeight() / 2.0);
        if (this.dataset != null && this.dataset.getKeys().size() > 0) {
            List list = this.dataset.getKeys();
            double d15 = DatasetUtilities.calculatePieDatasetTotal(this.dataset);
            int n = piePlotState.getPassesRequired();
            int n2 = 0;
            while (n2 < n) {
                double d16 = 0.0;
                int n3 = 0;
                while (n3 < list.size()) {
                    double d17;
                    Number number = this.dataset.getValue(n3);
                    if (number != null && (d17 = number.doubleValue()) > 0.0) {
                        d16 += d17;
                        this.drawItem(graphics2D, n3, double_2, piePlotState, n2);
                    }
                    ++n3;
                }
                ++n2;
            }
            this.drawLabels(graphics2D, list, d15, rectangle2D, double_, piePlotState);
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
    }

    protected void drawItem(Graphics2D graphics2D, int n, Rectangle2D rectangle2D, PiePlotState piePlotState, int n2) {
        Number number = this.dataset.getValue(n);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.direction == Rotation.CLOCKWISE) {
            d2 = piePlotState.getLatestAngle();
            d3 = d2 - d / piePlotState.getTotal() * 360.0;
        } else if (this.direction == Rotation.ANTICLOCKWISE) {
            d2 = piePlotState.getLatestAngle();
            d3 = d2 + d / piePlotState.getTotal() * 360.0;
        } else {
            throw new IllegalStateException("Rotation type not recognised.");
        }
        double d4 = d3 - d2;
        if (Math.abs(d4) > this.getMinimumArcAngleToDraw()) {
            double d5 = 0.0;
            double d6 = this.getMaximumExplodePercent();
            if (d6 > 0.0) {
                d5 = this.getExplodePercent(n) / d6;
            }
            Rectangle2D rectangle2D2 = this.getArcBounds(piePlotState.getPieArea(), piePlotState.getExplodedPieArea(), d2, d4, d5);
            Arc2D.Double double_ = new Arc2D.Double(rectangle2D2, d2, d4, 2);
            if (n2 == 0) {
                if (this.shadowPaint != null) {
                    Shape shape = ShapeUtils.translateShape(double_, (float)this.shadowXOffset, (float)this.shadowYOffset);
                    graphics2D.setPaint(this.shadowPaint);
                    graphics2D.fill(shape);
                }
            } else if (n2 == 1) {
                EntityCollection entityCollection;
                Paint paint = this.getSectionPaint(n);
                graphics2D.setPaint(paint);
                graphics2D.fill(double_);
                Paint paint2 = this.getSectionOutlinePaint(n);
                Stroke stroke = this.getSectionOutlineStroke(n);
                if (paint2 != null && stroke != null) {
                    graphics2D.setPaint(paint2);
                    graphics2D.setStroke(stroke);
                    graphics2D.draw(double_);
                }
                if (piePlotState.getInfo() != null && (entityCollection = piePlotState.getInfo().getOwner().getEntityCollection()) != null) {
                    Comparable comparable = this.dataset.getKey(n);
                    String string = null;
                    if (this.toolTipGenerator != null) {
                        string = this.toolTipGenerator.generateToolTip(this.dataset, comparable);
                    }
                    String string2 = null;
                    if (this.urlGenerator != null) {
                        string2 = this.urlGenerator.generateURL(this.dataset, comparable, this.pieIndex);
                    }
                    PieSectionEntity pieSectionEntity = new PieSectionEntity(double_, this.dataset, this.pieIndex, n, comparable, string, string2);
                    entityCollection.addEntity(pieSectionEntity);
                }
            }
        }
        piePlotState.setLatestAngle(d3);
    }

    protected void drawLabels(Graphics2D graphics2D, List list, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PiePlotState piePlotState) {
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        DefaultKeyedValues defaultKeyedValues2 = new DefaultKeyedValues();
        double d2 = 0.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            double d3;
            Comparable comparable = (Comparable)iterator.next();
            Number number = this.dataset.getValue(comparable);
            if (number == null || !((d3 = number.doubleValue()) > 0.0)) continue;
            d2 += d3;
            double d4 = this.startAngle + this.direction.getFactor() * ((d2 - d3 / 2.0) * 360.0) / d;
            if (Math.cos(Math.toRadians(d4)) < 0.0) {
                defaultKeyedValues.addValue(comparable, new Double(d4));
                continue;
            }
            defaultKeyedValues2.addValue(comparable, new Double(d4));
        }
        graphics2D.setFont(this.getLabelFont());
        float f = (float)(this.getMaximumLabelWidth() * rectangle2D.getWidth());
        if (this.labelGenerator != null) {
            this.drawLeftLabels(defaultKeyedValues, graphics2D, rectangle2D, rectangle2D2, f, piePlotState);
            this.drawRightLabels(defaultKeyedValues2, graphics2D, rectangle2D, rectangle2D2, f, piePlotState);
        }
        graphics2D.setComposite(composite);
    }

    protected void drawLeftLabels(KeyedValues keyedValues, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, float f, PiePlotState piePlotState) {
        PieLabelDistributor pieLabelDistributor = new PieLabelDistributor(keyedValues.getItemCount());
        double d = rectangle2D.getWidth() * this.labelGap;
        double d2 = piePlotState.getLinkArea().getHeight() / 2.0;
        int n = 0;
        while (n < keyedValues.getItemCount()) {
            String string = this.labelGenerator.generateSectionLabel(this.dataset, keyedValues.getKey(n));
            if (string != null) {
                TextBlock textBlock = TextUtilities.createTextBlock(string, this.labelFont, this.labelPaint, f, new G2TextMeasurer(graphics2D));
                TextBox textBox = new TextBox(textBlock);
                textBox.setBackgroundPaint(this.labelBackgroundPaint);
                textBox.setOutlinePaint(this.labelOutlinePaint);
                textBox.setOutlineStroke(this.labelOutlineStroke);
                textBox.setShadowPaint(this.labelShadowPaint);
                double d3 = Math.toRadians(keyedValues.getValue(n).doubleValue());
                double d4 = piePlotState.getPieCenterY() - Math.sin(d3) * d2;
                double d5 = textBox.getHeight(graphics2D);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Label height = " + d5);
                }
                pieLabelDistributor.addPieLabelRecord(new PieLabelRecord(keyedValues.getKey(n), d3, d4, textBox, d5, d / 2.0 + d / 2.0 * -Math.cos(d3), 0.9 + this.getExplodePercent(this.dataset.getIndex(keyedValues.getKey(n)))));
            }
            ++n;
        }
        pieLabelDistributor.distributeLabels(rectangle2D.getMinY(), rectangle2D.getHeight());
        n = 0;
        while (n < pieLabelDistributor.getItemCount()) {
            this.drawLeftLabel(graphics2D, piePlotState, pieLabelDistributor.getPieLabelRecord(n));
            ++n;
        }
    }

    protected void drawRightLabels(KeyedValues keyedValues, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, float f, PiePlotState piePlotState) {
        PieLabelDistributor pieLabelDistributor = new PieLabelDistributor(keyedValues.getItemCount());
        double d = rectangle2D.getWidth() * this.labelGap;
        double d2 = piePlotState.getLinkArea().getHeight() / 2.0;
        int n = 0;
        while (n < keyedValues.getItemCount()) {
            String string = this.labelGenerator.generateSectionLabel(this.dataset, keyedValues.getKey(n));
            if (string != null) {
                TextBlock textBlock = TextUtilities.createTextBlock(string, this.labelFont, this.labelPaint, f, new G2TextMeasurer(graphics2D));
                TextBox textBox = new TextBox(textBlock);
                textBox.setBackgroundPaint(this.labelBackgroundPaint);
                textBox.setOutlinePaint(this.labelOutlinePaint);
                textBox.setOutlineStroke(this.labelOutlineStroke);
                textBox.setShadowPaint(this.labelShadowPaint);
                double d3 = Math.toRadians(keyedValues.getValue(n).doubleValue());
                double d4 = piePlotState.getPieCenterY() - Math.sin(d3) * d2;
                double d5 = textBox.getHeight(graphics2D);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Label height = " + d5);
                }
                pieLabelDistributor.addPieLabelRecord(new PieLabelRecord(keyedValues.getKey(n), d3, d4, textBox, d5, d / 2.0 + d / 2.0 * Math.cos(d3), 0.9 + this.getExplodePercent(this.dataset.getIndex(keyedValues.getKey(n)))));
            }
            ++n;
        }
        pieLabelDistributor.distributeLabels(rectangle2D2.getMinY(), rectangle2D2.getHeight());
        n = 0;
        while (n < pieLabelDistributor.getItemCount()) {
            this.drawRightLabel(graphics2D, piePlotState, pieLabelDistributor.getPieLabelRecord(n));
            ++n;
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        List list = null;
        if (this.dataset != null) {
            list = this.dataset.getKeys();
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string;
                Comparable comparable = (Comparable)iterator.next();
                Number number = this.dataset.getValue(comparable);
                if (number == null && this.ignoreNullValues) continue;
                String string2 = string = comparable.toString();
                Shape shape = null;
                Paint paint = this.getSectionPaint(n);
                Paint paint2 = this.getSectionOutlinePaint(n);
                Stroke stroke = this.getSectionOutlineStroke(n);
                LegendItem legendItem = new LegendItem(string, string2, shape, true, paint, stroke, paint2, stroke);
                legendItemCollection.add(legendItem);
                ++n;
            }
        }
        return legendItemCollection;
    }

    public String getPlotType() {
        return this.getClass().getName();
    }

    public void zoom(double d) {
    }

    protected Rectangle2D getArcBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d, double d2, double d3) {
        if (d3 == 0.0) {
            return rectangle2D;
        }
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D, d, d2 / 2.0, 0);
        Point2D point2D = double_.getEndPoint();
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D2, d, d2 / 2.0, 0);
        Point2D point2D2 = double_2.getEndPoint();
        double d4 = (point2D.getX() - point2D2.getX()) * d3;
        double d5 = (point2D.getY() - point2D2.getY()) * d3;
        return new Rectangle2D.Double(rectangle2D.getX() - d4, rectangle2D.getY() - d5, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected void drawLeftLabel(Graphics2D graphics2D, PiePlotState piePlotState, PieLabelRecord pieLabelRecord) {
        double d = pieLabelRecord.getAngle();
        double d2 = piePlotState.getPieCenterX() + Math.cos(d) * piePlotState.getPieWRadius() * pieLabelRecord.getLinkPercent();
        double d3 = piePlotState.getPieCenterY() - Math.sin(d) * piePlotState.getPieHRadius() * pieLabelRecord.getLinkPercent();
        double d4 = piePlotState.getPieCenterX() + Math.cos(d) * piePlotState.getLinkArea().getWidth() / 2.0;
        double d5 = piePlotState.getPieCenterY() - Math.sin(d) * piePlotState.getLinkArea().getHeight() / 2.0;
        double d6 = piePlotState.getLinkArea().getMinX();
        double d7 = d5;
        double d8 = d6 - pieLabelRecord.getGap();
        double d9 = pieLabelRecord.getAllocatedY();
        graphics2D.setPaint(this.labelLinkPaint);
        graphics2D.setStroke(this.labelLinkStroke);
        graphics2D.draw(new Line2D.Double(d2, d3, d4, d5));
        graphics2D.draw(new Line2D.Double(d6, d7, d4, d5));
        graphics2D.draw(new Line2D.Double(d6, d7, d8, d9));
        TextBox textBox = pieLabelRecord.getLabel();
        textBox.draw(graphics2D, (float)d8, (float)d9, RectangleAnchor.RIGHT);
    }

    protected void drawRightLabel(Graphics2D graphics2D, PiePlotState piePlotState, PieLabelRecord pieLabelRecord) {
        double d = pieLabelRecord.getAngle();
        double d2 = piePlotState.getPieCenterX() + Math.cos(d) * piePlotState.getPieWRadius() * pieLabelRecord.getLinkPercent();
        double d3 = piePlotState.getPieCenterY() - Math.sin(d) * piePlotState.getPieHRadius() * pieLabelRecord.getLinkPercent();
        double d4 = piePlotState.getPieCenterX() + Math.cos(d) * piePlotState.getLinkArea().getWidth() / 2.0;
        double d5 = piePlotState.getPieCenterY() - Math.sin(d) * piePlotState.getLinkArea().getHeight() / 2.0;
        double d6 = piePlotState.getLinkArea().getMaxX();
        double d7 = d5;
        double d8 = d6 + pieLabelRecord.getGap();
        double d9 = pieLabelRecord.getAllocatedY();
        graphics2D.setPaint(this.labelLinkPaint);
        graphics2D.setStroke(this.labelLinkStroke);
        graphics2D.draw(new Line2D.Double(d2, d3, d4, d5));
        graphics2D.draw(new Line2D.Double(d6, d7, d4, d5));
        graphics2D.draw(new Line2D.Double(d6, d7, d8, d9));
        TextBox textBox = pieLabelRecord.getLabel();
        textBox.draw(graphics2D, (float)d8, (float)d9, RectangleAnchor.LEFT);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PiePlot && super.equals(object)) {
            boolean bl;
            PiePlot piePlot = (PiePlot)object;
            boolean bl2 = this.pieIndex == piePlot.pieIndex;
            boolean bl3 = this.interiorGap == piePlot.interiorGap;
            boolean bl4 = this.circular == piePlot.circular;
            boolean bl5 = this.startAngle == piePlot.startAngle;
            boolean bl6 = this.direction == piePlot.direction;
            boolean bl7 = ObjectUtils.equal(this.sectionPaint, piePlot.sectionPaint);
            boolean bl8 = ObjectUtils.equal(this.sectionPaintList, piePlot.sectionPaintList);
            boolean bl9 = ObjectUtils.equal(this.baseSectionPaint, piePlot.baseSectionPaint);
            boolean bl10 = ObjectUtils.equal(this.sectionOutlinePaint, piePlot.sectionOutlinePaint);
            boolean bl11 = ObjectUtils.equal(this.sectionOutlinePaintList, piePlot.sectionOutlinePaintList);
            boolean bl12 = ObjectUtils.equal(this.baseSectionOutlinePaint, piePlot.baseSectionOutlinePaint);
            boolean bl13 = ObjectUtils.equal(this.sectionOutlineStroke, piePlot.sectionOutlineStroke);
            boolean bl14 = ObjectUtils.equal(this.sectionOutlineStrokeList, piePlot.sectionOutlineStrokeList);
            boolean bl15 = ObjectUtils.equal(this.baseSectionOutlineStroke, piePlot.baseSectionOutlineStroke);
            boolean bl16 = ObjectUtils.equal(this.shadowPaint, piePlot.shadowPaint);
            boolean bl17 = this.shadowXOffset == piePlot.shadowXOffset;
            boolean bl18 = this.shadowYOffset == piePlot.shadowYOffset;
            boolean bl19 = ObjectUtils.equal(this.explodePercentages, piePlot.explodePercentages);
            boolean bl20 = ObjectUtils.equal(this.labelGenerator, piePlot.labelGenerator);
            boolean bl21 = ObjectUtils.equal(this.labelFont, piePlot.labelFont);
            boolean bl22 = ObjectUtils.equal(this.labelPaint, piePlot.labelPaint);
            boolean bl23 = ObjectUtils.equal(this.labelBackgroundPaint, piePlot.labelBackgroundPaint);
            boolean bl24 = ObjectUtils.equal(this.labelOutlinePaint, piePlot.labelOutlinePaint);
            boolean bl25 = ObjectUtils.equal(this.labelOutlineStroke, piePlot.labelOutlineStroke);
            boolean bl26 = ObjectUtils.equal(this.labelShadowPaint, piePlot.labelShadowPaint);
            boolean bl27 = this.maximumLabelWidth == piePlot.maximumLabelWidth;
            boolean bl28 = this.labelGap == piePlot.labelGap;
            boolean bl29 = this.labelLinkMargin == piePlot.labelLinkMargin;
            boolean bl30 = ObjectUtils.equal(this.labelLinkPaint, piePlot.labelLinkPaint);
            boolean bl31 = ObjectUtils.equal(this.labelLinkStroke, piePlot.labelLinkStroke);
            boolean bl32 = ObjectUtils.equal(this.toolTipGenerator, piePlot.toolTipGenerator);
            boolean bl33 = ObjectUtils.equal(this.urlGenerator, piePlot.urlGenerator);
            boolean bl34 = bl = this.minimumArcAngleToDraw == piePlot.minimumArcAngleToDraw;
            return bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15 && bl16 && bl17 && bl18 && bl19 && bl20 && bl21 && bl22 && bl23 && bl24 && bl25 && bl26 && bl27 && bl28 && bl29 && bl30 && bl31 && bl32 && bl33 && bl;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        PiePlot piePlot = (PiePlot)super.clone();
        if (piePlot.dataset != null) {
            piePlot.dataset.addChangeListener(piePlot);
        }
        return piePlot;
    }
}

