/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.List;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.ValueDataset;
import org.jfree.text.TextUtilities;
import org.jfree.util.ObjectUtils;

public class MeterPlot
extends Plot
implements Serializable,
Cloneable {
    public static final int NORMAL_DATA_RANGE = 0;
    public static final int WARNING_DATA_RANGE = 1;
    public static final int CRITICAL_DATA_RANGE = 2;
    public static final int FULL_DATA_RANGE = 3;
    public static final String NORMAL_TEXT = "Normal";
    public static final String WARNING_TEXT = "Warning";
    public static final String CRITICAL_TEXT = "Critical";
    static final Paint DEFAULT_NORMAL_PAINT = Color.green;
    static final Paint DEFAULT_WARNING_PAINT = Color.yellow;
    static final Paint DEFAULT_CRITICAL_PAINT = Color.red;
    static final Paint DEFAULT_DIAL_BACKGROUND_PAINT = Color.black;
    static final Paint DEFAULT_NEEDLE_PAINT = Color.green;
    static final Font DEFAULT_VALUE_FONT = new Font("SansSerif", 1, 12);
    static final Paint DEFAULT_VALUE_PAINT = Color.yellow;
    public static final int DEFAULT_METER_ANGLE = 270;
    public static final float DEFAULT_BORDER_SIZE = 3.0f;
    public static final float DEFAULT_CIRCLE_SIZE = 10.0f;
    public static final Paint DEFAULT_BACKGROUND_PAINT = Color.lightGray;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 10);
    public static final int NO_LABELS = 0;
    public static final int VALUE_LABELS = 1;
    private ValueDataset dataset;
    private String units = "Units";
    private Range range;
    private Range normalRange;
    private Range warningRange;
    private Range criticalRange;
    private transient Paint dialOutlinePaint;
    private transient Paint normalPaint = DEFAULT_NORMAL_PAINT;
    private transient Paint warningPaint = DEFAULT_WARNING_PAINT;
    private transient Paint criticalPaint = DEFAULT_CRITICAL_PAINT;
    private DialShape shape = DialShape.CIRCLE;
    private transient Paint dialBackgroundPaint;
    private transient Paint needlePaint;
    private Font valueFont;
    private transient Paint valuePaint;
    private int tickLabelType = 1;
    private Font tickLabelFont;
    private NumberFormat tickLabelFormat;
    private boolean drawBorder;
    private int meterCalcAngle = -1;
    private double meterRange = -1.0;
    private int meterAngle = 270;
    private double minMeterValue = 0.0;
    public static final int DIALTYPE_PIE = 0;
    public static final int DIALTYPE_CIRCLE = 1;
    public static final int DIALTYPE_CHORD = 2;

    public MeterPlot() {
        this(null);
    }

    public MeterPlot(ValueDataset valueDataset) {
        this.range = new Range(0.0, 100.0);
        this.normalRange = new Range(0.0, 60.0);
        this.warningRange = new Range(60.0, 90.0);
        this.criticalRange = new Range(90.0, 100.0);
        this.tickLabelFont = DEFAULT_LABEL_FONT;
        this.tickLabelFormat = NumberFormat.getInstance();
        this.dialBackgroundPaint = DEFAULT_DIAL_BACKGROUND_PAINT;
        this.needlePaint = DEFAULT_NEEDLE_PAINT;
        this.valueFont = DEFAULT_VALUE_FONT;
        this.valuePaint = DEFAULT_VALUE_PAINT;
        this.setDataset(valueDataset);
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String string) {
        this.units = string;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public Range getNormalRange() {
        return this.normalRange;
    }

    public void setNormalRange(Range range) {
        this.normalRange = range;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Range getWarningRange() {
        return this.warningRange;
    }

    public void setWarningRange(Range range) {
        this.warningRange = range;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Range getCriticalRange() {
        return this.criticalRange;
    }

    public void setCriticalRange(Range range) {
        this.criticalRange = range;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public DialShape getDialShape() {
        return this.shape;
    }

    public void setDialShape(DialShape dialShape) {
        this.shape = dialShape;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDialBackgroundPaint() {
        return this.dialBackgroundPaint;
    }

    public void setDialBackgroundPaint(Paint paint) {
        this.dialBackgroundPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getNeedlePaint() {
        return this.needlePaint;
    }

    public void setNeedlePaint(Paint paint) {
        this.needlePaint = paint == null ? DEFAULT_NEEDLE_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Font getValueFont() {
        return this.valueFont;
    }

    public void setValueFont(Font font) {
        this.valueFont = font == null ? DEFAULT_VALUE_FONT : font;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getValuePaint() {
        return this.valuePaint;
    }

    public void setValuePaint(Paint paint) {
        this.valuePaint = paint == null ? DEFAULT_VALUE_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getNormalPaint() {
        return this.normalPaint;
    }

    public void setNormalPaint(Paint paint) {
        this.normalPaint = paint == null ? DEFAULT_NORMAL_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getWarningPaint() {
        return this.warningPaint;
    }

    public void setWarningPaint(Paint paint) {
        this.warningPaint = paint == null ? DEFAULT_WARNING_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getCriticalPaint() {
        return this.criticalPaint;
    }

    public void setCriticalPaint(Paint paint) {
        this.criticalPaint = paint == null ? DEFAULT_CRITICAL_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getTickLabelType() {
        return this.tickLabelType;
    }

    public void setTickLabelType(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("MeterPlot.setLabelType(int): unrecognised type.");
        }
        if (this.tickLabelType != n) {
            this.tickLabelType = n;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (!this.tickLabelFont.equals(font)) {
            this.tickLabelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public NumberFormat getTickLabelFormat() {
        return this.tickLabelFormat;
    }

    public void setTickLabelFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'format' argument.");
        }
        this.tickLabelFormat = numberFormat;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
    }

    public int getMeterAngle() {
        return this.meterAngle;
    }

    public void setMeterAngle(int n) {
        this.meterAngle = n;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDialOutlinePaint() {
        return this.dialOutlinePaint;
    }

    public void setDialOutlinePaint(Paint paint) {
        this.dialOutlinePaint = paint;
    }

    public ValueDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(ValueDataset valueDataset) {
        ValueDataset valueDataset2 = this.dataset;
        if (valueDataset2 != null) {
            valueDataset2.removeChangeListener(this);
        }
        this.dataset = valueDataset;
        if (valueDataset != null) {
            this.setDatasetGroup(valueDataset.getGroup());
            valueDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, valueDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public List getLegendItemLabels() {
        return null;
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Insets insets;
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        rectangle2D.setRect(rectangle2D.getX() + 4.0, rectangle2D.getY() + 4.0, rectangle2D.getWidth() - 8.0, rectangle2D.getHeight() - 8.0);
        if (this.drawBorder) {
            this.drawBackground(graphics2D, rectangle2D);
        }
        double d = 6.0;
        double d2 = 6.0;
        double d3 = rectangle2D.getX() + d / 2.0;
        double d4 = rectangle2D.getY() + d2 / 2.0;
        double d5 = rectangle2D.getWidth() - d;
        double d6 = rectangle2D.getHeight() - d2 + (this.meterAngle <= 180 && this.shape != DialShape.CIRCLE ? rectangle2D.getHeight() / 1.25 : 0.0);
        double d7 = Math.min(d5, d6) / 2.0;
        d3 = (d3 + d3 + d5) / 2.0 - d7;
        d4 = (d4 + d4 + d6) / 2.0 - d7;
        d5 = 2.0 * d7;
        d6 = 2.0 * d7;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d5, d6);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(((RectangularShape)double_).getX() - 4.0, ((RectangularShape)double_).getY() - 4.0, ((RectangularShape)double_).getWidth() + 8.0, ((RectangularShape)double_).getHeight() + 8.0);
        double d8 = double_.getCenterX();
        double d9 = double_.getCenterY();
        ValueDataset valueDataset = this.getDataset();
        if (valueDataset != null) {
            double d10 = this.range.getLowerBound();
            double d11 = this.range.getUpperBound();
            this.minMeterValue = d10;
            this.meterCalcAngle = 180 + (this.meterAngle - 180) / 2;
            this.meterRange = d11 - d10;
            Shape shape = graphics2D.getClip();
            graphics2D.clip(double_2);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
            if (this.dialBackgroundPaint != null) {
                this.drawArc(graphics2D, double_2, d10, d11, this.dialBackgroundPaint, 1);
            }
            this.drawTicks(graphics2D, double_, d10, d11);
            this.drawArcFor(graphics2D, double_, valueDataset, 3);
            if (this.normalRange != null) {
                this.drawArcFor(graphics2D, double_, valueDataset, 0);
            }
            if (this.warningRange != null) {
                this.drawArcFor(graphics2D, double_, valueDataset, 1);
            }
            if (this.criticalRange != null) {
                this.drawArcFor(graphics2D, double_, valueDataset, 2);
            }
            if (valueDataset.getValue() != null) {
                double d12 = valueDataset.getValue().doubleValue();
                this.drawTick(graphics2D, double_, d12, true, this.valuePaint, true, this.getUnits());
                graphics2D.setPaint(this.needlePaint);
                graphics2D.setStroke(new BasicStroke(2.0f));
                double d13 = ((RectangularShape)double_).getWidth() / 2.0 + 3.0 + 15.0;
                double d14 = this.calculateAngle(d12);
                double d15 = d8 + d13 * Math.cos(Math.PI * (d14 / 180.0));
                double d16 = d9 - d13 * Math.sin(Math.PI * (d14 / 180.0));
                Polygon polygon = new Polygon();
                if (d14 > 135.0 && d14 < 225.0 || d14 < 45.0 && d14 > -45.0) {
                    double d17 = d9 - 2.5;
                    double d18 = d9 + 2.5;
                    polygon.addPoint((int)d8, (int)d17);
                    polygon.addPoint((int)d8, (int)d18);
                } else {
                    polygon.addPoint((int)(d8 - 2.5), (int)d9);
                    polygon.addPoint((int)(d8 + 2.5), (int)d9);
                }
                polygon.addPoint((int)d15, (int)d16);
                Ellipse2D.Double double_3 = new Ellipse2D.Double(d8 - 5.0, d9 - 5.0, 10.0, 10.0);
                graphics2D.fill(polygon);
                graphics2D.fill(double_3);
            }
            graphics2D.clip(shape);
            graphics2D.setComposite(composite);
        }
        if (this.drawBorder) {
            this.drawOutline(graphics2D, rectangle2D);
        }
    }

    protected void drawArcFor(Graphics2D graphics2D, Rectangle2D rectangle2D, ValueDataset valueDataset, int n) {
        double d = 0.0;
        double d2 = 0.0;
        Paint paint = null;
        switch (n) {
            case 0: {
                d = this.normalRange.getLowerBound();
                d2 = this.normalRange.getUpperBound();
                paint = this.getNormalPaint();
                break;
            }
            case 1: {
                d = this.warningRange.getLowerBound();
                d2 = this.warningRange.getUpperBound();
                paint = this.getWarningPaint();
                break;
            }
            case 2: {
                d = this.criticalRange.getLowerBound();
                d2 = this.criticalRange.getUpperBound();
                paint = this.getCriticalPaint();
                break;
            }
            case 3: {
                d = this.range.getLowerBound();
                d2 = this.range.getUpperBound();
                paint = DEFAULT_BACKGROUND_PAINT;
                break;
            }
            default: {
                return;
            }
        }
        this.drawArc(graphics2D, rectangle2D, d, d2, paint);
        this.drawTick(graphics2D, rectangle2D, d, true, paint);
        this.drawTick(graphics2D, rectangle2D, d2, true, paint);
    }

    protected void drawArc(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, double d2, Paint paint) {
        this.drawArc(graphics2D, rectangle2D, d, d2, paint, 0);
    }

    protected void drawArc(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, double d2, Paint paint, int n) {
        double d3 = this.calculateAngle(d2);
        double d4 = this.calculateAngle(d);
        double d5 = d4 - d3;
        double d6 = rectangle2D.getX();
        double d7 = rectangle2D.getY();
        double d8 = rectangle2D.getWidth();
        double d9 = rectangle2D.getHeight();
        graphics2D.setPaint(paint);
        if (n > 0) {
            graphics2D.setStroke(new BasicStroke(10.0f));
        } else {
            graphics2D.setStroke(new BasicStroke(3.0f));
        }
        int n2 = 0;
        if (n > 0) {
            if (this.shape == DialShape.PIE) {
                n2 = 2;
            } else if (this.shape == DialShape.CHORD) {
                n2 = this.meterAngle > 180 ? 1 : 2;
            } else if (this.shape == DialShape.CIRCLE) {
                n2 = 2;
                d5 = 360.0;
            } else {
                throw new IllegalStateException("MeterPlot.drawArc(...): dialType not recognised.");
            }
        }
        Arc2D.Double double_ = new Arc2D.Double(d6, d7, d8, d9, d3, d5, n2);
        if (n > 0) {
            graphics2D.fill(double_);
        } else {
            graphics2D.draw(double_);
        }
    }

    double calculateAngle(double d) {
        double d2 = (double)this.meterCalcAngle - (d -= this.minMeterValue) / this.meterRange * (double)this.meterAngle;
        return d2;
    }

    protected void drawTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, double d2) {
        int n = 20;
        double d3 = (d2 - d) / (double)n;
        double d4 = d;
        while (d4 <= d2) {
            this.drawTick(graphics2D, rectangle2D, d4);
            d4 += d3;
        }
    }

    protected void drawTick(Graphics2D graphics2D, Rectangle2D rectangle2D, double d) {
        this.drawTick(graphics2D, rectangle2D, d, false, null, false, null);
    }

    protected void drawTick(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, boolean bl, Paint paint) {
        this.drawTick(graphics2D, rectangle2D, d, bl, paint, false, null);
    }

    protected void drawTick(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, boolean bl, Paint paint, boolean bl2, String string) {
        double d2 = this.calculateAngle(d);
        double d3 = rectangle2D.getCenterX();
        double d4 = rectangle2D.getCenterY();
        if (paint == null) {
            paint = Color.white;
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(new BasicStroke(2.0f));
        double d5 = 0.0;
        double d6 = 0.0;
        if (!bl2) {
            double d7 = rectangle2D.getWidth() / 2.0 + 3.0;
            double d8 = d7 - 15.0;
            double d9 = d3 + d7 * Math.cos(Math.PI * (d2 / 180.0));
            double d10 = d4 - d7 * Math.sin(Math.PI * (d2 / 180.0));
            d5 = d3 + d8 * Math.cos(Math.PI * (d2 / 180.0));
            d6 = d4 - d8 * Math.sin(Math.PI * (d2 / 180.0));
            Line2D.Double double_ = new Line2D.Double(d9, d10, d5, d6);
            graphics2D.draw(double_);
        } else {
            d5 = d3;
            d6 = d4;
            d2 = 90.0;
        }
        if (this.tickLabelType == 1 && bl) {
            String string2 = this.tickLabelFormat.format(d);
            if (bl2 && string != null) {
                string2 = String.valueOf(string2) + " " + string;
            }
            if (bl2) {
                graphics2D.setFont(this.getValueFont());
            } else if (this.tickLabelFont != null) {
                graphics2D.setFont(this.tickLabelFont);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string2, graphics2D, fontMetrics);
            double d11 = d5;
            double d12 = d6;
            if (bl2) {
                d12 += 10.0;
            }
            if (d2 == 90.0 || d2 == 270.0) {
                d11 -= rectangle2D2.getWidth() / 2.0;
            } else if (d2 < 90.0 || d2 > 270.0) {
                d11 -= rectangle2D2.getWidth();
            }
            d12 = d2 > 135.0 && d2 < 225.0 || d2 > 315.0 || d2 < 45.0 ? (d12 -= rectangle2D2.getHeight() / 2.0) : (d12 += rectangle2D2.getHeight() / 2.0);
            graphics2D.drawString(string2, (float)d11, (float)d12);
        }
    }

    public String getPlotType() {
        return this.getClass().getName();
    }

    public void zoom(double d) {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MeterPlot && super.equals(object)) {
            MeterPlot meterPlot = (MeterPlot)object;
            if (!ObjectUtils.equal(this.units, meterPlot.units)) {
                return false;
            }
            if (!ObjectUtils.equal(this.range, meterPlot.range)) {
                return false;
            }
            if (!ObjectUtils.equal(this.normalRange, meterPlot.normalRange)) {
                return false;
            }
            if (!ObjectUtils.equal(this.warningRange, meterPlot.warningRange)) {
                return false;
            }
            if (!ObjectUtils.equal(this.criticalRange, meterPlot.criticalRange)) {
                return false;
            }
            if (!ObjectUtils.equal(this.dialOutlinePaint, meterPlot.dialOutlinePaint)) {
                return false;
            }
            if (!ObjectUtils.equal(this.normalPaint, meterPlot.normalPaint)) {
                return false;
            }
            if (!ObjectUtils.equal(this.warningPaint, meterPlot.warningPaint)) {
                return false;
            }
            if (!ObjectUtils.equal(this.criticalPaint, meterPlot.criticalPaint)) {
                return false;
            }
            if (this.shape != meterPlot.shape) {
                return false;
            }
            if (!ObjectUtils.equal(this.dialBackgroundPaint, meterPlot.dialBackgroundPaint)) {
                return false;
            }
            if (!ObjectUtils.equal(this.needlePaint, meterPlot.needlePaint)) {
                return false;
            }
            if (!ObjectUtils.equal(this.valueFont, meterPlot.valueFont)) {
                return false;
            }
            if (!ObjectUtils.equal(this.valuePaint, meterPlot.valuePaint)) {
                return false;
            }
            if (this.tickLabelType != meterPlot.tickLabelType) {
                return false;
            }
            if (!ObjectUtils.equal(this.tickLabelFont, meterPlot.tickLabelFont)) {
                return false;
            }
            if (!ObjectUtils.equal(this.tickLabelFormat, meterPlot.tickLabelFormat)) {
                return false;
            }
            if (this.drawBorder != meterPlot.drawBorder) {
                return false;
            }
            return this.meterAngle == meterPlot.meterAngle;
        }
        return false;
    }

    public int getDialType() {
        if (this.shape == DialShape.CIRCLE) {
            return 1;
        }
        if (this.shape == DialShape.CHORD) {
            return 2;
        }
        if (this.shape == DialShape.PIE) {
            return 0;
        }
        throw new IllegalStateException("MeterPlot.getDialType: unrecognised dial type.");
    }

    public void setDialType(int n) {
        switch (n) {
            case 1: {
                this.setDialShape(DialShape.CIRCLE);
                break;
            }
            case 2: {
                this.setDialShape(DialShape.CHORD);
                break;
            }
            case 0: {
                this.setDialShape(DialShape.PIE);
                break;
            }
            default: {
                throw new IllegalArgumentException("MeterPlot.setDialType: unrecognised type.");
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        MeterPlot meterPlot = (MeterPlot)super.clone();
        if (meterPlot.dataset != null) {
            meterPlot.dataset.addChangeListener(meterPlot);
        }
        return meterPlot;
    }
}

