/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.Serializable;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtils;
import org.jfree.util.UnitType;

public abstract class Marker
implements Serializable,
Cloneable {
    private transient Paint paint;
    private transient Stroke stroke;
    private transient Paint outlinePaint;
    private transient Stroke outlineStroke;
    private float alpha;
    private String label = null;
    private Font labelFont;
    private transient Paint labelPaint;
    private RectangleAnchor labelAnchor;
    private TextAnchor labelTextAnchor;
    private RectangleInsets labelOffset;

    protected Marker() {
        this(Color.gray);
    }

    protected Marker(Paint paint) {
        this(paint, new BasicStroke(0.5f), Color.gray, new BasicStroke(0.5f), 0.8f);
    }

    public Marker(Paint paint, Stroke stroke, Paint paint2, Stroke stroke2, float f) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.paint = paint;
        this.stroke = stroke;
        this.outlinePaint = paint2;
        this.outlineStroke = stroke2;
        this.alpha = f;
        this.labelFont = new Font("SansSerif", 0, 9);
        this.labelPaint = Color.black;
        this.labelAnchor = RectangleAnchor.TOP_LEFT;
        this.labelOffset = new RectangleInsets(UnitType.ABSOLUTE, 3.0, 3.0, 3.0, 3.0);
        this.labelTextAnchor = TextAnchor.CENTER;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.paint = paint;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.stroke = stroke;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.outlineStroke = stroke;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.labelFont = font;
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Marker.setLabelPaint(...): null not permitted.");
        }
        this.labelPaint = paint;
    }

    public RectangleAnchor getLabelAnchor() {
        return this.labelAnchor;
    }

    public void setLabelAnchor(RectangleAnchor rectangleAnchor) {
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.labelAnchor = rectangleAnchor;
    }

    public RectangleInsets getLabelOffset() {
        return this.labelOffset;
    }

    public void setLabelOffset(RectangleInsets rectangleInsets) {
        if (rectangleInsets == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.labelOffset = rectangleInsets;
    }

    public TextAnchor getLabelTextAnchor() {
        return this.labelTextAnchor;
    }

    public void setLabelTextAnchor(TextAnchor textAnchor) {
        if (textAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.labelTextAnchor = textAnchor;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Marker) {
            Marker marker = (Marker)object;
            if (!ObjectUtils.equal(this.paint, marker.paint)) {
                return false;
            }
            if (!ObjectUtils.equal(this.stroke, marker.stroke)) {
                return false;
            }
            if (!ObjectUtils.equal(this.outlinePaint, marker.outlinePaint)) {
                return false;
            }
            if (!ObjectUtils.equal(this.outlineStroke, marker.outlineStroke)) {
                return false;
            }
            if (this.alpha != marker.alpha) {
                return false;
            }
            if (!ObjectUtils.equal(this.label, marker.label)) {
                return false;
            }
            if (!ObjectUtils.equal(this.labelFont, marker.labelFont)) {
                return false;
            }
            if (!ObjectUtils.equal(this.labelPaint, marker.labelPaint)) {
                return false;
            }
            if (this.labelAnchor != marker.labelAnchor) {
                return false;
            }
            if (this.labelTextAnchor != marker.labelTextAnchor) {
                return false;
            }
            return ObjectUtils.equal(this.labelOffset, marker.labelOffset);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

