/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.Serializable;
import org.jfree.chart.plot.Marker;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.util.ObjectUtils;

public class IntervalMarker
extends Marker
implements Cloneable,
Serializable {
    private double startValue;
    private double endValue;
    private GradientPaintTransformer gradientPaintTransformer;

    public IntervalMarker(double d, double d2) {
        this(d, d2, Color.gray, new BasicStroke(0.5f), Color.blue, new BasicStroke(0.5f), 0.8f);
    }

    public IntervalMarker(double d, double d2, Paint paint, Stroke stroke, Paint paint2, Stroke stroke2, float f) {
        super(paint, stroke, paint2, stroke2, f);
        this.startValue = d;
        this.endValue = d2;
        this.gradientPaintTransformer = null;
    }

    public double getStartValue() {
        return this.startValue;
    }

    public double getEndValue() {
        return this.endValue;
    }

    public GradientPaintTransformer getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientPaintTransformer(GradientPaintTransformer gradientPaintTransformer) {
        this.gradientPaintTransformer = gradientPaintTransformer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IntervalMarker && super.equals(object)) {
            IntervalMarker intervalMarker = (IntervalMarker)object;
            if (intervalMarker.startValue != this.startValue) {
                return false;
            }
            if (intervalMarker.endValue != this.endValue) {
                return false;
            }
            return ObjectUtils.equal(intervalMarker.gradientPaintTransformer, this.gradientPaintTransformer);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

