/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ArrayUtils;
import org.jfree.util.ObjectUtils;

public class FastScatterPlot
extends Plot
implements ValueAxisPlot,
Cloneable,
Serializable {
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    private float[][] data;
    private Range xDataRange;
    private Range yDataRange;
    private ValueAxis domainAxis;
    private ValueAxis rangeAxis;
    private transient Paint paint;
    private boolean domainGridlinesVisible;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;

    public FastScatterPlot() {
        this(null, null, null);
    }

    public FastScatterPlot(float[][] fArray, ValueAxis valueAxis, ValueAxis valueAxis2) {
        this.data = fArray;
        this.xDataRange = this.calculateXDataRange(fArray);
        this.yDataRange = this.calculateYDataRange(fArray);
        this.domainAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.rangeAxis = valueAxis2;
        if (valueAxis2 != null) {
            valueAxis2.setPlot(this);
            valueAxis2.addChangeListener(this);
        }
        this.paint = Color.red;
        this.domainGridlinesVisible = true;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinesVisible = true;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
    }

    public String getPlotType() {
        return this.getClass().getName();
    }

    public ValueAxis getDomainAxis() {
        return this.domainAxis;
    }

    public ValueAxis getRangeAxis() {
        return this.rangeAxis;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean bl) {
        if (this.domainGridlinesVisible != bl) {
            this.domainGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        this.domainGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        this.domainGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean bl) {
        if (this.rangeGridlinesVisible != bl) {
            this.rangeGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        this.rangeGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        this.rangeGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Insets insets;
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.domainAxis.reserveSpace(graphics2D, this, rectangle2D, RectangleEdge.BOTTOM, axisSpace);
        axisSpace = this.rangeAxis.reserveSpace(graphics2D, this, rectangle2D, RectangleEdge.LEFT, axisSpace);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
        this.drawBackground(graphics2D, rectangle2D2);
        AxisState axisState = null;
        AxisState axisState2 = null;
        if (this.domainAxis != null) {
            axisState = this.domainAxis.draw(graphics2D, rectangle2D2.getMaxY(), rectangle2D, rectangle2D2, RectangleEdge.BOTTOM, plotRenderingInfo);
        }
        if (this.rangeAxis != null) {
            axisState2 = this.rangeAxis.draw(graphics2D, rectangle2D2.getMinX(), rectangle2D, rectangle2D2, RectangleEdge.LEFT, plotRenderingInfo);
        }
        this.drawDomainGridlines(graphics2D, rectangle2D2, axisState.getTicks());
        this.drawRangeGridlines(graphics2D, rectangle2D2, axisState2.getTicks());
        Shape shape = graphics2D.getClip();
        Composite composite = graphics2D.getComposite();
        graphics2D.clip(rectangle2D2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        this.render(graphics2D, rectangle2D2, plotRenderingInfo, null);
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D2);
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, CrosshairState crosshairState) {
        graphics2D.setPaint(Color.red);
        if (this.data != null) {
            int n = 0;
            while (n < this.data[0].length) {
                float f = this.data[0][n];
                float f2 = this.data[1][n];
                int n2 = (int)this.domainAxis.valueToJava2D(f, rectangle2D, RectangleEdge.BOTTOM);
                int n3 = (int)this.rangeAxis.valueToJava2D(f2, rectangle2D, RectangleEdge.LEFT);
                graphics2D.fillRect(n2, n3, 1, 1);
                ++n;
            }
        }
    }

    protected void drawDomainGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (this.isDomainGridlinesVisible()) {
            Stroke stroke = this.getDomainGridlineStroke();
            Paint paint = this.getDomainGridlinePaint();
            if (stroke != null && paint != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ValueTick valueTick = (ValueTick)iterator.next();
                    double d = this.domainAxis.valueToJava2D(valueTick.getValue(), rectangle2D, RectangleEdge.BOTTOM);
                    Line2D.Double double_ = new Line2D.Double(d, rectangle2D.getMinY(), d, rectangle2D.getMaxY());
                    graphics2D.setPaint(paint);
                    graphics2D.setStroke(stroke);
                    graphics2D.draw(double_);
                }
            }
        }
    }

    protected void drawRangeGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (this.isRangeGridlinesVisible()) {
            Stroke stroke = this.getRangeGridlineStroke();
            Paint paint = this.getRangeGridlinePaint();
            if (stroke != null && paint != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ValueTick valueTick = (ValueTick)iterator.next();
                    double d = this.rangeAxis.valueToJava2D(valueTick.getValue(), rectangle2D, RectangleEdge.LEFT);
                    Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d, rectangle2D.getMaxX(), d);
                    graphics2D.setPaint(paint);
                    graphics2D.setStroke(stroke);
                    graphics2D.draw(double_);
                }
            }
        }
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (valueAxis == this.domainAxis) {
            range = this.xDataRange;
        } else if (valueAxis == this.rangeAxis) {
            range = this.yDataRange;
        }
        return range;
    }

    private Range calculateXDataRange(float[][] fArray) {
        Range range = null;
        if (fArray != null) {
            float f = Float.POSITIVE_INFINITY;
            float f2 = Float.NEGATIVE_INFINITY;
            int n = 0;
            while (n < fArray[0].length) {
                float f3 = fArray[0][n];
                if (f3 < f) {
                    f = f3;
                }
                if (f3 > f2) {
                    f2 = f3;
                }
                ++n;
            }
            if (f <= f2) {
                range = new Range(f, f2);
            }
        }
        return range;
    }

    private Range calculateYDataRange(float[][] fArray) {
        Range range = null;
        if (fArray != null) {
            float f = Float.POSITIVE_INFINITY;
            float f2 = Float.NEGATIVE_INFINITY;
            int n = 0;
            while (n < fArray[0].length) {
                float f3 = fArray[1][n];
                if (f3 < f) {
                    f = f3;
                }
                if (f3 > f2) {
                    f2 = f3;
                }
                ++n;
            }
            if (f <= f2) {
                range = new Range(f, f2);
            }
        }
        return range;
    }

    public void zoomHorizontalAxes(double d) {
        this.domainAxis.resizeRange(d);
    }

    public void zoomHorizontalAxes(double d, double d2) {
        this.domainAxis.zoomRange(d, d2);
    }

    public void zoomVerticalAxes(double d) {
        this.rangeAxis.resizeRange(d);
    }

    public void zoomVerticalAxes(double d, double d2) {
        this.rangeAxis.zoomRange(d, d2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (super.equals(object) && object instanceof FastScatterPlot) {
            FastScatterPlot fastScatterPlot = (FastScatterPlot)object;
            boolean bl = ArrayUtils.equal(this.data, fastScatterPlot.data);
            boolean bl2 = ObjectUtils.equal(this.domainAxis, fastScatterPlot.domainAxis);
            boolean bl3 = ObjectUtils.equal(this.rangeAxis, fastScatterPlot.rangeAxis);
            boolean bl4 = ObjectUtils.equal(this.paint, fastScatterPlot.paint);
            boolean bl5 = this.domainGridlinesVisible == fastScatterPlot.domainGridlinesVisible;
            boolean bl6 = ObjectUtils.equal(this.domainGridlinePaint, fastScatterPlot.domainGridlinePaint);
            boolean bl7 = ObjectUtils.equal(this.domainGridlineStroke, fastScatterPlot.domainGridlineStroke);
            boolean bl8 = this.rangeGridlinesVisible == fastScatterPlot.rangeGridlinesVisible;
            boolean bl9 = ObjectUtils.equal(this.rangeGridlinePaint, fastScatterPlot.rangeGridlinePaint);
            boolean bl10 = ObjectUtils.equal(this.rangeGridlineStroke, fastScatterPlot.rangeGridlineStroke);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        FastScatterPlot fastScatterPlot = (FastScatterPlot)super.clone();
        if (this.data != null) {
            fastScatterPlot.data = ArrayUtils.clone(this.data);
        }
        if (this.domainAxis != null) {
            fastScatterPlot.domainAxis = (ValueAxis)this.domainAxis.clone();
            fastScatterPlot.domainAxis.setPlot(fastScatterPlot);
            fastScatterPlot.domainAxis.addChangeListener(fastScatterPlot);
        }
        if (this.rangeAxis != null) {
            fastScatterPlot.rangeAxis = (ValueAxis)this.rangeAxis.clone();
            fastScatterPlot.rangeAxis.setPlot(fastScatterPlot);
            fastScatterPlot.rangeAxis.addChangeListener(fastScatterPlot);
        }
        return fastScatterPlot;
    }
}

