/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public class CombinedRangeCategoryPlot
extends CategoryPlot
implements Cloneable,
PublicCloneable,
Serializable,
PlotChangeListener {
    private List subplots = new ArrayList();
    private int totalWeight = 0;
    private double gap = 5.0;
    private transient Rectangle2D[] subplotArea;

    public CombinedRangeCategoryPlot() {
        this(new NumberAxis());
    }

    public CombinedRangeCategoryPlot(ValueAxis valueAxis) {
        super(null, null, valueAxis, null);
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double d) {
        this.gap = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void add(CategoryPlot categoryPlot) {
        this.add(categoryPlot, 1);
    }

    public void add(CategoryPlot categoryPlot, int n) {
        if (categoryPlot == null) {
            throw new IllegalArgumentException("Null 'subplot' argument.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Require weight >= 1.");
        }
        categoryPlot.setParent(this);
        categoryPlot.setWeight(n);
        categoryPlot.setInsets(new Insets(0, 0, 0, 0));
        categoryPlot.setRangeAxis(null);
        categoryPlot.setOrientation(this.getOrientation());
        categoryPlot.addChangeListener(this);
        this.subplots.add(categoryPlot);
        this.totalWeight += n;
        ValueAxis valueAxis = this.getRangeAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void remove(CategoryPlot categoryPlot) {
        if (categoryPlot == null) {
            throw new IllegalArgumentException(" Null 'subplot' argument.");
        }
        int n = -1;
        int n2 = this.subplots.size();
        int n3 = 0;
        while (n == -1 && n3 < n2) {
            if (this.subplots.get(n3) == categoryPlot) {
                n = n3;
            }
            ++n3;
        }
        if (n != -1) {
            ValueAxis valueAxis;
            categoryPlot.setParent(null);
            categoryPlot.removeChangeListener(this);
            this.totalWeight -= categoryPlot.getWeight();
            ValueAxis valueAxis2 = this.getRangeAxis();
            if (valueAxis2 != null) {
                valueAxis2.configure();
            }
            if ((valueAxis = this.getRangeAxis(1)) != null) {
                valueAxis.configure();
            }
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public List getSubplots() {
        return Collections.unmodifiableList(this.subplots);
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Cloneable cloneable;
        AxisSpace axisSpace = new AxisSpace();
        PlotOrientation plotOrientation = this.getOrientation();
        AxisSpace axisSpace2 = this.getFixedRangeAxisSpace();
        if (axisSpace2 != null) {
            if (plotOrientation == PlotOrientation.VERTICAL) {
                axisSpace.setLeft(axisSpace2.getLeft());
                axisSpace.setRight(axisSpace2.getRight());
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                axisSpace.setTop(axisSpace2.getTop());
                axisSpace.setBottom(axisSpace2.getBottom());
            }
        } else {
            cloneable = this.getRangeAxis();
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), plotOrientation);
            if (cloneable != null) {
                axisSpace = ((ValueAxis)cloneable).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        cloneable = axisSpace.shrink(rectangle2D, null);
        int n = this.subplots.size();
        this.subplotArea = new Rectangle2D[n];
        double d = ((RectangularShape)cloneable).getX();
        double d2 = ((RectangularShape)cloneable).getY();
        double d3 = 0.0;
        if (plotOrientation == PlotOrientation.VERTICAL) {
            d3 = ((RectangularShape)cloneable).getWidth() - this.gap * (double)(n - 1);
        } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d3 = ((RectangularShape)cloneable).getHeight() - this.gap * (double)(n - 1);
        }
        int n2 = 0;
        while (n2 < n) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(n2);
            if (plotOrientation == PlotOrientation.VERTICAL) {
                double d4 = d3 * (double)categoryPlot.getWeight() / (double)this.totalWeight;
                this.subplotArea[n2] = new Rectangle2D.Double(d, d2, d4, ((RectangularShape)cloneable).getHeight());
                d = d + d4 + this.gap;
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double d5 = d3 * (double)categoryPlot.getWeight() / (double)this.totalWeight;
                this.subplotArea[n2] = new Rectangle2D.Double(d, d2, ((RectangularShape)cloneable).getWidth(), d5);
                d2 = d2 + d5 + this.gap;
            }
            AxisSpace axisSpace3 = categoryPlot.calculateDomainAxisSpace(graphics2D, this.subplotArea[n2], null);
            axisSpace.ensureAtLeast(axisSpace3);
            ++n2;
        }
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Insets insets;
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.setFixedDomainAxisSpaceForSubplots(axisSpace);
        ValueAxis valueAxis = this.getRangeAxis();
        RectangleEdge rectangleEdge = this.getRangeAxisEdge();
        double d = RectangleEdge.coordinate(rectangle2D2, rectangleEdge);
        AxisState axisState = valueAxis.draw(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge, plotRenderingInfo);
        if (plotState == null) {
            plotState = new PlotState();
        }
        plotState.getSharedAxisStates().put(valueAxis, axisState);
        int n = 0;
        while (n < this.subplots.size()) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(n);
            PlotRenderingInfo plotRenderingInfo2 = null;
            if (plotRenderingInfo != null) {
                plotRenderingInfo2 = new PlotRenderingInfo(plotRenderingInfo.getOwner());
                plotRenderingInfo.addSubplotInfo(plotRenderingInfo2);
            }
            categoryPlot.draw(graphics2D, this.subplotArea[n], plotState, plotRenderingInfo2);
            ++n;
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        super.setOrientation(plotOrientation);
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            CategoryPlot categoryPlot = (CategoryPlot)iterator.next();
            categoryPlot.setOrientation(plotOrientation);
        }
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                CategoryPlot categoryPlot = (CategoryPlot)iterator.next();
                range = Range.combine(range, categoryPlot.getDataRange(valueAxis));
            }
        }
        return range;
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                CategoryPlot categoryPlot = (CategoryPlot)iterator.next();
                LegendItemCollection legendItemCollection2 = categoryPlot.getLegendItems();
                legendItemCollection.addAll(legendItemCollection2);
            }
        }
        return legendItemCollection;
    }

    protected void setFixedDomainAxisSpaceForSubplots(AxisSpace axisSpace) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            CategoryPlot categoryPlot = (CategoryPlot)iterator.next();
            categoryPlot.setFixedDomainAxisSpace(axisSpace);
        }
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            int n3 = 0;
            while (n3 < this.subplots.size()) {
                CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(n3);
                PlotRenderingInfo plotRenderingInfo2 = plotRenderingInfo.getSubplotInfo(n3);
                categoryPlot.handleClick(n, n2, plotRenderingInfo2);
                ++n3;
            }
        }
    }

    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        this.notifyListeners(plotChangeEvent);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CombinedRangeCategoryPlot) {
            CombinedRangeCategoryPlot combinedRangeCategoryPlot = (CombinedRangeCategoryPlot)object;
            if (super.equals(object)) {
                boolean bl;
                boolean bl2 = ObjectUtils.equal(this.subplots, combinedRangeCategoryPlot.subplots);
                boolean bl3 = this.totalWeight == combinedRangeCategoryPlot.totalWeight;
                boolean bl4 = bl = this.gap == combinedRangeCategoryPlot.gap;
                return bl2 && bl3 && bl;
            }
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        CombinedRangeCategoryPlot combinedRangeCategoryPlot = (CombinedRangeCategoryPlot)super.clone();
        combinedRangeCategoryPlot.subplots = ObjectUtils.clone(this.subplots);
        Object object = combinedRangeCategoryPlot.subplots.iterator();
        while (object.hasNext()) {
            Plot plot = (Plot)object.next();
            plot.setParent(combinedRangeCategoryPlot);
        }
        object = combinedRangeCategoryPlot.getRangeAxis();
        if (object != null) {
            ((Axis)object).configure();
        }
        return combinedRangeCategoryPlot;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        ValueAxis valueAxis = this.getRangeAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
    }
}

