/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public class CombinedDomainCategoryPlot
extends CategoryPlot
implements Cloneable,
PublicCloneable,
Serializable,
PlotChangeListener {
    private List subplots = new ArrayList();
    private int totalWeight = 0;
    private double gap = 5.0;
    private transient Rectangle2D[] subplotAreas;

    public CombinedDomainCategoryPlot() {
        this(new CategoryAxis());
    }

    public CombinedDomainCategoryPlot(CategoryAxis categoryAxis) {
        super(null, categoryAxis, null, null);
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double d) {
        this.gap = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void add(CategoryPlot categoryPlot) {
        this.add(categoryPlot, 1);
    }

    public void add(CategoryPlot categoryPlot, int n) {
        if (categoryPlot == null) {
            throw new IllegalArgumentException("Null 'subplot' argument.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Require weight >= 1.");
        }
        categoryPlot.setParent(this);
        categoryPlot.setWeight(n);
        categoryPlot.setInsets(new Insets(0, 0, 0, 0));
        categoryPlot.setDomainAxis(null);
        categoryPlot.setOrientation(this.getOrientation());
        categoryPlot.addChangeListener(this);
        this.subplots.add(categoryPlot);
        this.totalWeight += n;
        CategoryAxis categoryAxis = this.getDomainAxis();
        if (categoryAxis != null) {
            categoryAxis.configure();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void remove(CategoryPlot categoryPlot) {
        if (categoryPlot == null) {
            throw new IllegalArgumentException("Null 'subplot' argument.");
        }
        int n = -1;
        int n2 = this.subplots.size();
        int n3 = 0;
        while (n == -1 && n3 < n2) {
            if (this.subplots.get(n3) == categoryPlot) {
                n = n3;
            }
            ++n3;
        }
        if (n != -1) {
            this.subplots.remove(n);
            categoryPlot.setParent(null);
            categoryPlot.removeChangeListener(this);
            this.totalWeight -= categoryPlot.getWeight();
            CategoryAxis categoryAxis = this.getDomainAxis();
            if (categoryAxis != null) {
                categoryAxis.configure();
            }
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public List getSubplots() {
        return Collections.unmodifiableList(this.subplots);
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Cloneable cloneable;
        AxisSpace axisSpace = new AxisSpace();
        PlotOrientation plotOrientation = this.getOrientation();
        AxisSpace axisSpace2 = this.getFixedDomainAxisSpace();
        if (axisSpace2 != null) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                axisSpace.setLeft(axisSpace2.getLeft());
                axisSpace.setRight(axisSpace2.getRight());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                axisSpace.setTop(axisSpace2.getTop());
                axisSpace.setBottom(axisSpace2.getBottom());
            }
        } else {
            cloneable = this.getDomainAxis();
            RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), plotOrientation);
            if (cloneable != null) {
                axisSpace = ((CategoryAxis)cloneable).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            } else if (this.getDrawSharedDomainAxis()) {
                axisSpace = this.getDomainAxis().reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        cloneable = axisSpace.shrink(rectangle2D, null);
        int n = this.subplots.size();
        this.subplotAreas = new Rectangle2D[n];
        double d = ((RectangularShape)cloneable).getX();
        double d2 = ((RectangularShape)cloneable).getY();
        double d3 = 0.0;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d3 = ((RectangularShape)cloneable).getWidth() - this.gap * (double)(n - 1);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d3 = ((RectangularShape)cloneable).getHeight() - this.gap * (double)(n - 1);
        }
        int n2 = 0;
        while (n2 < n) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(n2);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double d4 = d3 * (double)categoryPlot.getWeight() / (double)this.totalWeight;
                this.subplotAreas[n2] = new Rectangle2D.Double(d, d2, d4, ((RectangularShape)cloneable).getHeight());
                d = d + d4 + this.gap;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double d5 = d3 * (double)categoryPlot.getWeight() / (double)this.totalWeight;
                this.subplotAreas[n2] = new Rectangle2D.Double(d, d2, ((RectangularShape)cloneable).getWidth(), d5);
                d2 = d2 + d5 + this.gap;
            }
            AxisSpace axisSpace3 = categoryPlot.calculateRangeAxisSpace(graphics2D, this.subplotAreas[n2], null);
            axisSpace.ensureAtLeast(axisSpace3);
            ++n2;
        }
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Insets insets;
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        this.setFixedRangeAxisSpaceForSubplots(null);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.setFixedRangeAxisSpaceForSubplots(axisSpace);
        CategoryAxis categoryAxis = this.getDomainAxis();
        RectangleEdge rectangleEdge = this.getDomainAxisEdge();
        double d = RectangleEdge.coordinate(rectangle2D2, rectangleEdge);
        AxisState axisState = categoryAxis.draw(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge, plotRenderingInfo);
        if (plotState == null) {
            plotState = new PlotState();
        }
        plotState.getSharedAxisStates().put(categoryAxis, axisState);
        int n = 0;
        while (n < this.subplots.size()) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(n);
            PlotRenderingInfo plotRenderingInfo2 = null;
            if (plotRenderingInfo != null) {
                plotRenderingInfo2 = new PlotRenderingInfo(plotRenderingInfo.getOwner());
                plotRenderingInfo.addSubplotInfo(plotRenderingInfo2);
            }
            categoryPlot.draw(graphics2D, this.subplotAreas[n], plotState, plotRenderingInfo2);
            ++n;
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
    }

    protected void setFixedRangeAxisSpaceForSubplots(AxisSpace axisSpace) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            CategoryPlot categoryPlot = (CategoryPlot)iterator.next();
            categoryPlot.setFixedRangeAxisSpace(axisSpace);
        }
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        super.setOrientation(plotOrientation);
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            CategoryPlot categoryPlot = (CategoryPlot)iterator.next();
            categoryPlot.setOrientation(plotOrientation);
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                CategoryPlot categoryPlot = (CategoryPlot)iterator.next();
                LegendItemCollection legendItemCollection2 = categoryPlot.getLegendItems();
                legendItemCollection.addAll(legendItemCollection2);
            }
        }
        return legendItemCollection;
    }

    public List getCategories() {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                CategoryPlot categoryPlot = (CategoryPlot)iterator.next();
                List list = categoryPlot.getCategories();
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    Comparable comparable = (Comparable)iterator2.next();
                    if (arrayList.contains(comparable)) continue;
                    arrayList.add(comparable);
                }
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            int n3 = 0;
            while (n3 < this.subplots.size()) {
                CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(n3);
                PlotRenderingInfo plotRenderingInfo2 = plotRenderingInfo.getSubplotInfo(n3);
                categoryPlot.handleClick(n, n2, plotRenderingInfo2);
                ++n3;
            }
        }
    }

    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        this.notifyListeners(plotChangeEvent);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CombinedDomainCategoryPlot) {
            CombinedDomainCategoryPlot combinedDomainCategoryPlot = (CombinedDomainCategoryPlot)object;
            if (super.equals(object)) {
                boolean bl;
                boolean bl2 = ObjectUtils.equal(this.subplots, combinedDomainCategoryPlot.subplots);
                boolean bl3 = this.totalWeight == combinedDomainCategoryPlot.totalWeight;
                boolean bl4 = bl = this.gap == combinedDomainCategoryPlot.gap;
                return bl2 && bl3 && bl;
            }
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        CombinedDomainCategoryPlot combinedDomainCategoryPlot = (CombinedDomainCategoryPlot)super.clone();
        combinedDomainCategoryPlot.subplots = ObjectUtils.clone(this.subplots);
        Iterator iterator = combinedDomainCategoryPlot.subplots.iterator();
        while (iterator.hasNext()) {
            Plot plot = (Plot)iterator.next();
            plot.setParent(combinedDomainCategoryPlot);
        }
        return combinedDomainCategoryPlot;
    }
}

