/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisCollection;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Spacer;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;
import org.jfree.util.SortOrder;

public class CategoryPlot
extends Plot
implements ValueAxisPlot,
RendererChangeListener,
Cloneable,
PublicCloneable,
Serializable {
    public static final boolean DEFAULT_DOMAIN_GRIDLINES_VISIBLE = false;
    public static final boolean DEFAULT_RANGE_GRIDLINES_VISIBLE = true;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final Font DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
    private PlotOrientation orientation;
    private Spacer axisOffset;
    private ObjectList domainAxes;
    private ObjectList domainAxisLocations;
    private boolean drawSharedDomainAxis;
    private ObjectList rangeAxes;
    private ObjectList rangeAxisLocations;
    private ObjectList datasets;
    private ObjectList datasetToDomainAxisMap;
    private ObjectList datasetToRangeAxisMap;
    private ObjectList renderers;
    private DatasetRenderingOrder renderingOrder = DatasetRenderingOrder.REVERSE;
    private SortOrder columnRenderingOrder = SortOrder.ASCENDING;
    private SortOrder rowRenderingOrder = SortOrder.ASCENDING;
    private boolean domainGridlinesVisible;
    private CategoryAnchor domainGridlinePosition;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private double anchorValue;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private transient Map foregroundRangeMarkers;
    private transient Map backgroundRangeMarkers;
    private transient List annotations;
    private int weight;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;
    private LegendItemCollection fixedLegendItems;

    public CategoryPlot() {
        this(null, null, null, null);
    }

    public CategoryPlot(CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer) {
        this.orientation = PlotOrientation.VERTICAL;
        this.domainAxes = new ObjectList();
        this.domainAxisLocations = new ObjectList();
        this.rangeAxes = new ObjectList();
        this.rangeAxisLocations = new ObjectList();
        this.datasetToDomainAxisMap = new ObjectList();
        this.datasetToRangeAxisMap = new ObjectList();
        this.renderers = new ObjectList();
        this.datasets = new ObjectList();
        this.datasets.set(0, categoryDataset);
        if (categoryDataset != null) {
            categoryDataset.addChangeListener(this);
        }
        this.axisOffset = new Spacer(1, 0.0, 0.0, 0.0, 0.0);
        this.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT, false);
        this.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT, false);
        this.renderers.set(0, categoryItemRenderer);
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
            categoryItemRenderer.addChangeListener(this);
        }
        this.domainAxes.set(0, categoryAxis);
        this.mapDatasetToDomainAxis(0, 0);
        if (categoryAxis != null) {
            categoryAxis.setPlot(this);
            categoryAxis.addChangeListener(this);
        }
        this.drawSharedDomainAxis = false;
        this.rangeAxes.set(0, valueAxis);
        this.mapDatasetToRangeAxis(0, 0);
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
        this.domainGridlinesVisible = false;
        this.domainGridlinePosition = CategoryAnchor.MIDDLE;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.foregroundRangeMarkers = new HashMap();
        this.backgroundRangeMarkers = new HashMap();
        ValueMarker valueMarker = new ValueMarker(0.0, new Color(0.8f, 0.8f, 0.8f, 0.5f), new BasicStroke(1.0f), new Color(0.85f, 0.85f, 0.95f, 0.5f), new BasicStroke(1.0f), 0.6f);
        this.addRangeMarker(valueMarker, Layer.BACKGROUND);
        this.anchorValue = 0.0;
    }

    public String getPlotType() {
        return this.getClass().getName();
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        this.orientation = plotOrientation;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Spacer getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(Spacer spacer) {
        this.axisOffset = spacer;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public CategoryAxis getDomainAxis() {
        return this.getDomainAxis(0);
    }

    public CategoryAxis getDomainAxis(int n) {
        Plot plot;
        CategoryAxis categoryAxis = null;
        if (n < this.domainAxes.size()) {
            categoryAxis = (CategoryAxis)this.domainAxes.get(n);
        }
        if (categoryAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            categoryAxis = categoryPlot.getDomainAxis(n);
        }
        return categoryAxis;
    }

    public void setDomainAxis(CategoryAxis categoryAxis) {
        this.setDomainAxis(0, categoryAxis);
    }

    public void setDomainAxis(int n, CategoryAxis categoryAxis) {
        CategoryAxis categoryAxis2 = (CategoryAxis)this.domainAxes.get(n);
        if (categoryAxis2 != null) {
            categoryAxis2.removeChangeListener(this);
        }
        if (categoryAxis != null) {
            categoryAxis.setPlot(this);
        }
        this.domainAxes.set(n, categoryAxis);
        if (categoryAxis != null) {
            categoryAxis.configure();
            categoryAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getDomainAxisLocation() {
        return this.getDomainAxisLocation(0);
    }

    public AxisLocation getDomainAxisLocation(int n) {
        AxisLocation axisLocation = null;
        if (n < this.domainAxisLocations.size()) {
            axisLocation = (AxisLocation)this.domainAxisLocations.get(n);
        }
        if (axisLocation == null) {
            axisLocation = AxisLocation.getOpposite(this.getDomainAxisLocation(0));
        }
        return axisLocation;
    }

    public void setDomainAxisLocation(AxisLocation axisLocation) {
        this.setDomainAxisLocation(axisLocation, true);
    }

    public void setDomainAxisLocation(AxisLocation axisLocation, boolean bl) {
        if (axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        this.setDomainAxisLocation(0, axisLocation);
    }

    public void setDomainAxisLocation(int n, AxisLocation axisLocation) {
        this.domainAxisLocations.set(n, axisLocation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public RectangleEdge getDomainAxisEdge() {
        return this.getDomainAxisEdge(0);
    }

    public RectangleEdge getDomainAxisEdge(int n) {
        RectangleEdge rectangleEdge = null;
        AxisLocation axisLocation = this.getDomainAxisLocation(n);
        rectangleEdge = axisLocation != null ? Plot.resolveDomainAxisLocation(axisLocation, this.orientation) : RectangleEdge.opposite(this.getDomainAxisEdge(0));
        return rectangleEdge;
    }

    public void clearDomainAxes() {
        int n = 0;
        while (n < this.domainAxes.size()) {
            CategoryAxis categoryAxis = (CategoryAxis)this.domainAxes.get(n);
            if (categoryAxis != null) {
                categoryAxis.removeChangeListener(this);
            }
            ++n;
        }
        this.domainAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureDomainAxes() {
        int n = 0;
        while (n < this.domainAxes.size()) {
            CategoryAxis categoryAxis = (CategoryAxis)this.domainAxes.get(n);
            if (categoryAxis != null) {
                categoryAxis.configure();
            }
            ++n;
        }
    }

    public ValueAxis getRangeAxis() {
        return this.getRangeAxis(0);
    }

    public ValueAxis getRangeAxis(int n) {
        Plot plot;
        ValueAxis valueAxis = null;
        if (n < this.rangeAxes.size()) {
            valueAxis = (ValueAxis)this.rangeAxes.get(n);
        }
        if (valueAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            valueAxis = categoryPlot.getRangeAxis(n);
        }
        return valueAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) {
        this.setRangeAxis(0, valueAxis);
    }

    public void setRangeAxis(int n, ValueAxis valueAxis) {
        ValueAxis valueAxis2 = (ValueAxis)this.rangeAxes.get(n);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        this.rangeAxes.set(n, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getRangeAxisLocation() {
        return this.getRangeAxisLocation(0);
    }

    public AxisLocation getRangeAxisLocation(int n) {
        AxisLocation axisLocation = null;
        if (n < this.rangeAxisLocations.size()) {
            axisLocation = (AxisLocation)this.rangeAxisLocations.get(n);
        }
        if (axisLocation == null) {
            axisLocation = AxisLocation.getOpposite(this.getRangeAxisLocation(0));
        }
        return axisLocation;
    }

    public void setRangeAxisLocation(AxisLocation axisLocation) {
        this.setRangeAxisLocation(axisLocation, true);
    }

    public void setRangeAxisLocation(AxisLocation axisLocation, boolean bl) {
        this.setRangeAxisLocation(0, axisLocation, bl);
    }

    public void setRangeAxisLocation(int n, AxisLocation axisLocation) {
        this.setRangeAxisLocation(n, axisLocation, true);
    }

    public void setRangeAxisLocation(int n, AxisLocation axisLocation, boolean bl) {
        this.rangeAxisLocations.set(n, axisLocation);
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public RectangleEdge getRangeAxisEdge() {
        return this.getRangeAxisEdge(0);
    }

    public RectangleEdge getRangeAxisEdge(int n) {
        AxisLocation axisLocation = this.getRangeAxisLocation(n);
        RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(axisLocation, this.orientation);
        if (rectangleEdge == null) {
            rectangleEdge = RectangleEdge.opposite(this.getRangeAxisEdge(0));
        }
        return rectangleEdge;
    }

    public void clearRangeAxes() {
        int n = 0;
        while (n < this.rangeAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(n);
            if (valueAxis != null) {
                valueAxis.removeChangeListener(this);
            }
            ++n;
        }
        this.rangeAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureRangeAxes() {
        int n = 0;
        while (n < this.rangeAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(n);
            if (valueAxis != null) {
                valueAxis.configure();
            }
            ++n;
        }
    }

    public CategoryDataset getDataset() {
        return this.getDataset(0);
    }

    public CategoryDataset getDataset(int n) {
        CategoryDataset categoryDataset = null;
        if (this.datasets.size() > n) {
            categoryDataset = (CategoryDataset)this.datasets.get(n);
        }
        return categoryDataset;
    }

    public void setDataset(CategoryDataset categoryDataset) {
        this.setDataset(0, categoryDataset);
    }

    public void setDataset(int n, CategoryDataset categoryDataset) {
        CategoryDataset categoryDataset2 = (CategoryDataset)this.datasets.get(n);
        if (categoryDataset2 != null) {
            categoryDataset2.removeChangeListener(this);
        }
        this.datasets.set(n, categoryDataset);
        if (categoryDataset != null) {
            categoryDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, categoryDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public void mapDatasetToDomainAxis(int n, int n2) {
        this.datasetToDomainAxisMap.set(n, new Integer(n2));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n)));
    }

    public CategoryAxis getDomainAxisForDataset(int n) {
        CategoryAxis categoryAxis = this.getDomainAxis();
        Integer n2 = (Integer)this.datasetToDomainAxisMap.get(n);
        if (n2 != null) {
            categoryAxis = this.getDomainAxis(n2);
        }
        return categoryAxis;
    }

    public void mapDatasetToRangeAxis(int n, int n2) {
        this.datasetToRangeAxisMap.set(n, new Integer(n2));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n)));
    }

    public ValueAxis getRangeAxisForDataset(int n) {
        ValueAxis valueAxis = this.getRangeAxis();
        Integer n2 = (Integer)this.datasetToRangeAxisMap.get(n);
        if (n2 != null) {
            valueAxis = this.getRangeAxis(n2);
        }
        return valueAxis;
    }

    public CategoryItemRenderer getRenderer() {
        return this.getRenderer(0);
    }

    public CategoryItemRenderer getRenderer(int n) {
        CategoryItemRenderer categoryItemRenderer = null;
        if (this.renderers.size() > n) {
            categoryItemRenderer = (CategoryItemRenderer)this.renderers.get(n);
        }
        return categoryItemRenderer;
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer) {
        this.setRenderer(0, categoryItemRenderer, true);
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer, boolean bl) {
        this.setRenderer(0, categoryItemRenderer, bl);
    }

    public void setRenderer(int n, CategoryItemRenderer categoryItemRenderer) {
        this.setRenderer(n, categoryItemRenderer, true);
    }

    public void setRenderer(int n, CategoryItemRenderer categoryItemRenderer, boolean bl) {
        CategoryItemRenderer categoryItemRenderer2 = (CategoryItemRenderer)this.renderers.get(n);
        if (categoryItemRenderer2 != null) {
            categoryItemRenderer2.removeChangeListener(this);
        }
        this.renderers.set(n, categoryItemRenderer);
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
            categoryItemRenderer.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public CategoryItemRenderer getRendererForDataset(CategoryDataset categoryDataset) {
        CategoryItemRenderer categoryItemRenderer = null;
        int n = 0;
        while (n < this.datasets.size()) {
            if (this.datasets.get(n) == categoryDataset) {
                categoryItemRenderer = (CategoryItemRenderer)this.renderers.get(n);
                break;
            }
            ++n;
        }
        return categoryItemRenderer;
    }

    public DatasetRenderingOrder getDatasetRenderingOrder() {
        return this.renderingOrder;
    }

    public void setDatasetRenderingOrder(DatasetRenderingOrder datasetRenderingOrder) {
        if (datasetRenderingOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.renderingOrder = datasetRenderingOrder;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public SortOrder getColumnRenderingOrder() {
        return this.columnRenderingOrder;
    }

    public void setColumnRenderingOrder(SortOrder sortOrder) {
        this.columnRenderingOrder = sortOrder;
    }

    public SortOrder getRowRenderingOrder() {
        return this.rowRenderingOrder;
    }

    public void setRowRenderingOrder(SortOrder sortOrder) {
        if (sortOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.rowRenderingOrder = sortOrder;
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean bl) {
        if (this.domainGridlinesVisible != bl) {
            this.domainGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public CategoryAnchor getDomainGridlinePosition() {
        return this.domainGridlinePosition;
    }

    public void setDomainGridlinePosition(CategoryAnchor categoryAnchor) {
        this.domainGridlinePosition = categoryAnchor;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        this.domainGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        this.domainGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean bl) {
        if (this.rangeGridlinesVisible != bl) {
            this.rangeGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        this.rangeGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        this.rangeGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public LegendItemCollection getFixedLegendItems() {
        return this.fixedLegendItems;
    }

    public void setFixedLegendItems(LegendItemCollection legendItemCollection) {
        this.fixedLegendItems = legendItemCollection;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = this.fixedLegendItems;
        if (legendItemCollection == null) {
            legendItemCollection = new LegendItemCollection();
            int n = this.datasets.size();
            int n2 = 0;
            while (n2 < n) {
                CategoryItemRenderer categoryItemRenderer;
                CategoryDataset categoryDataset = this.getDataset(n2);
                if (categoryDataset != null && (categoryItemRenderer = this.getRenderer(n2)) != null) {
                    int n3 = categoryDataset.getRowCount();
                    int n4 = 0;
                    while (n4 < n3) {
                        LegendItem legendItem = categoryItemRenderer.getLegendItem(n2, n4);
                        if (legendItem != null) {
                            legendItemCollection.add(legendItem);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return legendItemCollection;
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            double d = 0.0;
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                d = n;
            } else if (this.orientation == PlotOrientation.VERTICAL) {
                d = n2;
            }
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), this.orientation);
            double d2 = this.getRangeAxis().java2DToValue(d, plotRenderingInfo.getDataArea(), rectangleEdge);
            this.setAnchorValue(d2);
            this.setRangeCrosshairValue(d2);
        }
    }

    public void zoom(double d) {
        if (d > 0.0) {
            double d2 = this.getRangeAxis().getRange().getLength();
            double d3 = d2 * d;
            this.getRangeAxis().setRange(this.anchorValue - d3 / 2.0, this.anchorValue + d3 / 2.0);
        } else {
            this.getRangeAxis().setAutoRange(true);
        }
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        int n = this.rangeAxes.size();
        int n2 = 0;
        while (n2 < n) {
            ValueAxis valueAxis = this.getRangeAxis(n2);
            if (valueAxis != null) {
                valueAxis.configure();
            }
            ++n2;
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(datasetChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rendererChanged(RendererChangeEvent rendererChangeEvent) {
        Plot plot = this.getParent();
        if (plot != null) {
            if (!(plot instanceof RendererChangeListener)) throw new RuntimeException("The renderer has changed and I don't know what to do!");
            RendererChangeListener rendererChangeListener = (RendererChangeListener)((Object)plot);
            rendererChangeListener.rendererChanged(rendererChangeEvent);
            return;
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    public void addRangeMarker(Marker marker) {
        this.addRangeMarker(marker, Layer.FOREGROUND);
    }

    public void addRangeMarker(Marker marker, Layer layer) {
        this.addRangeMarker(0, marker, layer);
    }

    public void addRangeMarker(int n, Marker marker, Layer layer) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.foregroundRangeMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.foregroundRangeMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.backgroundRangeMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.backgroundRangeMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearRangeMarkers() {
        if (this.backgroundRangeMarkers != null) {
            this.backgroundRangeMarkers.clear();
        }
        if (this.foregroundRangeMarkers != null) {
            this.foregroundRangeMarkers.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Collection getRangeMarkers(Layer layer) {
        return this.getRangeMarkers(0, layer);
    }

    public Collection getRangeMarkers(int n, Layer layer) {
        Collection collection = null;
        Integer n2 = new Integer(n);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.foregroundRangeMarkers.get(n2);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.backgroundRangeMarkers.get(n2);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    public void clearRangeMarkers(int n) {
        Collection collection;
        Integer n2 = new Integer(n);
        if (this.backgroundRangeMarkers != null && (collection = (Collection)this.backgroundRangeMarkers.get(n2)) != null) {
            collection.clear();
        }
        if (this.foregroundRangeMarkers != null && (collection = (Collection)this.foregroundRangeMarkers.get(n2)) != null) {
            collection.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean bl) {
        if (this.rangeCrosshairVisible != bl) {
            this.rangeCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean bl) {
        if (this.rangeCrosshairLockedOnData != bl) {
            this.rangeCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double d) {
        this.setRangeCrosshairValue(d, true);
    }

    public void setRangeCrosshairValue(double d, boolean bl) {
        this.rangeCrosshairValue = d;
        if (this.isRangeCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        this.rangeCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        this.rangeCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public List getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(CategoryAnnotation categoryAnnotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(categoryAnnotation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    protected AxisSpace calculateDomainAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block6: {
            block4: {
                block5: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block4;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block5;
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block6;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block6;
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block6;
            }
            RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), this.orientation);
            if (this.drawSharedDomainAxis) {
                axisSpace = this.getDomainAxis().reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
            int n = 0;
            while (n < this.domainAxes.size()) {
                Axis axis = (Axis)this.domainAxes.get(n);
                if (axis != null) {
                    RectangleEdge rectangleEdge2 = this.getDomainAxisEdge(n);
                    axisSpace = axis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge2, axisSpace);
                }
                ++n;
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateRangeAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block5: {
            block3: {
                block4: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block3;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block4;
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block5;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block5;
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block5;
            }
            int n = 0;
            while (n < this.rangeAxes.size()) {
                Axis axis = (Axis)this.rangeAxes.get(n);
                if (axis != null) {
                    RectangleEdge rectangleEdge = this.getRangeAxisEdge(n);
                    axisSpace = axis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
                }
                ++n;
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.calculateRangeAxisSpace(graphics2D, rectangle2D, axisSpace);
        axisSpace = this.calculateDomainAxisSpace(graphics2D, rectangle2D, axisSpace);
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        int n;
        Insets insets;
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.axisOffset.trim(rectangle2D2);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
        if (this.getRenderer() != null) {
            this.getRenderer().drawBackground(graphics2D, this, rectangle2D2);
        } else {
            this.drawBackground(graphics2D, rectangle2D2);
        }
        Map map = this.drawAxes(graphics2D, rectangle2D, rectangle2D2, plotRenderingInfo);
        this.drawDomainGridlines(graphics2D, rectangle2D2);
        AxisState axisState = (AxisState)map.get(this.getRangeAxis());
        if (axisState == null && plotState != null) {
            axisState = (AxisState)plotState.getSharedAxisStates().get(this.getRangeAxis());
        }
        if (axisState != null) {
            this.drawRangeGridlines(graphics2D, rectangle2D2, axisState.getTicks());
        }
        int n2 = 0;
        while (n2 < this.renderers.size()) {
            this.drawRangeMarkers(graphics2D, rectangle2D2, n2, Layer.BACKGROUND);
            ++n2;
        }
        this.drawRangeMarkers(graphics2D, rectangle2D2, Layer.BACKGROUND);
        n2 = 0;
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D2);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        DatasetRenderingOrder datasetRenderingOrder = this.getDatasetRenderingOrder();
        if (datasetRenderingOrder == DatasetRenderingOrder.FORWARD) {
            n = 0;
            while (n < this.datasets.size()) {
                n2 = !this.render(graphics2D, rectangle2D2, n, plotRenderingInfo) && n2 == 0 ? 0 : 1;
                ++n;
            }
        } else {
            n = this.datasets.size() - 1;
            while (n >= 0) {
                n2 = !this.render(graphics2D, rectangle2D2, n, plotRenderingInfo) && n2 == 0 ? 0 : 1;
                --n;
            }
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        if (n2 == 0) {
            this.drawNoDataMessage(graphics2D, rectangle2D2);
        }
        if (this.isRangeCrosshairVisible()) {
            this.drawRangeLine(graphics2D, rectangle2D2, this.getRangeCrosshairValue(), this.getRangeCrosshairStroke(), this.getRangeCrosshairPaint());
        }
        n = 0;
        while (n < this.renderers.size()) {
            this.drawRangeMarkers(graphics2D, rectangle2D2, n, Layer.FOREGROUND);
            ++n;
        }
        this.drawRangeMarkers(graphics2D, rectangle2D2, Layer.FOREGROUND);
        this.drawAnnotations(graphics2D, rectangle2D2);
        if (this.getRenderer() != null) {
            this.getRenderer().drawOutline(graphics2D, this, rectangle2D2);
        } else {
            this.drawOutline(graphics2D, rectangle2D2);
        }
    }

    protected Map drawAxes(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState;
        Axis axis;
        Axis axis2;
        AxisCollection axisCollection = new AxisCollection();
        int n = 0;
        while (n < this.domainAxes.size()) {
            axis2 = (CategoryAxis)this.domainAxes.get(n);
            if (axis2 != null) {
                axisCollection.add(axis2, this.getDomainAxisEdge(n));
            }
            ++n;
        }
        n = 0;
        while (n < this.rangeAxes.size()) {
            axis2 = (ValueAxis)this.rangeAxes.get(n);
            if (axis2 != null) {
                axisCollection.add(axis2, this.getRangeAxisEdge(n));
            }
            ++n;
        }
        HashMap<Axis, AxisState> hashMap = new HashMap<Axis, AxisState>();
        double d = rectangle2D2.getMinY() - this.axisOffset.getTopSpace(rectangle2D2.getHeight());
        Iterator iterator = axisCollection.getAxesAtTop().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.TOP, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        d = rectangle2D2.getMaxY() + this.axisOffset.getBottomSpace(rectangle2D2.getHeight());
        iterator = axisCollection.getAxesAtBottom().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.BOTTOM, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        d = rectangle2D2.getMinX() - this.axisOffset.getLeftSpace(rectangle2D2.getWidth());
        iterator = axisCollection.getAxesAtLeft().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.LEFT, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        d = rectangle2D2.getMaxX() + this.axisOffset.getRightSpace(rectangle2D2.getWidth());
        iterator = axisCollection.getAxesAtRight().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.RIGHT, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        return hashMap;
    }

    public boolean render(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, PlotRenderingInfo plotRenderingInfo) {
        boolean bl;
        block12: {
            bl = false;
            CategoryDataset categoryDataset = this.getDataset(n);
            CategoryItemRenderer categoryItemRenderer = this.getRenderer(n);
            CategoryAxis categoryAxis = this.getDomainAxisForDataset(n);
            ValueAxis valueAxis = this.getRangeAxisForDataset(n);
            if (DatasetUtilities.isEmptyOrNull(categoryDataset) || categoryItemRenderer == null) break block12;
            bl = true;
            CategoryItemRendererState categoryItemRendererState = categoryItemRenderer.initialise(graphics2D, rectangle2D, this, n, plotRenderingInfo);
            int n2 = categoryDataset.getColumnCount();
            int n3 = categoryDataset.getRowCount();
            if (this.columnRenderingOrder == SortOrder.ASCENDING) {
                int n4 = 0;
                while (n4 < n2) {
                    int n5;
                    if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                        n5 = 0;
                        while (n5 < n3) {
                            categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n5, n4);
                            ++n5;
                        }
                    } else {
                        n5 = n3 - 1;
                        while (n5 >= 0) {
                            categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n5, n4);
                            --n5;
                        }
                    }
                    ++n4;
                }
            } else {
                int n6 = n2 - 1;
                while (n6 >= 0) {
                    int n7;
                    if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                        n7 = 0;
                        while (n7 < n3) {
                            categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n7, n6);
                            ++n7;
                        }
                    } else {
                        n7 = n3 - 1;
                        while (n7 >= 0) {
                            categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n7, n6);
                            --n7;
                        }
                    }
                    --n6;
                }
            }
        }
        return bl;
    }

    protected void drawDomainGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.isDomainGridlinesVisible()) {
            CategoryAxis categoryAxis;
            CategoryDataset categoryDataset;
            CategoryAnchor categoryAnchor = this.getDomainGridlinePosition();
            RectangleEdge rectangleEdge = this.getDomainAxisEdge();
            Stroke stroke = this.getDomainGridlineStroke();
            Paint paint = this.getDomainGridlinePaint();
            if (stroke != null && paint != null && (categoryDataset = this.getDataset()) != null && (categoryAxis = this.getDomainAxis()) != null) {
                int n = categoryDataset.getColumnCount();
                int n2 = 0;
                while (n2 < n) {
                    double d = categoryAxis.getCategoryJava2DCoordinate(categoryAnchor, n2, n, rectangle2D, rectangleEdge);
                    CategoryItemRenderer categoryItemRenderer = this.getRenderer();
                    if (categoryItemRenderer != null) {
                        categoryItemRenderer.drawDomainGridline(graphics2D, this, rectangle2D, d);
                    }
                    ++n2;
                }
            }
        }
    }

    protected void drawRangeGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (this.isRangeGridlinesVisible()) {
            ValueAxis valueAxis;
            Stroke stroke = this.getRangeGridlineStroke();
            Paint paint = this.getRangeGridlinePaint();
            if (stroke != null && paint != null && (valueAxis = this.getRangeAxis()) != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ValueTick valueTick = (ValueTick)iterator.next();
                    CategoryItemRenderer categoryItemRenderer = this.getRenderer();
                    if (categoryItemRenderer == null) continue;
                    categoryItemRenderer.drawRangeGridline(graphics2D, this, this.getRangeAxis(), rectangle2D, valueTick.getValue());
                }
            }
        }
    }

    protected void drawAnnotations(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.getAnnotations() != null) {
            Iterator iterator = this.getAnnotations().iterator();
            while (iterator.hasNext()) {
                CategoryAnnotation categoryAnnotation = (CategoryAnnotation)iterator.next();
                categoryAnnotation.draw(graphics2D, this, rectangle2D, this.getDomainAxis(), this.getRangeAxis());
            }
        }
    }

    protected void drawRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, Layer layer) {
        CategoryItemRenderer categoryItemRenderer = this.getRenderer();
        Collection collection = this.getRangeMarkers(layer);
        if (collection != null && categoryItemRenderer != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                categoryItemRenderer.drawRangeMarker(graphics2D, this, this.getRangeAxis(), marker, rectangle2D);
            }
        }
    }

    protected void drawRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, Layer layer) {
        CategoryItemRenderer categoryItemRenderer = this.getRenderer(n);
        if (categoryItemRenderer == null) {
            return;
        }
        Collection collection = this.getRangeMarkers(n, layer);
        ValueAxis valueAxis = this.getRangeAxisForDataset(n);
        if (collection != null && valueAxis != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                categoryItemRenderer.drawRangeMarker(graphics2D, this, valueAxis, marker, rectangle2D);
            }
        }
    }

    protected void drawRangeLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().valueToJava2D(d, rectangle2D, this.getRangeAxisEdge());
        Line2D.Double double_ = null;
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (this.orientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        ArrayList arrayList = new ArrayList();
        int n = this.rangeAxes.indexOf(valueAxis);
        if (n >= 0) {
            arrayList.addAll(this.getDatasetsMappedToRangeAxis(n));
        } else if (valueAxis == this.getRangeAxis()) {
            arrayList.addAll(this.getDatasetsMappedToRangeAxis(0));
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            CategoryDataset categoryDataset = (CategoryDataset)iterator.next();
            CategoryItemRenderer categoryItemRenderer = this.getRendererForDataset(categoryDataset);
            if (categoryItemRenderer == null) continue;
            range = Range.combine(range, categoryItemRenderer.getRangeExtent(categoryDataset));
        }
        return range;
    }

    private List getDatasetsMappedToRangeAxis(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        while (n2 < this.datasets.size()) {
            Integer n3 = (Integer)this.datasetToRangeAxisMap.get(n2);
            if (n3 == null) {
                if (n == 0) {
                    arrayList.add(this.datasets.get(n2));
                }
            } else if (n3 == n) {
                arrayList.add(this.datasets.get(n2));
            }
            ++n2;
        }
        return arrayList;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace axisSpace) {
        this.fixedDomainAxisSpace = axisSpace;
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace axisSpace) {
        this.fixedRangeAxisSpace = axisSpace;
    }

    public List getCategories() {
        List list = null;
        if (this.getDataset() != null) {
            list = Collections.unmodifiableList(this.getDataset().getColumnKeys());
        }
        return list;
    }

    public boolean getDrawSharedDomainAxis() {
        return this.drawSharedDomainAxis;
    }

    public void setDrawSharedDomainAxis(boolean bl) {
        this.drawSharedDomainAxis = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void zoomHorizontalAxes(double d) {
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            int n = 0;
            while (n < this.rangeAxes.size()) {
                ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(n);
                if (valueAxis != null) {
                    valueAxis.resizeRange(d);
                }
                ++n;
            }
        }
    }

    public void zoomHorizontalAxes(double d, double d2) {
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            int n = 0;
            while (n < this.rangeAxes.size()) {
                ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(n);
                if (valueAxis != null) {
                    valueAxis.zoomRange(d, d2);
                }
                ++n;
            }
        }
    }

    public void zoomVerticalAxes(double d) {
        if (this.orientation == PlotOrientation.VERTICAL) {
            int n = 0;
            while (n < this.rangeAxes.size()) {
                ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(n);
                if (valueAxis != null) {
                    valueAxis.resizeRange(d);
                }
                ++n;
            }
        }
    }

    public void zoomVerticalAxes(double d, double d2) {
        if (this.orientation == PlotOrientation.VERTICAL) {
            int n = 0;
            while (n < this.rangeAxes.size()) {
                ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(n);
                if (valueAxis != null) {
                    valueAxis.zoomRange(d, d2);
                }
                ++n;
            }
        }
    }

    public double getAnchorValue() {
        return this.anchorValue;
    }

    public void setAnchorValue(double d) {
        this.setAnchorValue(d, true);
    }

    public void setAnchorValue(double d, boolean bl) {
        this.anchorValue = d;
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CategoryPlot && super.equals(object)) {
            CategoryPlot categoryPlot = (CategoryPlot)object;
            boolean bl = this.orientation == categoryPlot.orientation;
            boolean bl2 = ObjectUtils.equal(this.axisOffset, categoryPlot.axisOffset);
            boolean bl3 = this.domainAxes.equals(categoryPlot.domainAxes);
            boolean bl4 = this.domainAxisLocations.equals(categoryPlot.domainAxisLocations);
            boolean bl5 = this.drawSharedDomainAxis == categoryPlot.drawSharedDomainAxis;
            boolean bl6 = this.rangeAxes.equals(categoryPlot.rangeAxes);
            boolean bl7 = this.rangeAxisLocations.equals(categoryPlot.rangeAxisLocations);
            boolean bl8 = ObjectUtils.equal(this.datasetToDomainAxisMap, categoryPlot.datasetToDomainAxisMap);
            boolean bl9 = ObjectUtils.equal(this.datasetToRangeAxisMap, categoryPlot.datasetToRangeAxisMap);
            boolean bl10 = ObjectUtils.equal(this.renderers, categoryPlot.renderers);
            boolean bl11 = this.renderingOrder == categoryPlot.renderingOrder;
            boolean bl12 = this.columnRenderingOrder == categoryPlot.columnRenderingOrder;
            boolean bl13 = this.rowRenderingOrder == categoryPlot.rowRenderingOrder;
            boolean bl14 = this.domainGridlinesVisible == categoryPlot.domainGridlinesVisible;
            boolean bl15 = this.domainGridlinePosition == categoryPlot.domainGridlinePosition;
            boolean bl16 = ObjectUtils.equal(this.domainGridlineStroke, categoryPlot.domainGridlineStroke);
            boolean bl17 = ObjectUtils.equal(this.domainGridlinePaint, categoryPlot.domainGridlinePaint);
            boolean bl18 = this.rangeGridlinesVisible == categoryPlot.rangeGridlinesVisible;
            boolean bl19 = ObjectUtils.equal(this.rangeGridlineStroke, categoryPlot.rangeGridlineStroke);
            boolean bl20 = ObjectUtils.equal(this.rangeGridlinePaint, categoryPlot.rangeGridlinePaint);
            boolean bl21 = this.anchorValue == categoryPlot.anchorValue;
            boolean bl22 = this.rangeCrosshairVisible == categoryPlot.rangeCrosshairVisible;
            boolean bl23 = this.rangeCrosshairValue == categoryPlot.rangeCrosshairValue;
            boolean bl24 = ObjectUtils.equal(this.rangeCrosshairStroke, categoryPlot.rangeCrosshairStroke);
            boolean bl25 = ObjectUtils.equal(this.rangeCrosshairPaint, categoryPlot.rangeCrosshairPaint);
            boolean bl26 = this.rangeCrosshairLockedOnData == categoryPlot.rangeCrosshairLockedOnData;
            boolean bl27 = ObjectUtils.equal(this.foregroundRangeMarkers, categoryPlot.foregroundRangeMarkers);
            boolean bl28 = ObjectUtils.equal(this.backgroundRangeMarkers, categoryPlot.backgroundRangeMarkers);
            boolean bl29 = ObjectUtils.equal(this.annotations, categoryPlot.annotations);
            boolean bl30 = this.weight == categoryPlot.weight;
            boolean bl31 = ObjectUtils.equal(this.fixedDomainAxisSpace, categoryPlot.fixedDomainAxisSpace);
            boolean bl32 = ObjectUtils.equal(this.fixedRangeAxisSpace, categoryPlot.fixedRangeAxisSpace);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15 && bl16 && bl17 && bl18 && bl19 && bl20 && bl21 && bl22 && bl23 && bl24 && bl25 && bl26 && bl27 && bl28 && bl29 && bl30 && bl31 && bl32;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        Axis axis;
        Object object;
        CategoryPlot categoryPlot = (CategoryPlot)super.clone();
        categoryPlot.domainAxes = new ObjectList();
        int n = 0;
        while (n < this.domainAxes.size()) {
            object = (CategoryAxis)this.domainAxes.get(n);
            if (object != null) {
                axis = (CategoryAxis)((CategoryAxis)object).clone();
                categoryPlot.setDomainAxis(n, (CategoryAxis)axis);
            }
            ++n;
        }
        categoryPlot.domainAxisLocations = (ObjectList)this.domainAxisLocations.clone();
        categoryPlot.rangeAxes = new ObjectList();
        n = 0;
        while (n < this.rangeAxes.size()) {
            object = (ValueAxis)this.rangeAxes.get(n);
            if (object != null) {
                axis = (ValueAxis)((ValueAxis)object).clone();
                categoryPlot.setRangeAxis(n, (ValueAxis)axis);
            }
            ++n;
        }
        categoryPlot.rangeAxisLocations = (ObjectList)this.rangeAxisLocations.clone();
        categoryPlot.datasets = (ObjectList)this.datasets.clone();
        n = 0;
        while (n < categoryPlot.datasets.size()) {
            object = categoryPlot.getDataset(n);
            if (object != null) {
                object.addChangeListener(categoryPlot);
            }
            ++n;
        }
        categoryPlot.datasetToDomainAxisMap = (ObjectList)this.datasetToDomainAxisMap.clone();
        categoryPlot.datasetToRangeAxisMap = (ObjectList)this.datasetToRangeAxisMap.clone();
        categoryPlot.renderers = (ObjectList)this.renderers.clone();
        categoryPlot.fixedDomainAxisSpace = (AxisSpace)ObjectUtils.clone(this.fixedDomainAxisSpace);
        categoryPlot.fixedRangeAxisSpace = (AxisSpace)ObjectUtils.clone(this.fixedRangeAxisSpace);
        return categoryPlot;
    }
}

