/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.needle;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.util.ObjectUtils;

public abstract class MeterNeedle
implements Serializable {
    private transient Paint outlinePaint = Color.black;
    private transient Stroke outlineStroke = new BasicStroke(2.0f);
    private transient Paint fillPaint = null;
    private transient Paint highlightPaint = null;
    private int size = 5;
    private double rotateX = 0.5;
    private double rotateY = 0.5;
    protected static AffineTransform transform = new AffineTransform();

    public MeterNeedle() {
        this(null, null, null);
    }

    public MeterNeedle(Paint paint, Paint paint2, Paint paint3) {
        this.fillPaint = paint2;
        this.highlightPaint = paint3;
        this.outlinePaint = paint;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint != null) {
            this.outlinePaint = paint;
        }
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke != null) {
            this.outlineStroke = stroke;
        }
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint paint) {
        if (paint != null) {
            this.fillPaint = paint;
        }
    }

    public Paint getHighlightPaint() {
        return this.highlightPaint;
    }

    public void setHighlightPaint(Paint paint) {
        if (paint != null) {
            this.highlightPaint = paint;
        }
    }

    public double getRotateX() {
        return this.rotateX;
    }

    public void setRotateX(double d) {
        this.rotateX = d;
    }

    public void setRotateY(double d) {
        this.rotateY = d;
    }

    public double getRotateY() {
        return this.rotateY;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.draw(graphics2D, rectangle2D, 0.0);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, double d) {
        Point2D.Double double_ = new Point2D.Double();
        double_.setLocation(rectangle2D.getMinX() + this.rotateX * rectangle2D.getWidth(), rectangle2D.getMinY() + this.rotateY * rectangle2D.getHeight());
        this.draw(graphics2D, rectangle2D, double_, d);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, double d) {
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        this.drawNeedle(graphics2D, rectangle2D, point2D, Math.toRadians(d));
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(color);
    }

    protected abstract void drawNeedle(Graphics2D var1, Rectangle2D var2, Point2D var3, double var4);

    protected void defaultDisplay(Graphics2D graphics2D, Shape shape) {
        if (this.fillPaint != null) {
            graphics2D.setPaint(this.fillPaint);
            graphics2D.fill(shape);
        }
        if (this.outlinePaint != null) {
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.draw(shape);
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public AffineTransform getTransform() {
        return transform;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof MeterNeedle) {
            boolean bl;
            MeterNeedle meterNeedle = (MeterNeedle)object;
            boolean bl2 = ObjectUtils.equal(this.outlinePaint, meterNeedle.outlinePaint);
            boolean bl3 = ObjectUtils.equal(this.outlineStroke, meterNeedle.outlineStroke);
            boolean bl4 = ObjectUtils.equal(this.fillPaint, meterNeedle.fillPaint);
            boolean bl5 = ObjectUtils.equal(this.highlightPaint, meterNeedle.highlightPaint);
            boolean bl6 = this.size == meterNeedle.size;
            boolean bl7 = this.rotateX == meterNeedle.rotateX;
            boolean bl8 = bl = this.rotateY == meterNeedle.rotateY;
            return bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl;
        }
        return false;
    }
}

