/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;

public class StandardPieItemLabelGenerator
implements PieToolTipGenerator,
PieSectionLabelGenerator,
Cloneable,
Serializable {
    public static final String DEFAULT_TOOLTIP_FORMAT = "{0}: ({1}, {2})";
    public static final String DEFAULT_SECTION_LABEL_FORMAT = "{0} = {1}";
    private String labelFormat;
    private NumberFormat numberFormat;
    private NumberFormat percentFormat;

    public StandardPieItemLabelGenerator() {
        this(DEFAULT_SECTION_LABEL_FORMAT, NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance());
    }

    public StandardPieItemLabelGenerator(String string) {
        this(string, NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance());
    }

    public StandardPieItemLabelGenerator(String string, NumberFormat numberFormat, NumberFormat numberFormat2) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'itemLabelFormat' argument.");
        }
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'numberFormat' argument.");
        }
        if (numberFormat2 == null) {
            throw new IllegalArgumentException("Null 'percentFormat' argument.");
        }
        this.labelFormat = string;
        this.numberFormat = numberFormat;
        this.percentFormat = numberFormat2;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public NumberFormat getPercentFormat() {
        return this.percentFormat;
    }

    public String generateSectionLabel(PieDataset pieDataset, Comparable comparable) {
        String string = null;
        if (pieDataset != null) {
            Object[] objectArray = this.createItemArray(pieDataset, comparable);
            string = MessageFormat.format(this.labelFormat, objectArray);
        }
        return string;
    }

    public String generateToolTip(PieDataset pieDataset, Comparable comparable) {
        return this.generateSectionLabel(pieDataset, comparable);
    }

    protected Object[] createItemArray(PieDataset pieDataset, Comparable comparable) {
        double d;
        Object[] objectArray = new Object[3];
        objectArray[0] = comparable.toString();
        Number number = pieDataset.getValue(comparable);
        objectArray[1] = this.numberFormat.format(number);
        double d2 = 0.0;
        if (number != null && (d = number.doubleValue()) > 0.0) {
            d2 = d / DatasetUtilities.calculatePieDatasetTotal(pieDataset);
        }
        objectArray[2] = this.percentFormat.format(d2);
        return objectArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardPieItemLabelGenerator) {
            StandardPieItemLabelGenerator standardPieItemLabelGenerator = (StandardPieItemLabelGenerator)object;
            if (!this.labelFormat.equals(standardPieItemLabelGenerator.labelFormat)) {
                return false;
            }
            if (!this.numberFormat.equals(standardPieItemLabelGenerator.numberFormat)) {
                return false;
            }
            return this.percentFormat.equals(standardPieItemLabelGenerator.percentFormat);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        StandardPieItemLabelGenerator standardPieItemLabelGenerator = (StandardPieItemLabelGenerator)super.clone();
        if (this.numberFormat != null) {
            standardPieItemLabelGenerator.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        return standardPieItemLabelGenerator;
    }
}

