/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.chart.labels.ContourToolTipGenerator;
import org.jfree.data.contour.ContourDataset;

public class StandardContourToolTipGenerator
implements ContourToolTipGenerator,
Serializable {
    private DecimalFormat valueForm = new DecimalFormat("##.###");

    public String generateToolTip(ContourDataset contourDataset, int n) {
        Number number = contourDataset.getX(0, n);
        Number number2 = contourDataset.getY(0, n);
        Number number3 = contourDataset.getZ(0, n);
        String string = null;
        if (contourDataset.isDateAxis(0)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer = simpleDateFormat.format(new Date(number.longValue()), stringBuffer, new FieldPosition(0));
            string = stringBuffer.toString();
        } else {
            string = this.valueForm.format(number.doubleValue());
        }
        if (number3 != null) {
            return "X: " + string + ", Y: " + this.valueForm.format(number2.doubleValue()) + ", Z: " + this.valueForm.format(number3.doubleValue());
        }
        return "X: " + string + ", Y: " + this.valueForm.format(number2.doubleValue()) + ", Z: no data";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardContourToolTipGenerator)) {
            return false;
        }
        StandardContourToolTipGenerator standardContourToolTipGenerator = (StandardContourToolTipGenerator)object;
        if (this.valueForm != null) {
            return this.valueForm.equals(standardContourToolTipGenerator.valueForm);
        }
        return false;
    }
}

