/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.ObjectUtils;

public class AbstractXYItemLabelGenerator
implements Cloneable,
Serializable {
    private String formatString;
    private NumberFormat xFormat;
    private DateFormat xDateFormat;
    private NumberFormat yFormat;
    private DateFormat yDateFormat;

    protected AbstractXYItemLabelGenerator() {
        this("{2}", NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    protected AbstractXYItemLabelGenerator(String string, NumberFormat numberFormat, NumberFormat numberFormat2) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'formatString' argument.");
        }
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'xFormat' argument.");
        }
        if (numberFormat2 == null) {
            throw new IllegalArgumentException("Null 'yFormat' argument.");
        }
        this.formatString = string;
        this.xFormat = numberFormat;
        this.yFormat = numberFormat2;
    }

    protected AbstractXYItemLabelGenerator(String string, DateFormat dateFormat, NumberFormat numberFormat) {
        this(string, NumberFormat.getInstance(), numberFormat);
        this.xDateFormat = dateFormat;
    }

    protected AbstractXYItemLabelGenerator(String string, DateFormat dateFormat, DateFormat dateFormat2) {
        this(string, NumberFormat.getInstance(), NumberFormat.getInstance());
        this.xDateFormat = dateFormat;
        this.yDateFormat = dateFormat2;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public NumberFormat getXFormat() {
        return this.xFormat;
    }

    public DateFormat getXDateFormat() {
        return this.xDateFormat;
    }

    public NumberFormat getYFormat() {
        return this.yFormat;
    }

    public DateFormat getYDateFormat() {
        return this.yDateFormat;
    }

    public String generateLabelString(XYDataset xYDataset, int n, int n2) {
        String string = null;
        Object[] objectArray = this.createItemArray(xYDataset, n, n2);
        string = MessageFormat.format(this.formatString, objectArray);
        return string;
    }

    protected Object[] createItemArray(XYDataset xYDataset, int n, int n2) {
        Object[] objectArray = new Object[3];
        objectArray[0] = xYDataset.getSeriesName(n);
        Number number = xYDataset.getX(n, n2);
        objectArray[1] = this.xDateFormat != null ? this.xDateFormat.format(number) : this.xFormat.format(number);
        Number number2 = xYDataset.getY(n, n2);
        objectArray[2] = this.yDateFormat != null ? this.yDateFormat.format(number2) : this.yFormat.format(number2);
        return objectArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractXYItemLabelGenerator) {
            AbstractXYItemLabelGenerator abstractXYItemLabelGenerator = (AbstractXYItemLabelGenerator)object;
            if (!this.formatString.equals(abstractXYItemLabelGenerator.formatString)) {
                return false;
            }
            if (!ObjectUtils.equal(this.xFormat, abstractXYItemLabelGenerator.xFormat)) {
                return false;
            }
            if (!ObjectUtils.equal(this.xDateFormat, abstractXYItemLabelGenerator.xDateFormat)) {
                return false;
            }
            if (!ObjectUtils.equal(this.yFormat, abstractXYItemLabelGenerator.yFormat)) {
                return false;
            }
            return ObjectUtils.equal(this.yDateFormat, abstractXYItemLabelGenerator.yDateFormat);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractXYItemLabelGenerator abstractXYItemLabelGenerator = (AbstractXYItemLabelGenerator)super.clone();
        if (this.xFormat != null) {
            abstractXYItemLabelGenerator.xFormat = (NumberFormat)this.xFormat.clone();
        }
        if (this.yFormat != null) {
            abstractXYItemLabelGenerator.yFormat = (NumberFormat)this.yFormat.clone();
        }
        return abstractXYItemLabelGenerator;
    }
}

