/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.util.ObjectUtils;

public class ChartEntity
implements Cloneable,
Serializable {
    private transient Shape area;
    private String toolTipText;
    private String urlText;

    public ChartEntity(Shape shape) {
        this(shape, null);
    }

    public ChartEntity(Shape shape, String string) {
        this(shape, string, null);
    }

    public ChartEntity(Shape shape, String string, String string2) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.area = shape;
        this.toolTipText = string;
        this.urlText = string2;
    }

    public Shape getArea() {
        return this.area;
    }

    public void setArea(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.area = shape;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String string) {
        this.urlText = string;
    }

    public String getShapeType() {
        if (this.area instanceof Rectangle2D) {
            return "RECT";
        }
        return "POLY";
    }

    public String getShapeCoords() {
        if (this.area instanceof Rectangle2D) {
            return this.getRectCoords((Rectangle2D)this.area);
        }
        return this.getPolyCoords(this.area);
    }

    private String getRectCoords(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null 'rectangle' argument.");
        }
        int n = (int)rectangle2D.getX();
        int n2 = (int)rectangle2D.getY();
        int n3 = n + (int)rectangle2D.getWidth();
        int n4 = n2 + (int)rectangle2D.getHeight();
        if (n3 == n) {
            ++n3;
        }
        if (n4 == n2) {
            ++n4;
        }
        return String.valueOf(n) + "," + n2 + "," + n3 + "," + n4;
    }

    private String getPolyCoords(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        String string = "";
        boolean bl = true;
        float[] fArray = new float[6];
        PathIterator pathIterator = shape.getPathIterator(null, 1.0);
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray);
            if (bl) {
                bl = false;
                string = String.valueOf(string) + (int)fArray[0] + "," + (int)fArray[1];
            } else {
                string = String.valueOf(string) + "," + (int)fArray[0] + "," + (int)fArray[1];
            }
            pathIterator.next();
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ChartEntity) {
            ChartEntity chartEntity = (ChartEntity)object;
            if (!this.area.equals(chartEntity.area)) {
                return false;
            }
            if (!ObjectUtils.equal(this.toolTipText, chartEntity.toolTipText)) {
                return false;
            }
            return ObjectUtils.equal(this.urlText, chartEntity.urlText);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

