/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.data.Range;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public abstract class ValueAxis
extends Axis
implements Cloneable,
PublicCloneable,
Serializable {
    public static final Range DEFAULT_RANGE = new Range(0.0, 1.0);
    public static final boolean DEFAULT_AUTO_RANGE = true;
    public static final boolean DEFAULT_INVERTED = false;
    public static final double DEFAULT_AUTO_RANGE_MINIMUM_SIZE = 1.0E-8;
    public static final double DEFAULT_LOWER_MARGIN = 0.05;
    public static final double DEFAULT_UPPER_MARGIN = 0.05;
    public static final double DEFAULT_LOWER_BOUND = 0.0;
    public static final double DEFAULT_UPPER_BOUND = 1.0;
    public static final boolean DEFAULT_AUTO_TICK_UNIT_SELECTION = true;
    public static final int MAXIMUM_TICK_COUNT = 500;
    private boolean positiveArrowVisible = false;
    private boolean negativeArrowVisible = false;
    private transient Shape upArrow;
    private transient Shape downArrow;
    private transient Shape leftArrow;
    private transient Shape rightArrow;
    private boolean inverted = false;
    private Range range = DEFAULT_RANGE;
    private boolean autoRange = true;
    private double autoRangeMinimumSize = 1.0E-8;
    private double upperMargin = 0.05;
    private double lowerMargin = 0.05;
    private double fixedAutoRange = 0.0;
    private boolean autoTickUnitSelection = true;
    private TickUnitSource standardTickUnits;
    private int autoTickIndex;
    private boolean verticalTickLabels;

    protected ValueAxis(String string, TickUnitSource tickUnitSource) {
        super(string);
        this.standardTickUnits = tickUnitSource;
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(-2, 2);
        polygon.addPoint(2, 2);
        this.upArrow = polygon;
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(0, 0);
        polygon2.addPoint(-2, -2);
        polygon2.addPoint(2, -2);
        this.downArrow = polygon2;
        Polygon polygon3 = new Polygon();
        polygon3.addPoint(0, 0);
        polygon3.addPoint(-2, -2);
        polygon3.addPoint(-2, 2);
        this.rightArrow = polygon3;
        Polygon polygon4 = new Polygon();
        polygon4.addPoint(0, 0);
        polygon4.addPoint(2, -2);
        polygon4.addPoint(2, 2);
        this.leftArrow = polygon4;
        this.verticalTickLabels = false;
    }

    public boolean isVerticalTickLabels() {
        return this.verticalTickLabels;
    }

    public void setVerticalTickLabels(boolean bl) {
        if (this.verticalTickLabels != bl) {
            this.verticalTickLabels = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isPositiveArrowVisible() {
        return this.positiveArrowVisible;
    }

    public void setPositiveArrowVisible(boolean bl) {
        this.positiveArrowVisible = bl;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isNegativeArrowVisible() {
        return this.negativeArrowVisible;
    }

    public void setNegativeArrowVisible(boolean bl) {
        this.negativeArrowVisible = bl;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Shape getUpArrow() {
        return this.upArrow;
    }

    public void setUpArrow(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'arrow' argument.");
        }
        this.upArrow = shape;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Shape getDownArrow() {
        return this.downArrow;
    }

    public void setDownArrow(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'arrow' argument.");
        }
        this.downArrow = shape;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Shape getLeftArrow() {
        return this.leftArrow;
    }

    public void setLeftArrow(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'arrow' argument.");
        }
        this.leftArrow = shape;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Shape getRightArrow() {
        return this.rightArrow;
    }

    public void setRightArrow(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'arrow' argument.");
        }
        this.rightArrow = shape;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    protected void drawAxisLine(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Shape shape;
        AffineTransform affineTransform;
        Shape shape2;
        double d2;
        double d3;
        Line2D.Double double_ = null;
        if (rectangleEdge == RectangleEdge.TOP) {
            double_ = new Line2D.Double(rectangle2D.getX(), d, rectangle2D.getMaxX(), d);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            double_ = new Line2D.Double(rectangle2D.getX(), d, rectangle2D.getMaxX(), d);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            double_ = new Line2D.Double(d, rectangle2D.getY(), d, rectangle2D.getMaxY());
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            double_ = new Line2D.Double(d, rectangle2D.getY(), d, rectangle2D.getMaxY());
        }
        graphics2D.setPaint(this.getAxisLinePaint());
        graphics2D.setStroke(this.getAxisLineStroke());
        graphics2D.draw(double_);
        boolean bl = false;
        boolean bl2 = false;
        if (this.positiveArrowVisible) {
            if (this.inverted) {
                bl2 = true;
            } else {
                bl = true;
            }
        }
        if (this.negativeArrowVisible) {
            if (this.inverted) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        if (bl) {
            d3 = 0.0;
            d2 = 0.0;
            shape2 = null;
            if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                d3 = rectangle2D.getMaxX();
                d2 = d;
                shape2 = this.rightArrow;
            } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                d3 = d;
                d2 = rectangle2D.getMinY();
                shape2 = this.upArrow;
            }
            affineTransform = new AffineTransform();
            affineTransform.setToTranslation(d3, d2);
            shape = affineTransform.createTransformedShape(shape2);
            graphics2D.fill(shape);
            graphics2D.draw(shape);
        }
        if (bl2) {
            d3 = 0.0;
            d2 = 0.0;
            shape2 = null;
            if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                d3 = rectangle2D.getMinX();
                d2 = d;
                shape2 = this.leftArrow;
            } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                d3 = d;
                d2 = rectangle2D.getMaxY();
                shape2 = this.downArrow;
            }
            affineTransform = new AffineTransform();
            affineTransform.setToTranslation(d3, d2);
            shape = affineTransform.createTransformedShape(shape2);
            graphics2D.fill(shape);
            graphics2D.draw(shape);
        }
    }

    protected float[] calculateAnchorPoint(ValueTick valueTick, double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        float[] fArray = new float[2];
        if (rectangleEdge == RectangleEdge.TOP) {
            fArray[0] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
            fArray[1] = (float)(d - (double)this.getTickLabelInsets().bottom - 2.0);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            fArray[0] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
            fArray[1] = (float)(d + (double)this.getTickLabelInsets().top + 2.0);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            fArray[0] = (float)(d - (double)this.getTickLabelInsets().left - 2.0);
            fArray[1] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            fArray[0] = (float)(d + (double)this.getTickLabelInsets().right + 2.0);
            fArray[1] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
        }
        return fArray;
    }

    protected AxisState drawTickMarksAndLabels(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        AxisState axisState = new AxisState(d);
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d, rectangle2D2, rectangleEdge);
        }
        double d2 = this.getTickMarkOutsideLength();
        double d3 = this.getTickMarkInsideLength();
        List list = this.refreshTicks(graphics2D, axisState, rectangle2D, rectangle2D2, rectangleEdge);
        axisState.setTicks(list);
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ValueTick valueTick = (ValueTick)iterator.next();
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                float[] fArray = this.calculateAnchorPoint(valueTick, d, rectangle2D2, rectangleEdge);
                RefineryUtilities.drawRotatedString(valueTick.getText(), graphics2D, fArray[0], fArray[1], valueTick.getTextAnchor(), valueTick.getRotationAnchor(), valueTick.getAngle());
            }
            if (!this.isTickMarksVisible()) continue;
            float f = (float)this.translateValueToJava2D(valueTick.getValue(), rectangle2D2, rectangleEdge);
            Line2D.Double double_ = null;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            if (rectangleEdge == RectangleEdge.LEFT) {
                double_ = new Line2D.Double(d - d2, f, d + d3, f);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                double_ = new Line2D.Double(d + d2, f, d - d3, f);
            } else if (rectangleEdge == RectangleEdge.TOP) {
                double_ = new Line2D.Double(f, d - d2, f, d + d3);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                double_ = new Line2D.Double(f, d + d2, f, d - d3);
            }
            graphics2D.draw(double_);
        }
        double d4 = 0.0;
        if (this.isTickLabelsVisible()) {
            if (rectangleEdge == RectangleEdge.LEFT) {
                axisState.cursorLeft(d4 += this.findMaximumTickLabelWidth(list, graphics2D, rectangle2D, this.isVerticalTickLabels()));
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                d4 = this.findMaximumTickLabelWidth(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorRight(d4);
            } else if (rectangleEdge == RectangleEdge.TOP) {
                d4 = this.findMaximumTickLabelHeight(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorUp(d4);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                d4 = this.findMaximumTickLabelHeight(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorDown(d4);
            }
        }
        return axisState;
    }

    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        Object object;
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        if (!this.isVisible()) {
            return axisSpace;
        }
        double d = this.getFixedDimension();
        if (d > 0.0) {
            axisSpace.ensureAtLeast(d, rectangleEdge);
        }
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            object = this.refreshTicks(graphics2D, new AxisState(), rectangle2D, rectangle2D, rectangleEdge);
            if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
                d2 = this.findMaximumTickLabelHeight((List)object, graphics2D, rectangle2D, this.isVerticalTickLabels());
            } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
                d3 = this.findMaximumTickLabelWidth((List)object, graphics2D, rectangle2D, this.isVerticalTickLabels());
            }
        }
        object = this.getLabelEnclosure(graphics2D, rectangleEdge);
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = ((RectangularShape)object).getHeight();
            axisSpace.add(d4 + d2, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d5 = ((RectangularShape)object).getWidth();
            axisSpace.add(d5 + d3, rectangleEdge);
        }
        return axisSpace;
    }

    protected double findMaximumTickLabelHeight(List list, Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Insets insets = this.getTickLabelInsets();
        Font font = this.getTickLabelFont();
        double d = 0.0;
        if (bl) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(tick.getText(), graphics2D, fontMetrics);
                if (!(rectangle2D2.getWidth() + (double)insets.top + (double)insets.bottom > d)) continue;
                d = rectangle2D2.getWidth() + (double)insets.top + (double)insets.bottom;
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", graphics2D.getFontRenderContext());
            d = lineMetrics.getHeight() + (float)insets.top + (float)insets.bottom;
        }
        return d;
    }

    protected double findMaximumTickLabelWidth(List list, Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Insets insets = this.getTickLabelInsets();
        Font font = this.getTickLabelFont();
        double d = 0.0;
        if (!bl) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(tick.getText(), graphics2D, fontMetrics);
                if (!(rectangle2D2.getWidth() + (double)insets.left + (double)insets.right > d)) continue;
                d = rectangle2D2.getWidth() + (double)insets.left + (double)insets.right;
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", graphics2D.getFontRenderContext());
            d = lineMetrics.getHeight() + (float)insets.top + (float)insets.bottom;
        }
        return d;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean bl) {
        if (this.inverted != bl) {
            this.inverted = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void setAutoRange(boolean bl) {
        this.setAutoRange(bl, true);
    }

    protected void setAutoRange(boolean bl, boolean bl2) {
        if (this.autoRange != bl) {
            this.autoRange = bl;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            if (bl2) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public double getAutoRangeMinimumSize() {
        return this.autoRangeMinimumSize;
    }

    public void setAutoRangeMinimumSize(double d) {
        this.setAutoRangeMinimumSize(d, true);
    }

    public void setAutoRangeMinimumSize(double d, boolean bl) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("NumberAxis.setAutoRangeMinimumSize(double): must be > 0.0.");
        }
        if (this.autoRangeMinimumSize != d) {
            this.autoRangeMinimumSize = d;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            if (bl) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double d) {
        this.lowerMargin = d;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double d) {
        this.upperMargin = d;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getFixedAutoRange() {
        return this.fixedAutoRange;
    }

    public void setFixedAutoRange(double d) {
        this.fixedAutoRange = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getLowerBound() {
        return this.range.getLowerBound();
    }

    public void setLowerBound(double d) {
        if (this.range.getUpperBound() > d) {
            this.setRange(new Range(d, this.range.getUpperBound()));
        } else {
            this.setRange(new Range(d, d + 1.0));
        }
    }

    public double getUpperBound() {
        return this.range.getUpperBound();
    }

    public void setUpperBound(double d) {
        if (this.range.getLowerBound() < d) {
            this.setRange(new Range(this.range.getLowerBound(), d));
        } else {
            this.setRange(d - 1.0, d);
        }
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.setRange(range, true, true);
    }

    public void setRange(Range range, boolean bl, boolean bl2) {
        if (range == null) {
            throw new IllegalArgumentException("Null 'range' argument.");
        }
        if (bl) {
            this.autoRange = false;
        }
        this.range = range;
        if (bl2) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void setRange(double d, double d2) {
        this.setRange(new Range(d, d2));
    }

    public void setRangeWithMargins(Range range) {
        this.setRangeWithMargins(range, true, true);
    }

    public void setRangeWithMargins(Range range, boolean bl, boolean bl2) {
        if (range == null) {
            throw new IllegalArgumentException("Null 'range' argument.");
        }
        this.setRange(Range.expand(range, this.getLowerMargin(), this.getUpperMargin()), bl, bl2);
    }

    public void setRangeWithMargins(double d, double d2) {
        this.setRangeWithMargins(new Range(d, d2));
    }

    public void setRangeAboutValue(double d, double d2) {
        this.setRange(new Range(d - d2 / 2.0, d + d2 / 2.0));
    }

    public boolean isAutoTickUnitSelection() {
        return this.autoTickUnitSelection;
    }

    public void setAutoTickUnitSelection(boolean bl) {
        this.setAutoTickUnitSelection(bl, true);
    }

    public void setAutoTickUnitSelection(boolean bl, boolean bl2) {
        if (this.autoTickUnitSelection != bl) {
            this.autoTickUnitSelection = bl;
            if (bl2) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public TickUnitSource getStandardTickUnits() {
        return this.standardTickUnits;
    }

    public void setStandardTickUnits(TickUnitSource tickUnitSource) {
        this.standardTickUnits = tickUnitSource;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public abstract double valueToJava2D(double var1, Rectangle2D var3, RectangleEdge var4);

    public double lengthToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = this.valueToJava2D(0.0, rectangle2D, rectangleEdge);
        double d3 = this.valueToJava2D(d, rectangle2D, rectangleEdge);
        return Math.abs(d3 - d2);
    }

    public abstract double java2DToValue(double var1, Rectangle2D var3, RectangleEdge var4);

    protected abstract void autoAdjustRange();

    public void centerRange(double d) {
        double d2 = this.range.getCentralValue();
        Range range = new Range(this.range.getLowerBound() + d - d2, this.range.getUpperBound() + d - d2);
        this.setRange(range);
    }

    public void resizeRange(double d) {
        this.resizeRange(d, this.range.getCentralValue());
    }

    public void resizeRange(double d, double d2) {
        if (d > 0.0) {
            double d3 = this.range.getLength() * d / 2.0;
            Range range = new Range(d2 - d3, d2 + d3);
            this.setRange(range);
        } else {
            this.setAutoRange(true);
        }
    }

    public void zoomRange(double d, double d2) {
        double d3 = this.range.getLowerBound();
        double d4 = this.range.getLength();
        Range range = null;
        range = this.isInverted() ? new Range(d3 + d4 * (1.0 - d2), d3 + d4 * (1.0 - d)) : new Range(d3 + d4 * d, d3 + d4 * d2);
        this.setRange(range);
    }

    protected int getAutoTickIndex() {
        return this.autoTickIndex;
    }

    protected void setAutoTickIndex(int n) {
        this.autoTickIndex = n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof ValueAxis) {
            ValueAxis valueAxis = (ValueAxis)object;
            if (super.equals(object)) {
                boolean bl;
                boolean bl2 = this.positiveArrowVisible == valueAxis.positiveArrowVisible;
                boolean bl3 = this.negativeArrowVisible == valueAxis.negativeArrowVisible;
                boolean bl4 = this.inverted == valueAxis.inverted;
                boolean bl5 = ObjectUtils.equal(this.range, valueAxis.range);
                boolean bl6 = this.autoRange == valueAxis.autoRange;
                boolean bl7 = this.autoRangeMinimumSize == valueAxis.autoRangeMinimumSize;
                boolean bl8 = Math.abs(this.upperMargin - valueAxis.upperMargin) < 1.0E-6;
                boolean bl9 = Math.abs(this.lowerMargin - valueAxis.lowerMargin) < 1.0E-6;
                boolean bl10 = Math.abs(this.fixedAutoRange - valueAxis.fixedAutoRange) < 1.0E-6;
                boolean bl11 = this.autoTickUnitSelection == valueAxis.autoTickUnitSelection;
                boolean bl12 = ObjectUtils.equal(this.standardTickUnits, valueAxis.standardTickUnits);
                boolean bl13 = bl = this.verticalTickLabels == valueAxis.verticalTickLabels;
                return bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl;
            }
            return false;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        ValueAxis valueAxis = (ValueAxis)super.clone();
        return valueAxis;
    }

    public double getMinimumAxisValue() {
        return this.getLowerBound();
    }

    public void setMinimumAxisValue(double d) {
        this.setLowerBound(d);
    }

    public double getMaximumAxisValue() {
        return this.getUpperBound();
    }

    public void setMaximumAxisValue(double d) {
        this.setUpperBound(d);
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return this.valueToJava2D(d, rectangle2D, rectangleEdge);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return this.translateJava2DToValue(f, rectangle2D, rectangleEdge);
    }

    public double translateJava2DToValue(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return this.java2DToValue(d, rectangle2D, rectangleEdge);
    }
}

