/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtils;

public abstract class Tick
implements Serializable,
Cloneable {
    private String text;
    private TextAnchor textAnchor;
    private TextAnchor rotationAnchor;
    private double angle;

    public Tick(String string, TextAnchor textAnchor, TextAnchor textAnchor2, double d) {
        if (textAnchor == null) {
            throw new IllegalArgumentException("Null 'textAnchor' argument.");
        }
        if (textAnchor2 == null) {
            throw new IllegalArgumentException("Null 'rotationAnchor' argument.");
        }
        this.text = string;
        this.textAnchor = textAnchor;
        this.rotationAnchor = textAnchor2;
        this.angle = d;
    }

    public String getText() {
        return this.text;
    }

    public TextAnchor getTextAnchor() {
        return this.textAnchor;
    }

    public TextAnchor getRotationAnchor() {
        return this.rotationAnchor;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Tick) {
            Tick tick = (Tick)object;
            if (!ObjectUtils.equal(this.text, tick.text)) {
                return false;
            }
            if (!ObjectUtils.equal(this.textAnchor, tick.textAnchor)) {
                return false;
            }
            if (!ObjectUtils.equal(this.rotationAnchor, tick.rotationAnchor)) {
                return false;
            }
            return this.angle == tick.angle;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        Tick tick = (Tick)super.clone();
        return tick;
    }

    public String toString() {
        return this.text;
    }
}

