/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class SymbolicAxis
extends NumberAxis
implements Serializable {
    public static final Paint DEFAULT_SYMBOLIC_GRID_LINE_PAINT = new Color(232, 234, 232, 128);
    private List symbolicValue;
    private List symbolicGridLineList = null;
    private transient Paint symbolicGridPaint;
    private boolean symbolicGridLinesVisible;

    public SymbolicAxis(String string, String[] stringArray) {
        super(string);
        this.symbolicValue = Arrays.asList(stringArray);
        this.symbolicGridLinesVisible = true;
        this.symbolicGridPaint = DEFAULT_SYMBOLIC_GRID_LINE_PAINT;
        this.setAutoTickUnitSelection(false, false);
        this.setAutoRangeStickyZero(false);
    }

    public String[] getSymbolicValue() {
        String[] stringArray = new String[this.symbolicValue.size()];
        stringArray = this.symbolicValue.toArray(stringArray);
        return stringArray;
    }

    public Paint getSymbolicGridPaint() {
        return this.symbolicGridPaint;
    }

    public boolean isGridLinesVisible() {
        return this.symbolicGridLinesVisible;
    }

    public void setSymbolicGridLinesVisible(boolean bl) {
        if (this.symbolicGridLinesVisible != bl) {
            this.symbolicGridLinesVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        throw new UnsupportedOperationException();
    }

    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState = new AxisState(d);
        if (this.isVisible()) {
            axisState = super.draw(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge, plotRenderingInfo);
        }
        if (this.symbolicGridLinesVisible) {
            this.drawSymbolicGridLines(graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState.getTicks());
        }
        return axisState;
    }

    public void drawSymbolicGridLines(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, List list) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D2);
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.drawSymbolicGridLinesHorizontal(graphics2D, rectangle2D, rectangle2D2, true, list);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.drawSymbolicGridLinesVertical(graphics2D, rectangle2D, rectangle2D2, true, list);
        }
        graphics2D.setClip(shape);
    }

    public void drawSymbolicGridLinesHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl, List list) {
        this.symbolicGridLineList = new Vector(list.size());
        boolean bl2 = bl;
        double d = rectangle2D2.getY();
        double d2 = this.getPlot().getOutlineStroke() != null ? (double)((BasicStroke)this.getPlot().getOutlineStroke()).getLineWidth() : 1.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ValueTick valueTick = (ValueTick)iterator.next();
            double d3 = this.valueToJava2D(valueTick.getValue() - 0.5, rectangle2D2, RectangleEdge.BOTTOM);
            double d4 = this.valueToJava2D(valueTick.getValue() + 0.5, rectangle2D2, RectangleEdge.BOTTOM);
            if (bl2) {
                graphics2D.setPaint(this.symbolicGridPaint);
            } else {
                graphics2D.setPaint(Color.white);
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d + d2, d4 - d3, rectangle2D2.getMaxY() - d - d2);
            graphics2D.fill(double_);
            this.symbolicGridLineList.add(double_);
            boolean bl3 = bl2 = !bl2;
        }
        graphics2D.setPaintMode();
    }

    public Rectangle2D.Double getSymbolicGridLine(int n) {
        if (this.symbolicGridLineList != null) {
            return (Rectangle2D.Double)this.symbolicGridLineList.get(n);
        }
        return null;
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            double d;
            double d2;
            double d3 = this.symbolicValue.size() - 1;
            double d4 = d3 - (d2 = 0.0);
            if (d4 < (d = this.getAutoRangeMinimumSize())) {
                d3 = (d3 + d2 + d) / 2.0;
                d2 = (d3 + d2 - d) / 2.0;
            }
            double d5 = 0.5;
            double d6 = 0.5;
            if (this.autoRangeIncludesZero()) {
                if (this.autoRangeStickyZero()) {
                    d3 = d3 <= 0.0 ? 0.0 : (d3 += d5);
                    d2 = d2 >= 0.0 ? 0.0 : (d2 -= d6);
                } else {
                    d3 = Math.max(0.0, d3 + d5);
                    d2 = Math.min(0.0, d2 - d6);
                }
            } else if (this.autoRangeStickyZero()) {
                d3 = d3 <= 0.0 ? Math.min(0.0, d3 + d5) : (d3 += d5 * d4);
                d2 = d2 >= 0.0 ? Math.max(0.0, d2 - d6) : (d2 -= d6);
            } else {
                d3 += d5;
                d2 -= d6;
            }
            this.setRange(new Range(d2, d3), false, false);
        }
    }

    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        List list = null;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            list = this.refreshTicksHorizontal(graphics2D, axisState.getCursor(), rectangle2D, rectangle2D2, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            list = this.refreshTicksVertical(graphics2D, axisState.getCursor(), rectangle2D, rectangle2D2, rectangleEdge);
        }
        return list;
    }

    public List refreshTicksHorizontal(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        double d2 = this.getTickUnit().getSize();
        int n = this.calculateVisibleTickCount();
        double d3 = this.calculateLowestVisibleTickValue();
        double d4 = 0.0;
        double d5 = 0.0;
        if (n <= 500) {
            int n2 = 0;
            while (n2 < n) {
                double d6 = d3 + (double)n2 * d2;
                double d7 = this.valueToJava2D(d6, rectangle2D2, rectangleEdge);
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d6) : this.valueToString(d6);
                Rectangle2D rectangle2D3 = TextUtilities.getTextBounds(string, graphics2D, graphics2D.getFontMetrics());
                double d8 = this.isVerticalTickLabels() ? rectangle2D3.getHeight() : rectangle2D3.getWidth();
                boolean bl = false;
                if (n2 > 0) {
                    double d9 = (d5 + d8) / 2.0;
                    if (Math.abs(d7 - d4) < d9) {
                        bl = true;
                    }
                }
                if (bl) {
                    string = "";
                } else {
                    d4 = d7;
                    d5 = d8;
                }
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d10 = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                    d10 = rectangleEdge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
                } else if (rectangleEdge == RectangleEdge.TOP) {
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                } else {
                    textAnchor = TextAnchor.TOP_CENTER;
                    textAnchor2 = TextAnchor.TOP_CENTER;
                }
                NumberTick numberTick = new NumberTick(new Double(d6), string, textAnchor, textAnchor2, d10);
                arrayList.add(numberTick);
                ++n2;
            }
        }
        return arrayList;
    }

    public List refreshTicksVertical(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        double d2 = this.getTickUnit().getSize();
        int n = this.calculateVisibleTickCount();
        double d3 = this.calculateLowestVisibleTickValue();
        double d4 = 0.0;
        double d5 = 0.0;
        if (n <= 500) {
            int n2 = 0;
            while (n2 < n) {
                double d6 = d3 + (double)n2 * d2;
                double d7 = this.valueToJava2D(d6, rectangle2D2, rectangleEdge);
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d6) : this.valueToString(d6);
                Rectangle2D rectangle2D3 = TextUtilities.getTextBounds(string, graphics2D, graphics2D.getFontMetrics());
                double d8 = this.isVerticalTickLabels() ? rectangle2D3.getWidth() : rectangle2D3.getHeight();
                boolean bl = false;
                if (n2 > 0) {
                    double d9 = (d5 + d8) / 2.0;
                    if (Math.abs(d7 - d4) < d9) {
                        bl = true;
                    }
                    if (bl) {
                        string = "";
                    } else {
                        d4 = d7;
                        d5 = d8;
                    }
                }
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d10 = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                    d10 = rectangleEdge == RectangleEdge.LEFT ? -1.5707963267948966 : 1.5707963267948966;
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                } else {
                    textAnchor = TextAnchor.CENTER_LEFT;
                    textAnchor2 = TextAnchor.CENTER_LEFT;
                }
                NumberTick numberTick = new NumberTick(new Double(d6), string, textAnchor, textAnchor2, d10);
                arrayList.add(numberTick);
                ++n2;
            }
        }
        return arrayList;
    }

    public String valueToString(double d) {
        String string;
        try {
            string = (String)this.symbolicValue.get((int)d);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string = new String("");
        }
        return string;
    }

    public void drawSymbolicGridLinesVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl, List list) {
        this.symbolicGridLineList = new Vector(list.size());
        boolean bl2 = bl;
        double d = rectangle2D2.getX();
        double d2 = this.getPlot().getOutlineStroke() != null ? (double)((BasicStroke)this.getPlot().getOutlineStroke()).getLineWidth() : 1.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ValueTick valueTick = (ValueTick)iterator.next();
            double d3 = this.valueToJava2D(valueTick.getValue() + 0.5, rectangle2D2, RectangleEdge.LEFT);
            double d4 = this.valueToJava2D(valueTick.getValue() - 0.5, rectangle2D2, RectangleEdge.LEFT);
            if (bl2) {
                graphics2D.setPaint(this.symbolicGridPaint);
            } else {
                graphics2D.setPaint(Color.white);
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d + d2, d3, rectangle2D2.getMaxX() - d - d2, d4 - d3);
            graphics2D.fill(double_);
            this.symbolicGridLineList.add(double_);
            boolean bl3 = bl2 = !bl2;
        }
        graphics2D.setPaintMode();
    }
}

