/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.data.category.CategoryDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class SubCategoryAxis
extends CategoryAxis
implements Cloneable,
Serializable {
    private List subCategories;
    private Font subLabelFont = new Font("SansSerif", 0, 10);
    private transient Paint subLabelPaint = Color.black;

    public SubCategoryAxis(String string) {
        super(string);
        this.subCategories = new ArrayList();
    }

    public void addSubCategory(Comparable comparable) {
        this.subCategories.add(comparable);
    }

    public Font getSubLabelFont() {
        return this.subLabelFont;
    }

    public void setSubLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.subLabelFont = font;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getSubLabelPaint() {
        return this.subLabelPaint;
    }

    public void setSubLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.subLabelPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        if (!this.isVisible()) {
            return axisSpace;
        }
        axisSpace = super.reserveSpace(graphics2D, plot, rectangle2D, rectangleEdge, axisSpace);
        double d = this.getMaxDim(graphics2D, rectangleEdge);
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            axisSpace.add(d, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            axisSpace.add(d, rectangleEdge);
        }
        return axisSpace;
    }

    private double getMaxDim(Graphics2D graphics2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        graphics2D.setFont(this.subLabelFont);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Iterator iterator = this.subCategories.iterator();
        while (iterator.hasNext()) {
            Comparable comparable = (Comparable)iterator.next();
            String string = comparable.toString();
            Rectangle2D rectangle2D = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
            double d2 = 0.0;
            d2 = RectangleEdge.isLeftOrRight(rectangleEdge) ? rectangle2D.getWidth() : rectangle2D.getHeight();
            d = Math.max(d, d2);
        }
        return d;
    }

    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        if (CategoryAxis.logger.isDebugEnabled()) {
            CategoryAxis.logger.debug("Entering draw() method, cursor = " + d);
        }
        if (!this.isVisible()) {
            return new AxisState(d);
        }
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d, rectangle2D2, rectangleEdge);
        }
        AxisState axisState = new AxisState(d);
        axisState = this.drawSubCategoryLabels(graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState, plotRenderingInfo);
        axisState = this.drawCategoryLabels(graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState, plotRenderingInfo);
        axisState = this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        return axisState;
    }

    protected AxisState drawSubCategoryLabels(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, AxisState axisState, PlotRenderingInfo plotRenderingInfo) {
        if (axisState == null) {
            throw new IllegalArgumentException("Null 'state' argument.");
        }
        graphics2D.setFont(this.subLabelFont);
        graphics2D.setPaint(this.subLabelPaint);
        CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        int n = categoryDataset.getColumnCount();
        double d = this.getMaxDim(graphics2D, rectangleEdge);
        int n2 = 0;
        while (n2 < n) {
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            if (rectangleEdge == RectangleEdge.TOP) {
                d2 = this.getCategoryStart(n2, n, rectangle2D2, rectangleEdge);
                d3 = this.getCategoryEnd(n2, n, rectangle2D2, rectangleEdge);
                d5 = axisState.getCursor();
                d4 = d5 - d;
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                d2 = this.getCategoryStart(n2, n, rectangle2D2, rectangleEdge);
                d3 = this.getCategoryEnd(n2, n, rectangle2D2, rectangleEdge);
                d4 = axisState.getCursor();
                d5 = d4 + d;
            } else if (rectangleEdge == RectangleEdge.LEFT) {
                d4 = this.getCategoryStart(n2, n, rectangle2D2, rectangleEdge);
                d5 = this.getCategoryEnd(n2, n, rectangle2D2, rectangleEdge);
                d3 = axisState.getCursor();
                d2 = d3 - d;
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                d4 = this.getCategoryStart(n2, n, rectangle2D2, rectangleEdge);
                d5 = this.getCategoryEnd(n2, n, rectangle2D2, rectangleEdge);
                d2 = axisState.getCursor();
                d3 = d2 + d;
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
            int n3 = this.subCategories.size();
            float f = (float)((d3 - d2) / (double)n3);
            float f2 = (float)((d5 - d4) / (double)n3);
            float f3 = 0.0f;
            float f4 = 0.0f;
            int n4 = 0;
            while (n4 < n3) {
                if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
                    f3 = (float)(d2 + ((double)n4 + 0.5) * (double)f);
                    f4 = (float)double_.getCenterY();
                } else {
                    f3 = (float)double_.getCenterX();
                    f4 = (float)(d4 + ((double)n4 + 0.5) * (double)f2);
                }
                String string = this.subCategories.get(n4).toString();
                RefineryUtilities.drawRotatedString(string, graphics2D, f3, f4, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
                ++n4;
            }
            ++n2;
        }
        if (rectangleEdge.equals(RectangleEdge.TOP)) {
            double d6 = d;
            axisState.cursorUp(d6);
        } else if (rectangleEdge.equals(RectangleEdge.BOTTOM)) {
            double d7 = d;
            axisState.cursorDown(d7);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            double d8 = d;
            axisState.cursorLeft(d8);
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            double d9 = d;
            axisState.cursorRight(d9);
        }
        return axisState;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SubCategoryAxis && super.equals(object)) {
            SubCategoryAxis subCategoryAxis = (SubCategoryAxis)object;
            if (!this.subCategories.equals(subCategoryAxis.subCategories)) {
                return false;
            }
            if (!this.subLabelFont.equals(subCategoryAxis.subLabelFont)) {
                return false;
            }
            return this.subLabelPaint.equals(subCategoryAxis.subLabelPaint);
        }
        return false;
    }
}

