/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryLabelWidthType;
import org.jfree.text.TextBlockAnchor;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class CategoryLabelPositions
implements Serializable {
    public static final CategoryLabelPositions STANDARD = new CategoryLabelPositions(new CategoryLabelPosition(RectangleAnchor.BOTTOM, TextBlockAnchor.BOTTOM_CENTER), new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.TOP_CENTER), new CategoryLabelPosition(RectangleAnchor.RIGHT, TextBlockAnchor.CENTER_RIGHT, CategoryLabelWidthType.RANGE, 0.3f), new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.CENTER_LEFT, CategoryLabelWidthType.RANGE, 0.3f));
    public static final CategoryLabelPositions UP_90 = new CategoryLabelPositions(new CategoryLabelPosition(RectangleAnchor.BOTTOM, TextBlockAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, -1.5707963267948966, CategoryLabelWidthType.RANGE, 1.0f), new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER_RIGHT, TextAnchor.CENTER_RIGHT, -1.5707963267948966, CategoryLabelWidthType.RANGE, 1.0f), new CategoryLabelPosition(RectangleAnchor.RIGHT, TextBlockAnchor.BOTTOM_CENTER, TextAnchor.BOTTOM_CENTER, -1.5707963267948966, CategoryLabelWidthType.CATEGORY, 0.9f), new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.TOP_CENTER, TextAnchor.TOP_CENTER, -1.5707963267948966, CategoryLabelWidthType.CATEGORY, 0.9f));
    public static final CategoryLabelPositions DOWN_90 = new CategoryLabelPositions(new CategoryLabelPosition(RectangleAnchor.BOTTOM, TextBlockAnchor.CENTER_RIGHT, TextAnchor.CENTER_RIGHT, 1.5707963267948966, CategoryLabelWidthType.RANGE, 0.3f), new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, 1.5707963267948966, CategoryLabelWidthType.RANGE, 0.3f), new CategoryLabelPosition(RectangleAnchor.RIGHT, TextBlockAnchor.TOP_CENTER, TextAnchor.TOP_CENTER, 1.5707963267948966, CategoryLabelWidthType.CATEGORY, 0.9f), new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.BOTTOM_CENTER, TextAnchor.BOTTOM_CENTER, 1.5707963267948966, CategoryLabelWidthType.CATEGORY, 0.9f));
    public static final CategoryLabelPositions UP_45 = CategoryLabelPositions.createUpRotationLabelPositions(0.7853981633974483);
    public static final CategoryLabelPositions DOWN_45 = CategoryLabelPositions.createDownRotationLabelPositions(0.7853981633974483);
    private CategoryLabelPosition positionForAxisAtTop;
    private CategoryLabelPosition positionForAxisAtBottom;
    private CategoryLabelPosition positionForAxisAtLeft;
    private CategoryLabelPosition positionForAxisAtRight;

    public static CategoryLabelPositions createUpRotationLabelPositions(double d) {
        return new CategoryLabelPositions(new CategoryLabelPosition(RectangleAnchor.BOTTOM, TextBlockAnchor.BOTTOM_LEFT, TextAnchor.BOTTOM_LEFT, -d, CategoryLabelWidthType.RANGE, 0.5f), new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.TOP_RIGHT, TextAnchor.TOP_RIGHT, -d, CategoryLabelWidthType.RANGE, 0.5f), new CategoryLabelPosition(RectangleAnchor.RIGHT, TextBlockAnchor.BOTTOM_RIGHT, TextAnchor.BOTTOM_RIGHT, -d, CategoryLabelWidthType.RANGE, 0.5f), new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, -d, CategoryLabelWidthType.RANGE, 0.5f));
    }

    public static CategoryLabelPositions createDownRotationLabelPositions(double d) {
        return new CategoryLabelPositions(new CategoryLabelPosition(RectangleAnchor.BOTTOM, TextBlockAnchor.BOTTOM_RIGHT, TextAnchor.BOTTOM_RIGHT, d, CategoryLabelWidthType.RANGE, 0.5f), new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, d, CategoryLabelWidthType.RANGE, 0.5f), new CategoryLabelPosition(RectangleAnchor.RIGHT, TextBlockAnchor.TOP_RIGHT, TextAnchor.TOP_RIGHT, d, CategoryLabelWidthType.RANGE, 0.5f), new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.BOTTOM_LEFT, TextAnchor.BOTTOM_LEFT, d, CategoryLabelWidthType.RANGE, 0.5f));
    }

    public CategoryLabelPositions() {
        this.positionForAxisAtTop = new CategoryLabelPosition();
        this.positionForAxisAtBottom = new CategoryLabelPosition();
        this.positionForAxisAtLeft = new CategoryLabelPosition();
        this.positionForAxisAtRight = new CategoryLabelPosition();
    }

    public CategoryLabelPositions(CategoryLabelPosition categoryLabelPosition, CategoryLabelPosition categoryLabelPosition2, CategoryLabelPosition categoryLabelPosition3, CategoryLabelPosition categoryLabelPosition4) {
        if (categoryLabelPosition == null) {
            throw new IllegalArgumentException("Null 'top' argument.");
        }
        if (categoryLabelPosition2 == null) {
            throw new IllegalArgumentException("Null 'bottom' argument.");
        }
        if (categoryLabelPosition3 == null) {
            throw new IllegalArgumentException("Null 'left' argument.");
        }
        if (categoryLabelPosition4 == null) {
            throw new IllegalArgumentException("Null 'right' argument.");
        }
        this.positionForAxisAtTop = categoryLabelPosition;
        this.positionForAxisAtBottom = categoryLabelPosition2;
        this.positionForAxisAtLeft = categoryLabelPosition3;
        this.positionForAxisAtRight = categoryLabelPosition4;
    }

    public CategoryLabelPosition getLabelPosition(RectangleEdge rectangleEdge) {
        CategoryLabelPosition categoryLabelPosition = null;
        if (rectangleEdge == RectangleEdge.TOP) {
            categoryLabelPosition = this.positionForAxisAtTop;
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            categoryLabelPosition = this.positionForAxisAtBottom;
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            categoryLabelPosition = this.positionForAxisAtLeft;
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            categoryLabelPosition = this.positionForAxisAtRight;
        }
        return categoryLabelPosition;
    }

    public static CategoryLabelPositions replaceTopPosition(CategoryLabelPositions categoryLabelPositions, CategoryLabelPosition categoryLabelPosition) {
        if (categoryLabelPositions == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        if (categoryLabelPosition == null) {
            throw new IllegalArgumentException("Null 'top' argument.");
        }
        return new CategoryLabelPositions(categoryLabelPosition, categoryLabelPositions.getLabelPosition(RectangleEdge.BOTTOM), categoryLabelPositions.getLabelPosition(RectangleEdge.LEFT), categoryLabelPositions.getLabelPosition(RectangleEdge.RIGHT));
    }

    public static CategoryLabelPositions replaceBottomPosition(CategoryLabelPositions categoryLabelPositions, CategoryLabelPosition categoryLabelPosition) {
        if (categoryLabelPositions == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        if (categoryLabelPosition == null) {
            throw new IllegalArgumentException("Null 'bottom' argument.");
        }
        return new CategoryLabelPositions(categoryLabelPositions.getLabelPosition(RectangleEdge.TOP), categoryLabelPosition, categoryLabelPositions.getLabelPosition(RectangleEdge.LEFT), categoryLabelPositions.getLabelPosition(RectangleEdge.RIGHT));
    }

    public static CategoryLabelPositions replaceLeftPosition(CategoryLabelPositions categoryLabelPositions, CategoryLabelPosition categoryLabelPosition) {
        if (categoryLabelPositions == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        if (categoryLabelPosition == null) {
            throw new IllegalArgumentException("Null 'left' argument.");
        }
        return new CategoryLabelPositions(categoryLabelPositions.getLabelPosition(RectangleEdge.TOP), categoryLabelPositions.getLabelPosition(RectangleEdge.BOTTOM), categoryLabelPosition, categoryLabelPositions.getLabelPosition(RectangleEdge.RIGHT));
    }

    public static CategoryLabelPositions replaceRightPosition(CategoryLabelPositions categoryLabelPositions, CategoryLabelPosition categoryLabelPosition) {
        if (categoryLabelPositions == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        if (categoryLabelPosition == null) {
            throw new IllegalArgumentException("Null 'right' argument.");
        }
        return new CategoryLabelPositions(categoryLabelPositions.getLabelPosition(RectangleEdge.TOP), categoryLabelPositions.getLabelPosition(RectangleEdge.BOTTOM), categoryLabelPositions.getLabelPosition(RectangleEdge.LEFT), categoryLabelPosition);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CategoryLabelPositions)) {
            return false;
        }
        CategoryLabelPositions categoryLabelPositions = (CategoryLabelPositions)object;
        boolean bl = this.positionForAxisAtTop.equals(categoryLabelPositions.positionForAxisAtTop);
        boolean bl2 = this.positionForAxisAtBottom.equals(categoryLabelPositions.positionForAxisAtBottom);
        boolean bl3 = this.positionForAxisAtLeft.equals(categoryLabelPositions.positionForAxisAtLeft);
        boolean bl4 = this.positionForAxisAtRight.equals(categoryLabelPositions.positionForAxisAtRight);
        return bl && bl2 && bl3 && bl4;
    }
}

