/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import org.jfree.chart.axis.CategoryLabelWidthType;
import org.jfree.text.TextBlockAnchor;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

public class CategoryLabelPosition
implements Serializable {
    private RectangleAnchor categoryAnchor;
    private TextBlockAnchor labelAnchor;
    private TextAnchor rotationAnchor;
    private double angle;
    private CategoryLabelWidthType widthType;
    private float widthRatio;

    public CategoryLabelPosition() {
        this(RectangleAnchor.CENTER, TextBlockAnchor.BOTTOM_CENTER, TextAnchor.CENTER, 0.0, CategoryLabelWidthType.CATEGORY, 0.95f);
    }

    public CategoryLabelPosition(RectangleAnchor rectangleAnchor, TextBlockAnchor textBlockAnchor) {
        this(rectangleAnchor, textBlockAnchor, TextAnchor.CENTER, 0.0, CategoryLabelWidthType.CATEGORY, 0.95f);
    }

    public CategoryLabelPosition(RectangleAnchor rectangleAnchor, TextBlockAnchor textBlockAnchor, CategoryLabelWidthType categoryLabelWidthType, float f) {
        this(rectangleAnchor, textBlockAnchor, TextAnchor.CENTER, 0.0, categoryLabelWidthType, f);
    }

    public CategoryLabelPosition(RectangleAnchor rectangleAnchor, TextBlockAnchor textBlockAnchor, TextAnchor textAnchor, double d) {
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'categoryAnchor' argument.");
        }
        if (textBlockAnchor == null) {
            throw new IllegalArgumentException("Null 'labelAnchor' argument.");
        }
        if (textAnchor == null) {
            throw new IllegalArgumentException("Null 'rotationAnchor' argument.");
        }
        this.categoryAnchor = rectangleAnchor;
        this.labelAnchor = textBlockAnchor;
        this.rotationAnchor = textAnchor;
        this.angle = d;
        this.widthType = CategoryLabelWidthType.CATEGORY;
        this.widthRatio = 0.9f;
    }

    public CategoryLabelPosition(RectangleAnchor rectangleAnchor, TextBlockAnchor textBlockAnchor, TextAnchor textAnchor, double d, CategoryLabelWidthType categoryLabelWidthType, float f) {
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'categoryAnchor' argument.");
        }
        if (textBlockAnchor == null) {
            throw new IllegalArgumentException("Null 'labelAnchor' argument.");
        }
        if (textAnchor == null) {
            throw new IllegalArgumentException("Null 'rotationAnchor' argument.");
        }
        if (categoryLabelWidthType == null) {
            throw new IllegalArgumentException("Null 'widthType' argument.");
        }
        this.categoryAnchor = rectangleAnchor;
        this.labelAnchor = textBlockAnchor;
        this.rotationAnchor = textAnchor;
        this.angle = d;
        this.widthType = categoryLabelWidthType;
        this.widthRatio = f;
    }

    public RectangleAnchor getCategoryAnchor() {
        return this.categoryAnchor;
    }

    public TextBlockAnchor getLabelAnchor() {
        return this.labelAnchor;
    }

    public TextAnchor getRotationAnchor() {
        return this.rotationAnchor;
    }

    public double getAngle() {
        return this.angle;
    }

    public CategoryLabelWidthType getWidthType() {
        return this.widthType;
    }

    public float getWidthRatio() {
        return this.widthRatio;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CategoryLabelPosition) {
            boolean bl;
            CategoryLabelPosition categoryLabelPosition = (CategoryLabelPosition)object;
            boolean bl2 = this.categoryAnchor.equals(categoryLabelPosition.categoryAnchor);
            boolean bl3 = this.labelAnchor.equals(categoryLabelPosition.labelAnchor);
            boolean bl4 = this.rotationAnchor.equals(categoryLabelPosition.rotationAnchor);
            boolean bl5 = bl = this.angle == categoryLabelPosition.angle;
            return bl2 && bl3 && bl4 && bl;
        }
        return false;
    }
}

