/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.CategoryLabelWidthType;
import org.jfree.chart.axis.CategoryTick;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.TickLabelEntity;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Size2D;
import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.jfree.util.ObjectUtils;
import org.jfree.util.ShapeUtils;

public class CategoryAxis
extends Axis
implements Cloneable,
Serializable {
    public static final double DEFAULT_AXIS_MARGIN = 0.05;
    public static final double DEFAULT_CATEGORY_MARGIN = 0.2;
    private double lowerMargin = 0.05;
    private double upperMargin = 0.05;
    private double categoryMargin = 0.2;
    private int maxCategoryLabelLines = 1;
    private float maxCategoryLabelWidthRatio = 0.0f;
    private int categoryLabelPositionOffset;
    private CategoryLabelPositions categoryLabelPositions;
    private Map categoryLabelToolTips;
    protected static final LogContext logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.axis.CategoryAxis");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Log.createContext(clazz);
    }

    public CategoryAxis() {
        this(null);
    }

    public CategoryAxis(String string) {
        super(string);
        this.setTickMarksVisible(false);
        this.categoryLabelPositionOffset = 4;
        this.categoryLabelPositions = CategoryLabelPositions.STANDARD;
        this.categoryLabelToolTips = new HashMap();
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double d) {
        this.lowerMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double d) {
        this.upperMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getCategoryMargin() {
        return this.categoryMargin;
    }

    public void setCategoryMargin(double d) {
        this.categoryMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public int getMaxCategoryLabelLines() {
        return this.maxCategoryLabelLines;
    }

    public void setMaxCategoryLabelLines(int n) {
        this.maxCategoryLabelLines = n;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public float getMaxCategoryLabelWidthRatio() {
        return this.maxCategoryLabelWidthRatio;
    }

    public void setMaxCategoryLabelWidthRatio(float f) {
        this.maxCategoryLabelWidthRatio = f;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public int getCategoryLabelPositionOffset() {
        return this.categoryLabelPositionOffset;
    }

    public void setCategoryLabelPositionOffset(int n) {
        this.categoryLabelPositionOffset = n;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public CategoryLabelPositions getCategoryLabelPositions() {
        return this.categoryLabelPositions;
    }

    public void setCategoryLabelPositions(CategoryLabelPositions categoryLabelPositions) {
        if (categoryLabelPositions == null) {
            throw new IllegalArgumentException("Null 'positions' argument.");
        }
        this.categoryLabelPositions = categoryLabelPositions;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void addCategoryLabelToolTip(Comparable comparable, String string) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        this.categoryLabelToolTips.put(comparable, string);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void removeCategoryLabelToolTip(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        this.categoryLabelToolTips.remove(comparable);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void clearCategoryLabelToolTips() {
        this.categoryLabelToolTips.clear();
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getCategoryJava2DCoordinate(CategoryAnchor categoryAnchor, int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        if (categoryAnchor == CategoryAnchor.START) {
            d = this.getCategoryStart(n, n2, rectangle2D, rectangleEdge);
        } else if (categoryAnchor == CategoryAnchor.MIDDLE) {
            d = this.getCategoryMiddle(n, n2, rectangle2D, rectangleEdge);
        } else if (categoryAnchor == CategoryAnchor.END) {
            d = this.getCategoryEnd(n, n2, rectangle2D, rectangleEdge);
        }
        return d;
    }

    public double getCategoryStart(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d = rectangle2D.getX() + rectangle2D.getWidth() * this.getLowerMargin();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d = rectangle2D.getMinY() + rectangle2D.getHeight() * this.getLowerMargin();
        }
        double d2 = this.calculateCategorySize(n2, rectangle2D, rectangleEdge);
        double d3 = this.calculateCategoryGapSize(n2, rectangle2D, rectangleEdge);
        return d += (double)n * (d2 + d3);
    }

    public double getCategoryMiddle(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return this.getCategoryStart(n, n2, rectangle2D, rectangleEdge) + this.calculateCategorySize(n2, rectangle2D, rectangleEdge) / 2.0;
    }

    public double getCategoryEnd(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return this.getCategoryStart(n, n2, rectangle2D, rectangleEdge) + this.calculateCategorySize(n2, rectangle2D, rectangleEdge);
    }

    protected double calculateCategorySize(int n, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        double d2 = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d2 = rectangle2D.getWidth();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d2 = rectangle2D.getHeight();
        }
        if (n > 1) {
            d = d2 * (1.0 - this.getLowerMargin() - this.getUpperMargin() - this.getCategoryMargin());
            d /= (double)n;
        } else {
            d = d2 * (1.0 - this.getLowerMargin() - this.getUpperMargin());
        }
        return d;
    }

    protected double calculateCategoryGapSize(int n, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        double d2 = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d2 = rectangle2D.getWidth();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d2 = rectangle2D.getHeight();
        }
        if (n > 1) {
            d = d2 * this.getCategoryMargin() / (double)(n - 1);
        }
        return d;
    }

    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        Object object;
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        if (!this.isVisible()) {
            return axisSpace;
        }
        double d = 0.0;
        double d2 = 0.0;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            object = new AxisState();
            this.refreshTicks(graphics2D, (AxisState)object, rectangle2D, rectangle2D, rectangleEdge);
            if (rectangleEdge == RectangleEdge.TOP) {
                d = ((AxisState)object).getMax();
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                d = ((AxisState)object).getMax();
            } else if (rectangleEdge == RectangleEdge.LEFT) {
                d2 = ((AxisState)object).getMax();
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                d2 = ((AxisState)object).getMax();
            }
        }
        object = this.getLabelEnclosure(graphics2D, rectangleEdge);
        double d3 = 0.0;
        double d4 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d3 = ((RectangularShape)object).getHeight();
            axisSpace.add(d3 + d + (double)this.categoryLabelPositionOffset, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d4 = ((RectangularShape)object).getWidth();
            axisSpace.add(d4 + d2 + (double)this.categoryLabelPositionOffset, rectangleEdge);
        }
        return axisSpace;
    }

    public void configure() {
    }

    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug("Entering draw() method, cursor = " + d);
        }
        if (!this.isVisible()) {
            return new AxisState(d);
        }
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d, rectangle2D2, rectangleEdge);
        }
        AxisState axisState = new AxisState(d);
        axisState = this.drawCategoryLabels(graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState, plotRenderingInfo);
        axisState = this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        return axisState;
    }

    protected AxisState drawCategoryLabels(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, AxisState axisState, PlotRenderingInfo plotRenderingInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug("Entering drawCategoryLabels() method, cursor = " + axisState.getCursor());
        }
        if (axisState == null) {
            throw new IllegalArgumentException("Null 'state' argument.");
        }
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            graphics2D.setPaint(this.getTickLabelPaint());
            List list = this.refreshTicks(graphics2D, axisState, rectangle2D, rectangle2D2, rectangleEdge);
            axisState.setTicks(list);
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                EntityCollection entityCollection;
                CategoryTick categoryTick = (CategoryTick)iterator.next();
                graphics2D.setPaint(this.getTickLabelPaint());
                CategoryLabelPosition categoryLabelPosition = this.categoryLabelPositions.getLabelPosition(rectangleEdge);
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                if (rectangleEdge == RectangleEdge.TOP) {
                    d = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d2 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d4 = axisState.getCursor() - (double)this.categoryLabelPositionOffset;
                    d3 = d4 - axisState.getMax();
                } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                    d = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d2 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d3 = axisState.getCursor() + (double)this.categoryLabelPositionOffset;
                    d4 = d3 + axisState.getMax();
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    d3 = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d4 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d2 = axisState.getCursor() - (double)this.categoryLabelPositionOffset;
                    d = d2 - axisState.getMax();
                } else if (rectangleEdge == RectangleEdge.RIGHT) {
                    d3 = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d4 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d = axisState.getCursor() + (double)this.categoryLabelPositionOffset;
                    d2 = d - axisState.getMax();
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
                double[] dArray = RectangleAnchor.coordinates(double_, categoryLabelPosition.getCategoryAnchor());
                TextBlock textBlock = categoryTick.getLabel();
                textBlock.draw(graphics2D, (float)dArray[0], (float)dArray[1], categoryLabelPosition.getLabelAnchor(), (float)dArray[0], (float)dArray[1], categoryLabelPosition.getAngle());
                Shape shape = textBlock.calculateBounds(graphics2D, (float)dArray[0], (float)dArray[1], categoryLabelPosition.getLabelAnchor(), (float)dArray[0], (float)dArray[1], categoryLabelPosition.getAngle());
                if (plotRenderingInfo != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
                    String string = (String)this.categoryLabelToolTips.get(categoryTick.getCategory());
                    entityCollection.addEntity(new TickLabelEntity(shape, string, null));
                }
                ++n;
            }
            if (rectangleEdge.equals(RectangleEdge.TOP)) {
                double d = axisState.getMax();
                axisState.cursorUp(d);
            } else if (rectangleEdge.equals(RectangleEdge.BOTTOM)) {
                double d = axisState.getMax();
                axisState.cursorDown(d);
            } else if (rectangleEdge == RectangleEdge.LEFT) {
                double d = axisState.getMax();
                axisState.cursorLeft(d);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                double d = axisState.getMax();
                axisState.cursorRight(d);
            }
        }
        return axisState;
    }

    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        ArrayList<CategoryTick> arrayList = new ArrayList<CategoryTick>();
        if (rectangle2D2.getHeight() <= 0.0 || rectangle2D2.getWidth() < 0.0) {
            return arrayList;
        }
        CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
        List list = categoryPlot.getCategories();
        double d = 0.0;
        if (list != null) {
            CategoryLabelPosition categoryLabelPosition = this.categoryLabelPositions.getLabelPosition(rectangleEdge);
            float f = this.maxCategoryLabelWidthRatio;
            if ((double)f <= 0.0) {
                f = categoryLabelPosition.getWidthRatio();
            }
            float f2 = 0.0f;
            f2 = categoryLabelPosition.getWidthType() == CategoryLabelWidthType.CATEGORY ? (float)this.calculateCategorySize(list.size(), rectangle2D2, rectangleEdge) : (RectangleEdge.isLeftOrRight(rectangleEdge) ? (float)rectangle2D2.getWidth() : (float)rectangle2D2.getHeight());
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Comparable comparable = (Comparable)iterator.next();
                TextBlock textBlock = this.createLabel(comparable, f2 * f, rectangleEdge, graphics2D);
                if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                    d = Math.max(d, this.calculateTextBlockHeight(textBlock, categoryLabelPosition, graphics2D));
                } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                    d = Math.max(d, this.calculateTextBlockWidth(textBlock, categoryLabelPosition, graphics2D));
                }
                CategoryTick categoryTick = new CategoryTick(comparable, textBlock, categoryLabelPosition.getLabelAnchor(), categoryLabelPosition.getRotationAnchor(), categoryLabelPosition.getAngle());
                arrayList.add(categoryTick);
                ++n;
            }
        }
        axisState.setMax(d);
        return arrayList;
    }

    protected TextBlock createLabel(Comparable comparable, float f, RectangleEdge rectangleEdge, Graphics2D graphics2D) {
        TextBlock textBlock = TextUtilities.createTextBlock(comparable.toString(), this.getTickLabelFont(), this.getTickLabelPaint(), f, this.maxCategoryLabelLines, new G2TextMeasurer(graphics2D));
        return textBlock;
    }

    protected double calculateTextBlockWidth(TextBlock textBlock, CategoryLabelPosition categoryLabelPosition, Graphics2D graphics2D) {
        Insets insets = this.getTickLabelInsets();
        Size2D size2D = textBlock.calculateDimensions(graphics2D);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, size2D.getWidth(), size2D.getHeight());
        Shape shape = ShapeUtils.rotateShape(double_, categoryLabelPosition.getAngle(), 0.0f, 0.0f);
        double d = shape.getBounds2D().getWidth() + (double)insets.top + (double)insets.bottom;
        return d;
    }

    protected double calculateTextBlockHeight(TextBlock textBlock, CategoryLabelPosition categoryLabelPosition, Graphics2D graphics2D) {
        Insets insets = this.getTickLabelInsets();
        Size2D size2D = textBlock.calculateDimensions(graphics2D);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, size2D.getWidth(), size2D.getHeight());
        Shape shape = ShapeUtils.rotateShape(double_, categoryLabelPosition.getAngle(), 0.0f, 0.0f);
        double d = shape.getBounds2D().getHeight() + (double)insets.top + (double)insets.bottom;
        return d;
    }

    public Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        return object;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CategoryAxis && super.equals(object)) {
            CategoryAxis categoryAxis = (CategoryAxis)object;
            boolean bl = categoryAxis.lowerMargin == this.lowerMargin;
            boolean bl2 = categoryAxis.upperMargin == this.upperMargin;
            boolean bl3 = categoryAxis.categoryMargin == this.categoryMargin;
            boolean bl4 = categoryAxis.maxCategoryLabelWidthRatio == this.maxCategoryLabelWidthRatio;
            boolean bl5 = categoryAxis.categoryLabelPositionOffset == this.categoryLabelPositionOffset;
            boolean bl6 = ObjectUtils.equal(categoryAxis.categoryLabelPositions, this.categoryLabelPositions);
            boolean bl7 = ObjectUtils.equal(categoryAxis.categoryLabelToolTips, this.categoryLabelToolTips);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public boolean isVerticalCategoryLabels() {
        return false;
    }

    public void setVerticalCategoryLabels(boolean bl) {
        this.categoryLabelPositions = bl ? CategoryLabelPositions.UP_90 : CategoryLabelPositions.STANDARD;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean getSkipCategoryLabelsToFit() {
        return false;
    }

    public void setSkipCategoryLabelsToFit(boolean bl) {
    }

    public CategoryLabelPosition getTopCategoryLabelPosition() {
        return this.getCategoryLabelPositions().getLabelPosition(RectangleEdge.TOP);
    }

    public void setTopCategoryLabelPosition(CategoryLabelPosition categoryLabelPosition) {
        this.setCategoryLabelPositions(new CategoryLabelPositions(categoryLabelPosition, this.categoryLabelPositions.getLabelPosition(RectangleEdge.BOTTOM), this.categoryLabelPositions.getLabelPosition(RectangleEdge.LEFT), this.categoryLabelPositions.getLabelPosition(RectangleEdge.RIGHT)));
    }

    public CategoryLabelPosition getBottomCategoryLabelPosition() {
        return this.getCategoryLabelPositions().getLabelPosition(RectangleEdge.BOTTOM);
    }

    public void setBottomCategoryLabelPosition(CategoryLabelPosition categoryLabelPosition) {
        this.setCategoryLabelPositions(new CategoryLabelPositions(this.categoryLabelPositions.getLabelPosition(RectangleEdge.TOP), categoryLabelPosition, this.categoryLabelPositions.getLabelPosition(RectangleEdge.LEFT), this.categoryLabelPositions.getLabelPosition(RectangleEdge.RIGHT)));
    }

    public CategoryLabelPosition getLeftCategoryLabelPosition() {
        return this.getCategoryLabelPositions().getLabelPosition(RectangleEdge.LEFT);
    }

    public void setLeftCategoryLabelPosition(CategoryLabelPosition categoryLabelPosition) {
        this.setCategoryLabelPositions(new CategoryLabelPositions(this.categoryLabelPositions.getLabelPosition(RectangleEdge.TOP), this.categoryLabelPositions.getLabelPosition(RectangleEdge.BOTTOM), categoryLabelPosition, this.categoryLabelPositions.getLabelPosition(RectangleEdge.RIGHT)));
    }

    public CategoryLabelPosition getRightCategoryLabelPosition() {
        return this.getCategoryLabelPositions().getLabelPosition(RectangleEdge.RIGHT);
    }

    public void setRightCategoryLabelPosition(CategoryLabelPosition categoryLabelPosition) {
        this.setCategoryLabelPositions(new CategoryLabelPositions(this.categoryLabelPositions.getLabelPosition(RectangleEdge.TOP), this.categoryLabelPositions.getLabelPosition(RectangleEdge.BOTTOM), this.categoryLabelPositions.getLabelPosition(RectangleEdge.LEFT), categoryLabelPosition));
    }
}

