/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.jfree.util.ObjectUtils;

public abstract class Axis
implements Cloneable,
Serializable {
    public static final boolean DEFAULT_AXIS_VISIBLE = true;
    public static final Font DEFAULT_AXIS_LABEL_FONT = new Font("SansSerif", 0, 12);
    public static final Paint DEFAULT_AXIS_LABEL_PAINT = Color.black;
    public static final Insets DEFAULT_AXIS_LABEL_INSETS = new Insets(3, 3, 3, 3);
    public static final Paint DEFAULT_AXIS_LINE_PAINT = Color.gray;
    public static final Stroke DEFAULT_AXIS_LINE_STROKE = new BasicStroke(1.0f);
    public static final boolean DEFAULT_TICK_LABELS_VISIBLE = true;
    public static final Font DEFAULT_TICK_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_TICK_LABEL_PAINT = Color.black;
    public static final Insets DEFAULT_TICK_LABEL_INSETS = new Insets(2, 4, 2, 4);
    public static final boolean DEFAULT_TICK_MARKS_VISIBLE = true;
    public static final Stroke DEFAULT_TICK_MARK_STROKE = new BasicStroke(1.0f);
    public static final Paint DEFAULT_TICK_MARK_PAINT = Color.gray;
    public static final float DEFAULT_TICK_MARK_INSIDE_LENGTH = 0.0f;
    public static final float DEFAULT_TICK_MARK_OUTSIDE_LENGTH = 2.0f;
    private boolean visible;
    private String label;
    private Font labelFont;
    private transient Paint labelPaint;
    private Insets labelInsets;
    private double labelAngle;
    private boolean axisLineVisible;
    private transient Stroke axisLineStroke;
    private transient Paint axisLinePaint;
    private boolean tickLabelsVisible;
    private Font tickLabelFont;
    private transient Paint tickLabelPaint;
    private Insets tickLabelInsets;
    private boolean tickMarksVisible;
    private float tickMarkInsideLength;
    private float tickMarkOutsideLength;
    private transient Stroke tickMarkStroke;
    private transient Paint tickMarkPaint;
    private double fixedDimension;
    private transient Plot plot;
    private transient EventListenerList listenerList;
    protected static final LogContext LOGGER;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.axis.Axis");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Log.createContext(clazz);
    }

    protected Axis(String string) {
        this.label = string;
        this.visible = true;
        this.labelFont = DEFAULT_AXIS_LABEL_FONT;
        this.labelPaint = DEFAULT_AXIS_LABEL_PAINT;
        this.labelInsets = DEFAULT_AXIS_LABEL_INSETS;
        this.labelAngle = 0.0;
        this.axisLineVisible = true;
        this.axisLinePaint = DEFAULT_AXIS_LINE_PAINT;
        this.axisLineStroke = DEFAULT_AXIS_LINE_STROKE;
        this.tickLabelsVisible = true;
        this.tickLabelFont = DEFAULT_TICK_LABEL_FONT;
        this.tickLabelPaint = DEFAULT_TICK_LABEL_PAINT;
        this.tickLabelInsets = DEFAULT_TICK_LABEL_INSETS;
        this.tickMarksVisible = true;
        this.tickMarkStroke = DEFAULT_TICK_MARK_STROKE;
        this.tickMarkPaint = DEFAULT_TICK_MARK_PAINT;
        this.tickMarkInsideLength = 0.0f;
        this.tickMarkOutsideLength = 2.0f;
        this.plot = null;
        this.listenerList = new EventListenerList();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        String string2 = this.label;
        if (string2 != null) {
            if (!string2.equals(string)) {
                this.label = string;
                this.notifyListeners(new AxisChangeEvent(this));
            }
        } else if (string != null) {
            this.label = string;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setLabelPaint(...): null not permitted.");
        }
        this.labelPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Insets getLabelInsets() {
        return this.labelInsets;
    }

    public void setLabelInsets(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("Null 'insets' argument.");
        }
        if (!insets.equals(this.labelInsets)) {
            this.labelInsets = insets;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public double getLabelAngle() {
        return this.labelAngle;
    }

    public void setLabelAngle(double d) {
        this.labelAngle = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isAxisLineVisible() {
        return this.axisLineVisible;
    }

    public void setAxisLineVisible(boolean bl) {
        this.axisLineVisible = bl;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getAxisLinePaint() {
        return this.axisLinePaint;
    }

    public void setAxisLinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.axisLinePaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Stroke getAxisLineStroke() {
        return this.axisLineStroke;
    }

    public void setAxisLineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.axisLineStroke = stroke;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean bl) {
        if (bl != this.tickLabelsVisible) {
            this.tickLabelsVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (!this.tickLabelFont.equals(font)) {
            this.tickLabelFont = font;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.tickLabelPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Insets getTickLabelInsets() {
        return this.tickLabelInsets;
    }

    public void setTickLabelInsets(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("Null 'insets' argument.");
        }
        if (!this.tickLabelInsets.equals(insets)) {
            this.tickLabelInsets = insets;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isTickMarksVisible() {
        return this.tickMarksVisible;
    }

    public void setTickMarksVisible(boolean bl) {
        if (bl != this.tickMarksVisible) {
            this.tickMarksVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public float getTickMarkInsideLength() {
        return this.tickMarkInsideLength;
    }

    public void setTickMarkInsideLength(float f) {
        this.tickMarkInsideLength = f;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public float getTickMarkOutsideLength() {
        return this.tickMarkOutsideLength;
    }

    public void setTickMarkOutsideLength(float f) {
        this.tickMarkOutsideLength = f;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Stroke getTickMarkStroke() {
        return this.tickMarkStroke;
    }

    public void setTickMarkStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        if (!this.tickMarkStroke.equals(stroke)) {
            this.tickMarkStroke = stroke;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getTickMarkPaint() {
        return this.tickMarkPaint;
    }

    public void setTickMarkPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.tickMarkPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        this.plot = plot;
        this.configure();
    }

    public double getFixedDimension() {
        return this.fixedDimension;
    }

    public void setFixedDimension(double d) {
        this.fixedDimension = d;
    }

    public abstract void configure();

    public abstract AxisSpace reserveSpace(Graphics2D var1, Plot var2, Rectangle2D var3, RectangleEdge var4, AxisSpace var5);

    public abstract AxisState draw(Graphics2D var1, double var2, Rectangle2D var4, Rectangle2D var5, RectangleEdge var6, PlotRenderingInfo var7);

    public abstract List refreshTicks(Graphics2D var1, AxisState var2, Rectangle2D var3, Rectangle2D var4, RectangleEdge var5);

    public void addChangeListener(AxisChangeListener axisChangeListener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jfree.chart.event.AxisChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, axisChangeListener);
    }

    public void removeChangeListener(AxisChangeListener axisChangeListener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jfree.chart.event.AxisChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, axisChangeListener);
    }

    protected void notifyListeners(AxisChangeEvent axisChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            Object object = objectArray[n];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.jfree.chart.event.AxisChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((AxisChangeListener)objectArray[n + 1]).axisChanged(axisChangeEvent);
            }
            n -= 2;
        }
    }

    protected Rectangle2D getLabelEnclosure(Graphics2D graphics2D, RectangleEdge rectangleEdge) {
        Rectangle2D rectangle2D = new Rectangle2D.Double();
        String string = this.getLabel();
        if (string != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.getLabelFont());
            Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
            Insets insets = this.getLabelInsets();
            rectangle2D2.setRect(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() + (double)insets.left + (double)insets.right, rectangle2D2.getHeight() + (double)insets.top + (double)insets.bottom);
            double d = this.getLabelAngle();
            if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                d -= 1.5707963267948966;
            }
            double d2 = rectangle2D2.getCenterX();
            double d3 = rectangle2D2.getCenterY();
            AffineTransform affineTransform = AffineTransform.getRotateInstance(d, d2, d3);
            Shape shape = affineTransform.createTransformedShape(rectangle2D2);
            rectangle2D = shape.getBounds2D();
        }
        return rectangle2D;
    }

    protected AxisState drawLabel(String string, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, AxisState axisState) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entering drawLabel() method, cursor = " + axisState.getCursor());
        }
        if (axisState == null) {
            throw new IllegalArgumentException("Axis.drawLabel: null state not permitted.");
        }
        if (string == null || string.equals("")) {
            return axisState;
        }
        Font font = this.getLabelFont();
        Insets insets = this.getLabelInsets();
        graphics2D.setFont(font);
        graphics2D.setPaint(this.getLabelPaint());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D3 = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
        if (rectangleEdge == RectangleEdge.TOP) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle(), rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d = rectangle2D2.getCenterX();
            double d2 = axisState.getCursor() - (double)insets.bottom - rectangle2D3.getHeight() / 2.0;
            RefineryUtilities.drawRotatedString(string, graphics2D, (float)d, (float)d2, TextAnchor.CENTER, TextAnchor.CENTER, this.getLabelAngle());
            axisState.cursorUp((double)insets.top + rectangle2D3.getHeight() + (double)insets.bottom);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle(), rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d = rectangle2D2.getCenterX();
            double d3 = axisState.getCursor() + (double)insets.top + rectangle2D3.getHeight() / 2.0;
            RefineryUtilities.drawRotatedString(string, graphics2D, (float)d, (float)d3, TextAnchor.CENTER, TextAnchor.CENTER, this.getLabelAngle());
            axisState.cursorDown((double)insets.top + rectangle2D3.getHeight() + (double)insets.bottom);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle() - 1.5707963267948966, rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d = axisState.getCursor() - (double)insets.right - rectangle2D3.getWidth() / 2.0;
            double d4 = rectangle2D2.getCenterY();
            RefineryUtilities.drawRotatedString(string, graphics2D, (float)d, (float)d4, TextAnchor.CENTER, TextAnchor.CENTER, this.getLabelAngle() - 1.5707963267948966);
            axisState.cursorLeft((double)insets.left + rectangle2D3.getWidth() + (double)insets.right);
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle() + 1.5707963267948966, rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d = axisState.getCursor() + (double)insets.left + rectangle2D3.getWidth() / 2.0;
            double d5 = rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0;
            RefineryUtilities.drawRotatedString(string, graphics2D, (float)d, (float)d5, TextAnchor.CENTER, TextAnchor.CENTER, this.getLabelAngle() + 1.5707963267948966);
            axisState.cursorRight((double)insets.left + rectangle2D3.getWidth() + (double)insets.right);
        }
        return axisState;
    }

    protected void drawAxisLine(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Line2D.Double double_ = null;
        if (rectangleEdge == RectangleEdge.TOP) {
            double_ = new Line2D.Double(rectangle2D.getX(), d, rectangle2D.getMaxX(), d);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            double_ = new Line2D.Double(rectangle2D.getX(), d, rectangle2D.getMaxX(), d);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            double_ = new Line2D.Double(d, rectangle2D.getY(), d, rectangle2D.getMaxY());
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            double_ = new Line2D.Double(d, rectangle2D.getY(), d, rectangle2D.getMaxY());
        }
        graphics2D.setPaint(this.axisLinePaint);
        graphics2D.setStroke(this.axisLineStroke);
        graphics2D.draw(double_);
    }

    public Object clone() throws CloneNotSupportedException {
        Axis axis = (Axis)super.clone();
        if (this.labelInsets != null) {
            axis.labelInsets = (Insets)this.labelInsets.clone();
        }
        if (this.tickLabelInsets != null) {
            axis.tickLabelInsets = (Insets)this.tickLabelInsets.clone();
        }
        axis.plot = null;
        axis.listenerList = new EventListenerList();
        return axis;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Axis) {
            boolean bl;
            Axis axis = (Axis)object;
            boolean bl2 = this.visible == axis.visible;
            boolean bl3 = ObjectUtils.equal(this.label, axis.label);
            boolean bl4 = ObjectUtils.equal(this.labelFont, axis.labelFont);
            boolean bl5 = ObjectUtils.equal(this.labelPaint, axis.labelPaint);
            boolean bl6 = ObjectUtils.equal(this.labelInsets, axis.labelInsets);
            boolean bl7 = Math.abs(this.labelAngle - axis.labelAngle) < 1.0E-7;
            boolean bl8 = this.axisLineVisible == axis.axisLineVisible;
            boolean bl9 = ObjectUtils.equal(this.axisLineStroke, axis.axisLineStroke);
            boolean bl10 = ObjectUtils.equal(this.axisLinePaint, axis.axisLinePaint);
            boolean bl11 = this.tickLabelsVisible == axis.tickLabelsVisible;
            boolean bl12 = ObjectUtils.equal(this.tickLabelFont, axis.tickLabelFont);
            boolean bl13 = ObjectUtils.equal(this.tickLabelPaint, axis.tickLabelPaint);
            boolean bl14 = ObjectUtils.equal(this.tickLabelInsets, axis.tickLabelInsets);
            boolean bl15 = this.tickMarksVisible == axis.tickMarksVisible;
            boolean bl16 = (double)Math.abs(this.tickMarkInsideLength - axis.tickMarkInsideLength) < 1.0E-6;
            boolean bl17 = (double)Math.abs(this.tickMarkOutsideLength - axis.tickMarkOutsideLength) < 1.0E-6;
            boolean bl18 = ObjectUtils.equal(this.tickMarkPaint, axis.tickMarkPaint);
            boolean bl19 = ObjectUtils.equal(this.tickMarkStroke, axis.tickMarkStroke);
            boolean bl20 = bl = Math.abs(this.fixedDimension - axis.fixedDimension) < 1.0E-6;
            return bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15 && bl16 && bl17 && bl18 && bl19 && bl;
        }
        return false;
    }
}

