/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleEdge;

public class XYShapeAnnotation
implements XYAnnotation,
Serializable {
    private Shape shape;
    private Stroke stroke;
    private Paint paint;

    public XYShapeAnnotation(Shape shape) {
        this(shape, new BasicStroke(1.0f), Color.black);
    }

    public XYShapeAnnotation(Shape shape, Stroke stroke, Paint paint) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.shape = shape;
        this.stroke = stroke;
        this.paint = paint;
    }

    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(xYPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(xYPlot.getRangeAxisLocation(), plotOrientation);
        double d = valueAxis.valueToJava2D(0.0, rectangle2D, rectangleEdge);
        double d2 = valueAxis2.valueToJava2D(0.0, rectangle2D, rectangleEdge2);
        double d3 = valueAxis.valueToJava2D(1.0, rectangle2D, rectangleEdge) - d;
        double d4 = valueAxis2.valueToJava2D(1.0, rectangle2D, rectangleEdge2) - d2;
        Shape shape = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            AffineTransform affineTransform = new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
            AffineTransform affineTransform2 = new AffineTransform(d4, 0.0, 0.0, d3, d2, d);
            shape = affineTransform.createTransformedShape(this.shape);
            shape = affineTransform2.createTransformedShape(shape);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            AffineTransform affineTransform = new AffineTransform(d3, 0.0, 0.0, d4, d, d2);
            shape = affineTransform.createTransformedShape(this.shape);
        }
        graphics2D.setPaint(this.paint);
        graphics2D.setStroke(this.stroke);
        graphics2D.draw(shape);
    }
}

