/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.util.ObjectUtils;

public class LegendItem
implements Serializable {
    private String label;
    private String description;
    private transient Shape shape;
    private boolean shapeFilled;
    private transient Paint paint;
    private transient Stroke stroke;
    private transient Paint outlinePaint;
    private transient Stroke outlineStroke;

    public LegendItem(String string, Paint paint) {
        this(string, string, new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0), true, paint, new BasicStroke(0.5f), Color.lightGray, new BasicStroke(0.5f));
    }

    public LegendItem(String string, String string2, Shape shape, boolean bl, Paint paint, Stroke stroke, Paint paint2, Stroke stroke2) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'label' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        if (paint2 == null) {
            throw new IllegalArgumentException("Null 'outlinePaint' argument.");
        }
        if (stroke2 == null) {
            throw new IllegalArgumentException("Null 'outlineStroke' argument.");
        }
        this.label = string;
        this.description = string2;
        this.shape = shape;
        this.shapeFilled = bl;
        this.paint = paint;
        this.stroke = stroke;
        this.outlinePaint = paint2;
        this.outlineStroke = stroke2;
    }

    public String getLabel() {
        return this.label;
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean isShapeFilled() {
        return this.shapeFilled;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof LegendItem) {
            LegendItem legendItem = (LegendItem)object;
            if (!this.label.equals(legendItem.label)) {
                return false;
            }
            if (!ObjectUtils.equal(this.description, legendItem.description)) {
                return false;
            }
            if (!ObjectUtils.equal(this.shape, legendItem.shape)) {
                return false;
            }
            if (this.shapeFilled != legendItem.shapeFilled) {
                return false;
            }
            if (!this.stroke.equals(legendItem.stroke)) {
                return false;
            }
            if (!this.paint.equals(legendItem.paint)) {
                return false;
            }
            if (!this.outlineStroke.equals(legendItem.outlineStroke)) {
                return false;
            }
            return this.outlinePaint.equals(legendItem.outlinePaint);
        }
        return false;
    }

    public LegendItem(String string, String string2, Shape shape, Paint paint, Paint paint2, Stroke stroke) {
        this(string, string2, shape, true, paint, paint2, stroke);
    }

    public LegendItem(String string, String string2, Shape shape, boolean bl, Paint paint, Paint paint2, Stroke stroke) {
        this.label = string;
        this.description = string2;
        this.shape = shape;
        this.shapeFilled = bl;
        this.paint = paint;
        this.outlinePaint = paint2;
        this.stroke = stroke;
    }
}

