/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.event.LegendChangeEvent;
import org.jfree.chart.event.LegendChangeListener;

public abstract class Legend
implements Serializable,
Cloneable {
    private static final int NORTHWEST = 160;
    private static final int NORTHEAST = 176;
    private static final int SOUTHEAST = 192;
    private static final int SOUTHWEST = 208;
    public static final int WEST = 0;
    public static final int WEST_NORTHWEST = 160;
    public static final int WEST_SOUTHWEST = 208;
    public static final int NORTH = 1;
    public static final int NORTH_NORTHWEST = 161;
    public static final int NORTH_NORTHEAST = 177;
    public static final int EAST = 2;
    public static final int EAST_NORTHEAST = 178;
    public static final int EAST_SOUTHEAST = 194;
    public static final int SOUTH = 3;
    public static final int SOUTH_SOUTHWEST = 211;
    public static final int SOUTH_SOUTHEAST = 195;
    protected static final int INVERTED = 2;
    protected static final int HORIZONTAL = 1;
    private int anchor = 3;
    private JFreeChart chart;
    private transient EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$0;

    public static Legend createInstance(JFreeChart jFreeChart) {
        return new StandardLegend();
    }

    public Legend() {
    }

    protected Legend(JFreeChart jFreeChart) {
        this();
        this.chart = jFreeChart;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    protected void registerChart(JFreeChart jFreeChart) {
        this.chart = jFreeChart;
    }

    public abstract Rectangle2D draw(Graphics2D var1, Rectangle2D var2, ChartRenderingInfo var3);

    public void addChangeListener(LegendChangeListener legendChangeListener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.event.LegendChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, legendChangeListener);
    }

    public void removeChangeListener(LegendChangeListener legendChangeListener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.event.LegendChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, legendChangeListener);
    }

    protected void notifyListeners(LegendChangeEvent legendChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            Object object = objectArray[n];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.jfree.chart.event.LegendChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((LegendChangeListener)objectArray[n + 1]).legendChanged(legendChangeEvent);
            }
            n -= 2;
        }
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int n) {
        if (this.isValidAnchor(n)) {
            this.anchor = n;
            this.notifyListeners(new LegendChangeEvent(this));
        }
    }

    private boolean isValidAnchor(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 160: 
            case 161: 
            case 177: 
            case 178: 
            case 194: 
            case 195: 
            case 208: 
            case 211: {
                return true;
            }
        }
        return false;
    }

    protected boolean isAnchoredToTop() {
        switch (this.anchor) {
            case 1: 
            case 160: 
            case 161: 
            case 177: 
            case 178: {
                return true;
            }
        }
        return false;
    }

    protected boolean isAnchoredToMiddle() {
        return this.anchor == 2 || this.anchor == 0;
    }

    protected boolean isAnchoredToBottom() {
        switch (this.anchor) {
            case 3: 
            case 194: 
            case 195: 
            case 208: 
            case 211: {
                return true;
            }
        }
        return false;
    }

    protected boolean isAnchoredToLeft() {
        switch (this.anchor) {
            case 0: 
            case 160: 
            case 161: 
            case 208: 
            case 211: {
                return true;
            }
        }
        return false;
    }

    protected boolean isAnchoredToRight() {
        switch (this.anchor) {
            case 2: 
            case 177: 
            case 178: 
            case 194: 
            case 195: {
                return true;
            }
        }
        return false;
    }

    protected boolean isAnchoredToCenter() {
        return this.anchor == 1 || this.anchor == 3;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Legend) {
            Legend legend = (Legend)object;
            return this.anchor == legend.anchor;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
    }

    protected Object clone() throws CloneNotSupportedException {
        Legend legend = (Legend)super.clone();
        this.listenerList = new EventListenerList();
        return legend;
    }
}

