/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.traits.MinOptMax;

class PageBreakingAlgorithm
extends BreakingAlgorithm {
    private LayoutManager topLevelLM;
    private PageSequenceLayoutManager.PageProvider pageProvider;
    private LinkedList pageBreaks = null;
    private ArrayList footnotesList = null;
    private ArrayList lengthList = null;
    private int totalFootnotesLength = 0;
    private int insertedFootnotesLength = 0;
    private boolean footnotesPending = false;
    private boolean newFootnotes = false;
    private int firstNewFootnoteIndex = 0;
    private int footnoteListIndex = 0;
    private int footnoteElementIndex = -1;
    private int splitFootnoteDemerits = 5000;
    private int deferredFootnoteDemerits = 10000;
    private MinOptMax footnoteSeparatorLength = null;
    private int storedPrevBreakIndex = -1;
    private int storedBreakIndex = -1;
    private boolean storedValue = false;
    private boolean autoHeight = false;

    public PageBreakingAlgorithm(LayoutManager topLevelLM, PageSequenceLayoutManager.PageProvider pageProvider, int alignment, int alignmentLast, MinOptMax footnoteSeparatorLength, boolean partOverflowRecovery, boolean autoHeight) {
        super(alignment, alignmentLast, true, partOverflowRecovery, 0);
        this.topLevelLM = topLevelLM;
        this.pageProvider = pageProvider;
        this.best = new BestPageRecords();
        this.footnoteSeparatorLength = (MinOptMax)footnoteSeparatorLength.clone();
        if (footnoteSeparatorLength.min == footnoteSeparatorLength.max) {
            footnoteSeparatorLength.max += 10000;
        }
        this.autoHeight = autoHeight;
    }

    protected void initialize() {
        super.initialize();
        this.insertedFootnotesLength = 0;
        this.footnoteListIndex = 0;
        this.footnoteElementIndex = -1;
    }

    protected BreakingAlgorithm.KnuthNode createNode(int position, int line, int fitness, int totalWidth, int totalStretch, int totalShrink, double adjustRatio, int availableShrink, int availableStretch, int difference, double totalDemerits, BreakingAlgorithm.KnuthNode previous) {
        return new KnuthPageNode(position, line, fitness, totalWidth, totalStretch, totalShrink, this.insertedFootnotesLength, this.footnoteListIndex, this.footnoteElementIndex, adjustRatio, availableShrink, availableStretch, difference, totalDemerits, previous);
    }

    protected BreakingAlgorithm.KnuthNode createNode(int position, int line, int fitness, int totalWidth, int totalStretch, int totalShrink) {
        return new KnuthPageNode(position, line, fitness, totalWidth, totalStretch, totalShrink, ((BestPageRecords)this.best).getFootnotesLength(fitness), ((BestPageRecords)this.best).getFootnoteListIndex(fitness), ((BestPageRecords)this.best).getFootnoteElementIndex(fitness), this.best.getAdjust(fitness), this.best.getAvailableShrink(fitness), this.best.getAvailableStretch(fitness), this.best.getDifference(fitness), this.best.getDemerits(fitness), this.best.getNode(fitness));
    }

    protected void handleBox(KnuthBox box) {
        if (box instanceof KnuthBlockBox && ((KnuthBlockBox)box).hasAnchors()) {
            this.handleFootnotes(((KnuthBlockBox)box).getElementLists());
            if (!this.newFootnotes) {
                this.newFootnotes = true;
                this.firstNewFootnoteIndex = this.footnotesList.size() - 1;
            }
        }
    }

    private void handleFootnotes(LinkedList elementLists) {
        if (!this.footnotesPending) {
            this.footnotesPending = true;
            this.footnotesList = new ArrayList();
            this.lengthList = new ArrayList();
            this.totalFootnotesLength = 0;
        }
        if (!this.newFootnotes) {
            this.newFootnotes = true;
            this.firstNewFootnoteIndex = this.footnotesList.size();
        }
        ListIterator elementListsIterator = elementLists.listIterator();
        while (elementListsIterator.hasNext()) {
            LinkedList noteList = (LinkedList)elementListsIterator.next();
            SpaceResolver.resolveElementList(noteList);
            int noteLength = 0;
            this.footnotesList.add(noteList);
            ListIterator noteListIterator = noteList.listIterator();
            while (noteListIterator.hasNext()) {
                KnuthElement element = (KnuthElement)noteListIterator.next();
                if (!element.isBox() && !element.isGlue()) continue;
                noteLength += element.getW();
            }
            int prevLength = this.lengthList.size() == 0 ? 0 : (Integer)this.lengthList.get(this.lengthList.size() - 1);
            this.lengthList.add(new Integer(prevLength + noteLength));
            this.totalFootnotesLength += noteLength;
        }
    }

    protected int restartFrom(BreakingAlgorithm.KnuthNode restartingNode, int currentIndex) {
        int returnValue = super.restartFrom(restartingNode, currentIndex);
        this.newFootnotes = false;
        if (this.footnotesPending) {
            for (int j = currentIndex; j >= restartingNode.position; --j) {
                KnuthElement resettedElement = this.getElement(j);
                if (!(resettedElement instanceof KnuthBlockBox) || !((KnuthBlockBox)resettedElement).hasAnchors()) continue;
                this.resetFootnotes(((KnuthBlockBox)resettedElement).getElementLists());
            }
        }
        return returnValue;
    }

    private void resetFootnotes(LinkedList elementLists) {
        for (int i = 0; i < elementLists.size(); ++i) {
            LinkedList removedList = (LinkedList)this.footnotesList.remove(this.footnotesList.size() - 1);
            this.lengthList.remove(this.lengthList.size() - 1);
            this.totalFootnotesLength = this.lengthList.size() > 0 ? (Integer)this.lengthList.get(this.lengthList.size() - 1) : 0;
        }
        if (this.footnotesList.size() == 0) {
            this.footnotesPending = false;
        }
    }

    protected void considerLegalBreak(KnuthElement element, int elementIdx) {
        super.considerLegalBreak(element, elementIdx);
        this.newFootnotes = false;
    }

    protected int computeDifference(BreakingAlgorithm.KnuthNode activeNode, KnuthElement element, int elementIndex) {
        int allFootnotes;
        KnuthPageNode pageNode = (KnuthPageNode)activeNode;
        int actualWidth = this.totalWidth - pageNode.totalWidth;
        if (element.isPenalty()) {
            actualWidth += element.getW();
        }
        if (this.footnotesPending && (allFootnotes = this.totalFootnotesLength - pageNode.totalFootnotes) > 0) {
            if ((actualWidth += this.footnoteSeparatorLength.opt) + allFootnotes <= this.getLineWidth()) {
                actualWidth += allFootnotes;
                this.insertedFootnotesLength = pageNode.totalFootnotes + allFootnotes;
                this.footnoteListIndex = this.footnotesList.size() - 1;
                this.footnoteElementIndex = ((LinkedList)this.footnotesList.get(this.footnoteListIndex)).size() - 1;
            } else {
                int footnoteSplit;
                boolean canDeferOldFootnotes = this.checkCanDeferOldFootnotes(pageNode, elementIndex);
                if ((canDeferOldFootnotes || this.newFootnotes) && (footnoteSplit = this.getFootnoteSplit(pageNode, this.getLineWidth() - actualWidth, canDeferOldFootnotes)) > 0) {
                    actualWidth += footnoteSplit;
                    this.insertedFootnotesLength = pageNode.totalFootnotes + footnoteSplit;
                } else {
                    actualWidth += allFootnotes;
                    this.insertedFootnotesLength = pageNode.totalFootnotes + allFootnotes;
                    this.footnoteListIndex = this.footnotesList.size() - 1;
                    this.footnoteElementIndex = ((LinkedList)this.footnotesList.get(this.footnoteListIndex)).size() - 1;
                }
            }
        }
        return this.getLineWidth(activeNode.line) - actualWidth;
    }

    private boolean checkCanDeferOldFootnotes(KnuthPageNode node, int contentElementIndex) {
        return this.noBreakBetween(node.position, contentElementIndex) && this.deferredFootnotes(node.footnoteListIndex, node.footnoteElementIndex, node.totalFootnotes);
    }

    private boolean noBreakBetween(int prevBreakIndex, int breakIndex) {
        if (this.storedPrevBreakIndex == -1 || (prevBreakIndex < this.storedPrevBreakIndex || breakIndex != this.storedBreakIndex || !this.storedValue) && (prevBreakIndex > this.storedPrevBreakIndex || breakIndex < this.storedBreakIndex || this.storedValue)) {
            int index = prevBreakIndex + 1;
            while (!this.par.getElement(index).isBox()) {
                ++index;
            }
            while (!(index > breakIndex || this.par.getElement(index).isGlue() && this.par.getElement(index - 1).isBox() || this.par.getElement(index).isPenalty() && ((KnuthElement)this.par.getElement(index)).getP() < 1000)) {
                ++index;
            }
            this.storedPrevBreakIndex = prevBreakIndex;
            this.storedBreakIndex = breakIndex;
            this.storedValue = index == breakIndex;
        }
        return this.storedValue;
    }

    private boolean deferredFootnotes(int listIndex, int elementIndex, int length) {
        return this.newFootnotes && this.firstNewFootnoteIndex != 0 && (listIndex < this.firstNewFootnoteIndex - 1 || elementIndex < ((LinkedList)this.footnotesList.get(listIndex)).size() - 1) || length < this.totalFootnotesLength;
    }

    private int getFootnoteSplit(KnuthPageNode activeNode, int availableLength, boolean canDeferOldFootnotes) {
        return this.getFootnoteSplit(activeNode.footnoteListIndex, activeNode.footnoteElementIndex, activeNode.totalFootnotes, availableLength, canDeferOldFootnotes);
    }

    private int getFootnoteSplit(int prevListIndex, int prevElementIndex, int prevLength, int availableLength, boolean canDeferOldFootnotes) {
        if (availableLength <= 0) {
            return 0;
        }
        int splitLength = 0;
        ListIterator noteListIterator = null;
        KnuthElement element = null;
        boolean somethingAdded = false;
        int elementIndex = prevElementIndex;
        int listIndex = prevListIndex;
        if (elementIndex == ((LinkedList)this.footnotesList.get(listIndex)).size() - 1) {
            ++listIndex;
            elementIndex = 0;
        } else {
            ++elementIndex;
        }
        if (this.footnotesList.size() - 1 > listIndex) {
            if (!canDeferOldFootnotes && this.newFootnotes && this.firstNewFootnoteIndex > 0) {
                splitLength = (Integer)this.lengthList.get(this.firstNewFootnoteIndex - 1) - prevLength;
                listIndex = this.firstNewFootnoteIndex;
                elementIndex = 0;
            }
            while ((Integer)this.lengthList.get(listIndex) - prevLength <= availableLength) {
                splitLength = (Integer)this.lengthList.get(listIndex) - prevLength;
                somethingAdded = true;
                ++listIndex;
                elementIndex = 0;
            }
        }
        noteListIterator = ((LinkedList)this.footnotesList.get(listIndex)).listIterator(elementIndex);
        int prevSplitLength = 0;
        int prevIndex = -1;
        int index = -1;
        block1: while (!somethingAdded || splitLength <= availableLength) {
            if (!somethingAdded) {
                somethingAdded = true;
            } else {
                prevSplitLength = splitLength;
                prevIndex = index;
            }
            boolean bPrevIsBox = false;
            while (noteListIterator.hasNext()) {
                element = (KnuthElement)noteListIterator.next();
                if (element.isBox()) {
                    splitLength += element.getW();
                    bPrevIsBox = true;
                    continue;
                }
                if (element.isGlue()) {
                    if (bPrevIsBox) {
                        index = noteListIterator.previousIndex();
                        continue block1;
                    }
                    bPrevIsBox = false;
                    splitLength += element.getW();
                    continue;
                }
                if (element.getP() >= 1000) continue;
                index = noteListIterator.previousIndex();
                continue block1;
            }
        }
        if (!somethingAdded) {
            prevSplitLength = 0;
        } else if (prevSplitLength > 0) {
            this.footnoteListIndex = prevIndex != -1 ? listIndex : listIndex - 1;
            this.footnoteElementIndex = prevIndex != -1 ? prevIndex : ((LinkedList)this.footnotesList.get(this.footnoteListIndex)).size() - 1;
        }
        return prevSplitLength;
    }

    protected double computeAdjustmentRatio(BreakingAlgorithm.KnuthNode activeNode, int difference) {
        if (difference > 0) {
            int maxAdjustment = this.totalStretch - activeNode.totalStretch;
            if (((KnuthPageNode)activeNode).totalFootnotes < this.totalFootnotesLength) {
                maxAdjustment += this.footnoteSeparatorLength.max - this.footnoteSeparatorLength.opt;
            }
            if (maxAdjustment > 0) {
                return (double)difference / (double)maxAdjustment;
            }
            return 1000.0;
        }
        if (difference < 0) {
            int maxAdjustment = this.totalShrink - activeNode.totalShrink;
            if (((KnuthPageNode)activeNode).totalFootnotes < this.totalFootnotesLength) {
                maxAdjustment += this.footnoteSeparatorLength.opt - this.footnoteSeparatorLength.min;
            }
            if (maxAdjustment > 0) {
                return (double)difference / (double)maxAdjustment;
            }
            return -1000.0;
        }
        return 0.0;
    }

    protected double computeDemerits(BreakingAlgorithm.KnuthNode activeNode, KnuthElement element, int fitnessClass, double r) {
        double demerits = 0.0;
        double f = Math.abs(r);
        f = 1.0 + 100.0 * f * f * f;
        if (element.isPenalty() && element.getP() >= 0) {
            demerits = (f += (double)element.getP()) * f;
        } else if (element.isPenalty() && !element.isForcedBreak()) {
            double penalty = element.getP();
            demerits = f * f - penalty * penalty;
        } else {
            demerits = f * f;
        }
        if (element.isPenalty() && ((KnuthPenalty)element).isFlagged() && this.getElement(activeNode.position).isPenalty() && ((KnuthPenalty)this.getElement(activeNode.position)).isFlagged()) {
            demerits += (double)this.repeatedFlaggedDemerit;
        }
        if (Math.abs(fitnessClass - activeNode.fitness) > 1) {
            demerits += (double)this.incompatibleFitnessDemerit;
        }
        if (this.footnotesPending) {
            if (this.footnoteListIndex < this.footnotesList.size() - 1) {
                demerits += (double)((this.footnotesList.size() - 1 - this.footnoteListIndex) * this.deferredFootnoteDemerits);
            }
            if (this.footnoteElementIndex < ((LinkedList)this.footnotesList.get(this.footnoteListIndex)).size() - 1) {
                demerits += (double)this.splitFootnoteDemerits;
            }
        }
        return demerits += activeNode.totalDemerits;
    }

    protected void finish() {
        for (int i = this.startLine; i < this.endLine; ++i) {
            KnuthPageNode node = (KnuthPageNode)this.getNode(i);
            while (node != null) {
                if (node.totalFootnotes < this.totalFootnotesLength) {
                    this.createFootnotePages(node);
                }
                node = (KnuthPageNode)node.next;
            }
        }
    }

    private void createFootnotePages(KnuthPageNode lastNode) {
        KnuthPageNode node;
        this.insertedFootnotesLength = lastNode.totalFootnotes;
        this.footnoteListIndex = lastNode.footnoteListIndex;
        this.footnoteElementIndex = lastNode.footnoteElementIndex;
        int availableBPD = this.getLineWidth();
        int split = 0;
        KnuthPageNode prevNode = lastNode;
        while (this.insertedFootnotesLength < this.totalFootnotesLength) {
            if ((Integer)this.lengthList.get(this.footnoteListIndex) - this.insertedFootnotesLength <= availableBPD) {
                availableBPD -= (Integer)this.lengthList.get(this.footnoteListIndex) - this.insertedFootnotesLength;
                this.insertedFootnotesLength = (Integer)this.lengthList.get(this.footnoteListIndex);
                this.footnoteElementIndex = ((LinkedList)this.footnotesList.get(this.footnoteListIndex)).size() - 1;
                continue;
            }
            split = this.getFootnoteSplit(this.footnoteListIndex, this.footnoteElementIndex, this.insertedFootnotesLength, availableBPD, true);
            if (split > 0) {
                availableBPD -= split;
                this.insertedFootnotesLength += split;
                continue;
            }
            node = (KnuthPageNode)this.createNode(lastNode.position, prevNode.line + 1, 1, this.insertedFootnotesLength - prevNode.totalFootnotes, 0, 0, 0.0, 0, 0, 0, 0.0, prevNode);
            this.addNode(node.line, node);
            this.removeNode(prevNode.line, prevNode);
            prevNode = node;
            availableBPD = this.getLineWidth();
        }
        node = (KnuthPageNode)this.createNode(lastNode.position, prevNode.line + 1, 1, this.totalFootnotesLength - prevNode.totalFootnotes, 0, 0, 0.0, 0, 0, 0, 0.0, prevNode);
        this.addNode(node.line, node);
        this.removeNode(prevNode.line, prevNode);
    }

    protected void removeNode(int line, BreakingAlgorithm.KnuthNode node) {
        BreakingAlgorithm.KnuthNode n = this.getNode(line);
        if (n != node) {
            if (this.footnotesPending) {
                BreakingAlgorithm.KnuthNode prevNode = null;
                while (n != node) {
                    prevNode = n;
                    n = n.next;
                }
                prevNode.next = n.next;
                if (prevNode.next == null) {
                    this.activeLines[line * 2 + 1] = prevNode;
                }
            } else {
                log.error((Object)"Should be first");
            }
        } else {
            this.activeLines[line * 2] = node.next;
            if (node.next == null) {
                this.activeLines[line * 2 + 1] = null;
            }
            while (this.startLine < this.endLine && this.getNode(this.startLine) == null) {
                ++this.startLine;
            }
        }
        --this.activeNodeCount;
    }

    public LinkedList getPageBreaks() {
        return this.pageBreaks;
    }

    public void insertPageBreakAsFirst(AbstractBreaker.PageBreakPosition pageBreak) {
        if (this.pageBreaks == null) {
            this.pageBreaks = new LinkedList();
        }
        this.pageBreaks.addFirst(pageBreak);
    }

    private int getPartCount() {
        if (this.pageBreaks == null) {
            return 0;
        }
        return this.pageBreaks.size();
    }

    public void updateData1(int total, double demerits) {
    }

    public void updateData2(BreakingAlgorithm.KnuthNode bestActiveNode, KnuthSequence sequence, int total) {
        int difference = bestActiveNode.difference;
        if (difference + bestActiveNode.availableShrink < 0 && !this.autoHeight && log.isWarnEnabled()) {
            log.warn((Object)FONode.decorateWithContextInfo("Part/page " + (this.getPartCount() + 1) + " overflows the available area in block-progression dimension.", this.getFObj()));
        }
        int blockAlignment = bestActiveNode.line < total ? this.alignment : this.alignmentLast;
        double ratio = bestActiveNode.adjustRatio;
        if (ratio < 0.0) {
            difference = 0;
        } else if (ratio <= 1.0 && bestActiveNode.line < total) {
            difference = 0;
        } else if (ratio > 1.0) {
            ratio = 1.0;
            difference -= bestActiveNode.availableStretch;
        } else {
            ratio = 0.0;
        }
        int firstListIndex = ((KnuthPageNode)bestActiveNode.previous).footnoteListIndex;
        int firstElementIndex = ((KnuthPageNode)bestActiveNode.previous).footnoteElementIndex;
        if (this.footnotesList != null && firstElementIndex == ((LinkedList)this.footnotesList.get(firstListIndex)).size() - 1) {
            ++firstListIndex;
            firstElementIndex = 0;
        } else {
            ++firstElementIndex;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("BBA> difference=" + difference + " ratio=" + ratio + " position=" + bestActiveNode.position));
        }
        this.insertPageBreakAsFirst(new AbstractBreaker.PageBreakPosition(this.topLevelLM, bestActiveNode.position, firstListIndex, firstElementIndex, ((KnuthPageNode)bestActiveNode).footnoteListIndex, ((KnuthPageNode)bestActiveNode).footnoteElementIndex, ratio, difference));
    }

    protected int filterActiveNodes() {
        BreakingAlgorithm.KnuthNode bestActiveNode = null;
        for (int i = this.startLine; i < this.endLine; ++i) {
            BreakingAlgorithm.KnuthNode node = this.getNode(i);
            while (node != null) {
                if (node != (bestActiveNode = this.compareNodes(bestActiveNode, node))) {
                    this.removeNode(i, node);
                }
                node = node.next;
            }
        }
        return bestActiveNode.line;
    }

    public LinkedList getFootnoteList(int index) {
        return (LinkedList)this.footnotesList.get(index);
    }

    public FObj getFObj() {
        return this.topLevelLM.getFObj();
    }

    protected int getLineWidth(int line) {
        int bpd = this.pageProvider != null ? this.pageProvider.getAvailableBPD(line) : super.getLineWidth(line);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getLineWidth(" + line + ") -> " + bpd));
        }
        return bpd;
    }

    protected class BestPageRecords
    extends BreakingAlgorithm.BestRecords {
        private int[] bestFootnotesLength = new int[4];
        private int[] bestFootnoteListIndex = new int[4];
        private int[] bestFootnoteElementIndex = new int[4];

        protected BestPageRecords() {
        }

        public void addRecord(double demerits, BreakingAlgorithm.KnuthNode node, double adjust, int availableShrink, int availableStretch, int difference, int fitness) {
            super.addRecord(demerits, node, adjust, availableShrink, availableStretch, difference, fitness);
            this.bestFootnotesLength[fitness] = PageBreakingAlgorithm.this.insertedFootnotesLength;
            this.bestFootnoteListIndex[fitness] = PageBreakingAlgorithm.this.footnoteListIndex;
            this.bestFootnoteElementIndex[fitness] = PageBreakingAlgorithm.this.footnoteElementIndex;
        }

        public int getFootnotesLength(int fitness) {
            return this.bestFootnotesLength[fitness];
        }

        public int getFootnoteListIndex(int fitness) {
            return this.bestFootnoteListIndex[fitness];
        }

        public int getFootnoteElementIndex(int fitness) {
            return this.bestFootnoteElementIndex[fitness];
        }
    }

    protected class KnuthPageNode
    extends BreakingAlgorithm.KnuthNode {
        public int totalFootnotes;
        public int footnoteListIndex;
        public int footnoteElementIndex;

        public KnuthPageNode(int position, int line, int fitness, int totalWidth, int totalStretch, int totalShrink, int totalFootnotes, int footnoteListIndex, int footnoteElementIndex, double adjustRatio, int availableShrink, int availableStretch, int difference, double totalDemerits, BreakingAlgorithm.KnuthNode previous) {
            super(position, line, fitness, totalWidth, totalStretch, totalShrink, adjustRatio, availableShrink, availableStretch, difference, totalDemerits, previous);
            this.totalFootnotes = totalFootnotes;
            this.footnoteListIndex = footnoteListIndex;
            this.footnoteElementIndex = footnoteElementIndex;
        }
    }
}

