/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.ext.awt.image.codec.FileCacheSeekableStream;
import org.apache.batik.ext.awt.image.codec.MemoryCacheSeekableStream;
import org.apache.batik.ext.awt.image.codec.SeekableStream;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.commons.io.IOUtils;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImage;

public abstract class BatikImage
extends AbstractFopImage {
    private byte[] softMask = null;
    protected SeekableStream seekableInput = null;
    protected CachableRed cr = null;

    public BatikImage(FopImage.ImageInfo imgReader) {
        super(imgReader);
    }

    protected boolean loadDimensions() {
        if (this.seekableInput == null && this.inputStream != null) {
            try {
                this.seekableInput = new FileCacheSeekableStream(this.inputStream);
            }
            catch (IOException ioe) {
                this.seekableInput = new MemoryCacheSeekableStream(this.inputStream);
            }
            try {
                this.bitsPerPixel = 8;
                this.cr = this.decodeImage(this.seekableInput);
                this.height = this.cr.getHeight();
                this.width = this.cr.getWidth();
                this.isTransparent = false;
                this.softMask = null;
                ColorModel cm = this.cr.getColorModel();
                this.height = this.cr.getHeight();
                this.width = this.cr.getWidth();
                this.isTransparent = false;
                this.softMask = null;
                int transparencyType = cm.getTransparency();
                if (cm instanceof IndexColorModel) {
                    if (transparencyType == 2) {
                        IndexColorModel icm = (IndexColorModel)cm;
                        int numColor = icm.getMapSize();
                        byte[] alpha = new byte[numColor];
                        icm.getAlphas(alpha);
                        for (int i = 0; i < numColor; ++i) {
                            if ((alpha[i] & 0xFF) != 0) continue;
                            this.isTransparent = true;
                            int red = icm.getRed(i) & 0xFF;
                            int grn = icm.getGreen(i) & 0xFF;
                            int blu = icm.getBlue(i) & 0xFF;
                            this.transparentColor = new Color(red, grn, blu);
                            break;
                        }
                    }
                } else {
                    this.cr = new Any2sRGBRed(this.cr);
                }
                cm = this.cr.getColorModel();
                if (this.colorSpace == null) {
                    this.colorSpace = cm.getColorSpace();
                }
            }
            catch (IOException ioe) {
                log.error((Object)("Error while loading image (Batik): " + ioe.getMessage()), (Throwable)ioe);
                IOUtils.closeQuietly((InputStream)this.seekableInput);
                IOUtils.closeQuietly((InputStream)this.inputStream);
                this.seekableInput = null;
                this.inputStream = null;
                return false;
            }
        }
        return this.height != -1;
    }

    protected boolean loadBitmap() {
        if (this.bitmaps == null) {
            this.loadImage();
        }
        return this.bitmaps != null;
    }

    public boolean hasSoftMask() {
        if (this.bitmaps == null && this.raw == null) {
            this.loadImage();
        }
        return this.softMask != null;
    }

    public byte[] getSoftMask() {
        if (this.bitmaps == null) {
            this.loadImage();
        }
        return this.softMask;
    }

    protected abstract CachableRed decodeImage(SeekableStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadImage() {
        if (!this.loadDimensions()) return;
        try {
            try {
                if (this.cr == null) {
                    throw new IllegalStateException("Can't load the bitmaps data without the CachableRed instance");
                }
                ColorModel cm = this.cr.getColorModel();
                if (!this.isTransparent && cm.hasAlpha()) {
                    this.softMask = new byte[this.width * this.height];
                }
                this.bitmaps = new byte[this.width * this.height * 3];
                WritableRaster wr = (WritableRaster)this.cr.getData();
                BufferedImage bi = new BufferedImage(cm, wr.createWritableTranslatedChild(0, 0), cm.isAlphaPremultiplied(), null);
                int[] tmpMap = new int[this.width];
                int idx = 0;
                int sfIdx = 0;
                for (int y = 0; y < this.height; ++y) {
                    int pix;
                    int x;
                    tmpMap = bi.getRGB(0, y, this.width, 1, tmpMap, 0, this.width);
                    if (this.softMask != null) {
                        for (x = 0; x < this.width; ++x) {
                            pix = tmpMap[x];
                            this.softMask[sfIdx++] = (byte)(pix >>> 24);
                            this.bitmaps[idx++] = (byte)(pix >>> 16 & 0xFF);
                            this.bitmaps[idx++] = (byte)(pix >>> 8 & 0xFF);
                            this.bitmaps[idx++] = (byte)(pix & 0xFF);
                        }
                        continue;
                    }
                    for (x = 0; x < this.width; ++x) {
                        pix = tmpMap[x];
                        this.bitmaps[idx++] = (byte)(pix >> 16 & 0xFF);
                        this.bitmaps[idx++] = (byte)(pix >> 8 & 0xFF);
                        this.bitmaps[idx++] = (byte)(pix & 0xFF);
                    }
                }
                Object var11_11 = null;
            }
            catch (Exception ex) {
                log.error((Object)("Error while loading image (Batik): " + ex.getMessage()), (Throwable)ex);
                Object var11_12 = null;
                IOUtils.closeQuietly((InputStream)this.seekableInput);
                IOUtils.closeQuietly((InputStream)this.inputStream);
                this.seekableInput = null;
                this.inputStream = null;
                this.cr = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            IOUtils.closeQuietly((InputStream)this.seekableInput);
            IOUtils.closeQuietly((InputStream)this.inputStream);
            this.seekableInput = null;
            this.inputStream = null;
            this.cr = null;
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)this.seekableInput);
        IOUtils.closeQuietly((InputStream)this.inputStream);
        this.seekableInput = null;
        this.inputStream = null;
        this.cr = null;
    }
}

