/*
 * Decompiled with CFR 0.152.
 */
package launcher.ipc;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Logger;
import launcher.ipc.CallHandler;
import launcher.ipc.IPCHelper;

public class Server {
    private static final Logger LOG = Logger.getLogger("genj.ipc");
    private int maxBuffer = 256;
    private ServerSocket local;
    private CallHandler handler;
    private int timeout = 200;
    private String[] terminators = IPCHelper.TERMINATORS;
    private Thread thread;

    public Server(int port, CallHandler handler) throws IOException {
        this.handler = handler;
        this.local = new ServerSocket(port);
        this.thread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Server.this.read();
                        }
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() throws IOException {
        Socket remote = this.local.accept();
        try {
            remote.setSoTimeout(this.timeout);
            String in = IPCHelper.read(remote.getInputStream(), this.terminators, this.maxBuffer);
            String out = this.handler.handleCall(in);
            IPCHelper.write(remote.getOutputStream(), out + this.terminators[0]);
        }
        catch (IOException e) {
            LOG.info(e.getMessage() + " (" + remote.getRemoteSocketAddress() + ")");
        }
        finally {
            remote.close();
        }
    }
}

