/*
 * Decompiled with CFR 0.152.
 */
package launcher.ipc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

class IPCHelper {
    static final String[] TERMINATORS = new String[]{"\n\n", "\r\n\r\n"};

    IPCHelper() {
    }

    static String read(InputStream stream, String[] terminators, int max) throws IOException {
        int read;
        InputStreamReader in = new InputStreamReader(stream);
        char[] buffer = new char[max];
        int msglen = 0;
        block0: while ((read = ((Reader)in).read(buffer, msglen, buffer.length - msglen)) >= 0 && (msglen += read) != buffer.length) {
            String snapshot = new String(buffer, 0, msglen);
            for (int i = 0; i < terminators.length; ++i) {
                if (!snapshot.endsWith(terminators[i])) continue;
                msglen -= terminators[i].length();
                break block0;
            }
        }
        return new String(buffer, 0, msglen);
    }

    static void write(OutputStream stream, String string) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(stream, Charset.forName("utf8"));
        out.write(string);
        ((Writer)out).flush();
    }
}

