/*
 * Decompiled with CFR 0.152.
 */
package swingx.dnd.tree;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import swingx.dnd.ObjectTransferable;
import swingx.dnd.tree.DnDTreeModel;
import swingx.tree.AbstractTreeModel;

public abstract class AbstractDnDTreeModel
extends AbstractTreeModel
implements DnDTreeModel {
    private static AbstractDnDTreeModel currentDrag;
    private static boolean dragYielded;

    public Transferable createTransferable(Object[] nodes) {
        currentDrag = this;
        dragYielded = false;
        return new ObjectTransferable(nodes);
    }

    protected Object[] getNodes(Transferable transferable) throws UnsupportedFlavorException, IOException {
        return (Object[])ObjectTransferable.getObject(transferable);
    }

    public int getDragActions(Transferable transferable) {
        try {
            return this.getDragActions(this.getNodes(transferable));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected int getDragActions(Object[] nodes) {
        for (int c = 0; c < nodes.length; ++c) {
            if (this.getParent(nodes[c]) != null) continue;
            return 0;
        }
        return 2;
    }

    public int getDropActions(Transferable transferable, Object parent, int index) {
        try {
            return this.getDropActions((Object[])ObjectTransferable.getObject(transferable), parent, index);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    protected int getDropActions(Object[] nodes, Object parent, int index) {
        for (int c = 0; c < nodes.length; ++c) {
            if (!this.isNodeAncestor(nodes[c], parent)) continue;
            return 0;
        }
        return 2;
    }

    public void drag(Transferable transferable, int action) throws UnsupportedFlavorException, IOException {
        if (!dragYielded && action == 2) {
            Object[] nodes = this.getNodes(transferable);
            for (int n = nodes.length - 1; n >= 0; --n) {
                this.removeNodeFromParent(nodes[n]);
            }
        }
    }

    protected abstract void removeNodeFromParent(Object var1);

    public void drop(Transferable transferable, Object parent, int index, int action) throws UnsupportedFlavorException, IOException {
        if (action != 2) {
            throw new IllegalArgumentException("action not supported: " + action);
        }
        if (currentDrag != null) {
            index = this.yieldDrag(transferable, parent, index, action);
        }
        Object[] nodes = this.getNodes(transferable);
        for (int n = 0; n < nodes.length; ++n) {
            this.insertNodeInto(nodes[n], parent, index + n);
        }
    }

    protected int yieldDrag(Transferable transferable, Object parent, int index, int action) throws UnsupportedFlavorException, IOException {
        Object[] nodes = this.getNodes(transferable);
        for (int n = 0; n < nodes.length; ++n) {
            if (this.getParent(nodes[n]) != parent || this.getIndexOfChild(parent, nodes[n]) >= index) continue;
            --index;
        }
        currentDrag.drag(transferable, action);
        dragYielded = true;
        return index;
    }

    protected abstract void insertNodeInto(Object var1, Object var2, int var3);

    public void releaseTransferable(Transferable transferable) {
        currentDrag = null;
        dragYielded = false;
    }

    private boolean isNodeAncestor(Object ancestoreCandidate, Object node) {
        do {
            if (ancestoreCandidate != node) continue;
            return true;
        } while ((node = this.getParent(node)) != null);
        return false;
    }
}

